/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.jenkins.plugins.data;

import com.google.common.base.Strings;
import com.stackrox.jenkins.plugins.data.SeverityUtil;
import com.stackrox.model.StorageEmbeddedVulnerability;
import javax.annotation.Nonnull;
import lombok.Generated;

public class CVE {
    private final String id;
    private final Float cvssScore;
    private final String scoreType;
    private final String packageName;
    private final String packageVersion;
    private final boolean fixable;
    private final String link;
    private final String severity;
    private final String advisory;
    private final String advisoryLink;

    public CVE(String packageName, String packageVersion, @Nonnull StorageEmbeddedVulnerability vulnerability) {
        this(vulnerability.getCve(), vulnerability.getCvss(), vulnerability.getScoreVersion() != null ? vulnerability.getScoreVersion().toString() : null, packageName, packageVersion, !Strings.isNullOrEmpty((String)vulnerability.getFixedBy()), vulnerability.getLink(), SeverityUtil.prettySeverity(vulnerability.getSeverity()), vulnerability.getAdvisory() != null ? vulnerability.getAdvisory().getName() : null, vulnerability.getAdvisory() != null ? vulnerability.getAdvisory().getLink() : null);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Float getCvssScore() {
        return this.cvssScore;
    }

    @Generated
    public String getScoreType() {
        return this.scoreType;
    }

    @Generated
    public String getPackageName() {
        return this.packageName;
    }

    @Generated
    public String getPackageVersion() {
        return this.packageVersion;
    }

    @Generated
    public boolean isFixable() {
        return this.fixable;
    }

    @Generated
    public String getLink() {
        return this.link;
    }

    @Generated
    public String getSeverity() {
        return this.severity;
    }

    @Generated
    public String getAdvisory() {
        return this.advisory;
    }

    @Generated
    public String getAdvisoryLink() {
        return this.advisoryLink;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CVE)) {
            return false;
        }
        CVE other = (CVE)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFixable() != other.isFixable()) {
            return false;
        }
        Float this$cvssScore = this.getCvssScore();
        Float other$cvssScore = other.getCvssScore();
        if (this$cvssScore == null ? other$cvssScore != null : !((Object)this$cvssScore).equals(other$cvssScore)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$scoreType = this.getScoreType();
        String other$scoreType = other.getScoreType();
        if (this$scoreType == null ? other$scoreType != null : !this$scoreType.equals(other$scoreType)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$packageVersion = this.getPackageVersion();
        String other$packageVersion = other.getPackageVersion();
        if (this$packageVersion == null ? other$packageVersion != null : !this$packageVersion.equals(other$packageVersion)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        String this$severity = this.getSeverity();
        String other$severity = other.getSeverity();
        if (this$severity == null ? other$severity != null : !this$severity.equals(other$severity)) {
            return false;
        }
        String this$advisory = this.getAdvisory();
        String other$advisory = other.getAdvisory();
        if (this$advisory == null ? other$advisory != null : !this$advisory.equals(other$advisory)) {
            return false;
        }
        String this$advisoryLink = this.getAdvisoryLink();
        String other$advisoryLink = other.getAdvisoryLink();
        return !(this$advisoryLink == null ? other$advisoryLink != null : !this$advisoryLink.equals(other$advisoryLink));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CVE;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFixable() ? 79 : 97);
        Float $cvssScore = this.getCvssScore();
        result = result * 59 + ($cvssScore == null ? 43 : ((Object)$cvssScore).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $scoreType = this.getScoreType();
        result = result * 59 + ($scoreType == null ? 43 : $scoreType.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $packageVersion = this.getPackageVersion();
        result = result * 59 + ($packageVersion == null ? 43 : $packageVersion.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        String $severity = this.getSeverity();
        result = result * 59 + ($severity == null ? 43 : $severity.hashCode());
        String $advisory = this.getAdvisory();
        result = result * 59 + ($advisory == null ? 43 : $advisory.hashCode());
        String $advisoryLink = this.getAdvisoryLink();
        result = result * 59 + ($advisoryLink == null ? 43 : $advisoryLink.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CVE(id=" + this.getId() + ", cvssScore=" + this.getCvssScore() + ", scoreType=" + this.getScoreType() + ", packageName=" + this.getPackageName() + ", packageVersion=" + this.getPackageVersion() + ", fixable=" + this.isFixable() + ", link=" + this.getLink() + ", severity=" + this.getSeverity() + ", advisory=" + this.getAdvisory() + ", advisoryLink=" + this.getAdvisoryLink() + ")";
    }

    @Generated
    public CVE(String id, Float cvssScore, String scoreType, String packageName, String packageVersion, boolean fixable, String link, String severity, String advisory, String advisoryLink) {
        this.id = id;
        this.cvssScore = cvssScore;
        this.scoreType = scoreType;
        this.packageName = packageName;
        this.packageVersion = packageVersion;
        this.fixable = fixable;
        this.link = link;
        this.severity = severity;
        this.advisory = advisory;
        this.advisoryLink = advisoryLink;
    }
}

