/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.jenkins.plugins;

import com.stackrox.jenkins.plugins.data.ImageCheckResults;
import hudson.model.Action;
import hudson.model.Run;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import lombok.Generated;

public class ViewStackroxResultsAction
implements Action {
    private final List<ImageCheckResults> results;
    private final Run<?, ?> build;

    public String getIconFileName() {
        return Jenkins.RESOURCE_PATH + "/plugin/stackrox-container-image-scanner/images/sr-logo.png";
    }

    public String getDisplayName() {
        return "StackRox Report for " + this.getNames().collect(Collectors.joining(", "));
    }

    public String getUrlName() {
        String images = this.getNames().collect(Collectors.joining("-"));
        return String.format("stackrox-image-security-results-%08x", images.hashCode());
    }

    private Stream<String> getNames() {
        return this.getResults().stream().map(ImageCheckResults::getImageName);
    }

    @Generated
    public ViewStackroxResultsAction(List<ImageCheckResults> results, Run<?, ?> build) {
        this.results = results;
        this.build = build;
    }

    @Generated
    public List<ImageCheckResults> getResults() {
        return this.results;
    }

    @Generated
    public Run<?, ?> getBuild() {
        return this.build;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewStackroxResultsAction)) {
            return false;
        }
        ViewStackroxResultsAction other = (ViewStackroxResultsAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ImageCheckResults> this$results = this.getResults();
        List<ImageCheckResults> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        Run<?, ?> this$build = this.getBuild();
        Run<?, ?> other$build = other.getBuild();
        return !(this$build == null ? other$build != null : !this$build.equals(other$build));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ViewStackroxResultsAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ImageCheckResults> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        Run<?, ?> $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : $build.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ViewStackroxResultsAction(results=" + this.getResults() + ", build=" + this.getBuild() + ")";
    }
}

