/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.jenkins.plugins;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stackrox.api.AuthServiceApi;
import com.stackrox.invoker.ApiClient;
import com.stackrox.invoker.ApiException;
import com.stackrox.jenkins.plugins.Messages;
import com.stackrox.jenkins.plugins.PolicyEvalException;
import com.stackrox.jenkins.plugins.ViewStackroxResultsAction;
import com.stackrox.jenkins.plugins.data.CVE;
import com.stackrox.jenkins.plugins.data.ImageCheckResults;
import com.stackrox.jenkins.plugins.data.PolicyViolation;
import com.stackrox.jenkins.plugins.jenkins.RunConfig;
import com.stackrox.jenkins.plugins.report.ReportGenerator;
import com.stackrox.jenkins.plugins.services.ApiClientFactory;
import com.stackrox.jenkins.plugins.services.DetectionService;
import com.stackrox.jenkins.plugins.services.ImageService;
import com.stackrox.jenkins.plugins.services.ServiceException;
import com.stackrox.model.V1AuthStatus;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.UrlValidator;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class StackroxBuilder
extends Builder
implements SimpleBuildStep {
    private String portalAddress;
    @DataBoundSetter
    private String imageNames;
    private Secret apiToken = Secret.fromString((String)"");
    @DataBoundSetter
    private boolean failOnPolicyEvalFailure;
    @DataBoundSetter
    private boolean failOnCriticalPluginError;
    @DataBoundSetter
    private boolean enableTLSVerification;
    @DataBoundSetter
    private String caCertPEM;
    @DataBoundSetter
    private String cluster;
    @DataBoundSetter
    private int readTimeoutSeconds = 60;
    private RunConfig runConfig;

    @DataBoundConstructor
    public StackroxBuilder() {
    }

    private ApiClientFactory.StackRoxTlsValidationMode getTLSValidationMode() {
        return this.enableTLSVerification ? ApiClientFactory.StackRoxTlsValidationMode.VALIDATE : ApiClientFactory.StackRoxTlsValidationMode.INSECURE_ACCEPT_ANY;
    }

    private List<String> getImages() {
        return ImmutableList.copyOf((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)Strings.nullToEmpty((String)this.getImageNames())));
    }

    @DataBoundSetter
    public void setPortalAddress(String portalAddress) {
        this.portalAddress = CharMatcher.is((char)'/').trimTrailingFrom((CharSequence)portalAddress);
    }

    @DataBoundSetter
    public void setApiToken(String apiToken) {
        this.apiToken = Secret.fromString((String)apiToken);
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        this.runConfig = RunConfig.create(listener.getLogger(), (String)run.getCharacteristicEnvVars().get((Object)"BUILD_TAG"), workspace, this.getImages());
        try {
            List<ImageCheckResults> results = this.checkImages();
            ReportGenerator.generateBuildReport(results, this.runConfig.getReportsDir());
            this.prepareArtifacts(run, workspace, launcher, listener);
            run.addAction((Action)new ViewStackroxResultsAction(results, run));
            this.cleanupJenkinsWorkspace();
            if (this.enforcedPolicyViolationExists(results)) {
                throw new PolicyEvalException("At least one image violated at least one enforced system policy. Marking StackRox Image Security plugin build step failed. Check the report for additional details.");
            }
        }
        catch (IOException e) {
            if (this.failOnCriticalPluginError) {
                throw new AbortException(String.format("Fatal error: %s. Aborting ...", e.getMessage()));
            }
            this.runConfig.getLog().println("Marking StackRox Image Security plugin build step as successful despite error.");
        }
        catch (PolicyEvalException e) {
            if (this.failOnPolicyEvalFailure) {
                throw new AbortException(e.getMessage());
            }
            this.runConfig.getLog().println("Marking StackRox Image Security plugin build step as successful despite enforced policy violations.");
        }
        this.runConfig.getLog().println("No system policy violations found. Marking StackRox Image Security plugin build step as successful.");
    }

    private void prepareArtifacts(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        ArtifactArchiver artifactArchiver = new ArtifactArchiver(this.runConfig.getArtifactsRelativePath());
        artifactArchiver.setAllowEmptyArchive(true);
        artifactArchiver.perform(run, workspace, launcher, listener);
    }

    private List<ImageCheckResults> checkImages() throws IOException {
        ArrayList results = Lists.newArrayList();
        ApiClient apiClient = ApiClientFactory.newApiClient(this.getPortalAddress(), this.getApiToken().getPlainText(), this.getCaCertPEM(), this.getTLSValidationMode(), this.getReadTimeoutSeconds());
        ImageService imageService = new ImageService(apiClient);
        DetectionService detectionService = new DetectionService(apiClient);
        for (String name : this.runConfig.getImageNames()) {
            this.runConfig.getLog().printf("Checking image %s...%n", name);
            List<CVE> cves = imageService.getImageScanResults(name, this.cluster);
            List<PolicyViolation> violatedPolicies = detectionService.getPolicyViolations(name, this.cluster);
            results.add(new ImageCheckResults(name, cves, violatedPolicies));
        }
        results.sort((result1, result2) -> Boolean.compare(result1.isStatusPass(), result2.isStatusPass()));
        return results;
    }

    private boolean enforcedPolicyViolationExists(List<ImageCheckResults> results) {
        for (ImageCheckResults result : results) {
            if (result.isStatusPass()) continue;
            return true;
        }
        return false;
    }

    private void cleanupJenkinsWorkspace() {
        this.runConfig.getLog().println("Cleaning up the workspace ...");
        try {
            this.runConfig.getBaseWorkDir().deleteRecursive();
            this.runConfig.getReportsDir().deleteRecursive();
        }
        catch (IOException | InterruptedException e) {
            this.runConfig.getLog().println("WARN: Failed to cleanup.");
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Generated
    public String getPortalAddress() {
        return this.portalAddress;
    }

    @Generated
    public String getImageNames() {
        return this.imageNames;
    }

    @Generated
    public Secret getApiToken() {
        return this.apiToken;
    }

    @Generated
    public boolean isFailOnPolicyEvalFailure() {
        return this.failOnPolicyEvalFailure;
    }

    @Generated
    public boolean isFailOnCriticalPluginError() {
        return this.failOnCriticalPluginError;
    }

    @Generated
    public boolean isEnableTLSVerification() {
        return this.enableTLSVerification;
    }

    @Generated
    public String getCaCertPEM() {
        return this.caCertPEM;
    }

    @Generated
    public String getCluster() {
        return this.cluster;
    }

    @Generated
    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    @Generated
    public RunConfig getRunConfig() {
        return this.runConfig;
    }

    @Generated
    public void setImageNames(String imageNames) {
        this.imageNames = imageNames;
    }

    @Generated
    public void setFailOnPolicyEvalFailure(boolean failOnPolicyEvalFailure) {
        this.failOnPolicyEvalFailure = failOnPolicyEvalFailure;
    }

    @Generated
    public void setFailOnCriticalPluginError(boolean failOnCriticalPluginError) {
        this.failOnCriticalPluginError = failOnCriticalPluginError;
    }

    @Generated
    public void setEnableTLSVerification(boolean enableTLSVerification) {
        this.enableTLSVerification = enableTLSVerification;
    }

    @Generated
    public void setCaCertPEM(String caCertPEM) {
        this.caCertPEM = caCertPEM;
    }

    @Generated
    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    @Generated
    public void setReadTimeoutSeconds(int readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
    }

    @Generated
    public void setRunConfig(RunConfig runConfig) {
        this.runConfig = runConfig;
    }

    @Symbol(value={"stackrox"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.StackroxBuilder_DescriptorImpl_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }

        public FormValidation doCheckPortalAddress(@QueryParameter String portalAddress) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String[] schemes = new String[]{"https"};
            UrlValidator urlValidator = new UrlValidator(schemes, 8L);
            if (!Strings.isNullOrEmpty((String)portalAddress) && urlValidator.isValid(portalAddress)) {
                return FormValidation.ok();
            }
            UrlValidator regexUrlValidator = new UrlValidator(schemes, new RegexValidator("^([\\\\p{Alnum}\\\\-\\\\.]*)(:\\\\d*)?(.*)?"), 8L);
            if (regexUrlValidator.isValid(portalAddress)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.StackroxBuilder_InvalidPortalAddressError());
        }

        public FormValidation doCheckApiToken(@QueryParameter String apiToken) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (!Strings.isNullOrEmpty((String)apiToken)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.StackroxBuilder_EmptyAPITokenError());
        }

        public FormValidation doCheckReadTimeoutSeconds(@QueryParameter int readTimeoutSeconds) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (readTimeoutSeconds > 0 && readTimeoutSeconds <= 3600) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Read timeout must be between 1 and 3600 seconds.");
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="portalAddress") String portalAddress, @QueryParameter(value="apiToken") String apiToken, @QueryParameter(value="enableTLSVerification") boolean tlsVerify, @QueryParameter(value="caCertPEM") String caCertPEM) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                if (this.checkRoxAuthStatus(portalAddress, apiToken, tlsVerify, caCertPEM)) {
                    return FormValidation.ok((String)"Success");
                }
                return FormValidation.error((String)"Invalid credentials, user not authenticated");
            }
            catch (Exception ex) {
                Throwable e = Throwables.getRootCause((Throwable)ex);
                if (e instanceof ServiceException) {
                    return FormValidation.error((Throwable)e, (String)"Invalid response from StackRox portal");
                }
                if (e instanceof UnknownHostException) {
                    return FormValidation.error((Throwable)e, (String)("Unknown host: " + portalAddress));
                }
                if (e instanceof SSLException) {
                    return FormValidation.error((Throwable)e, (String)"Could not validate TLS");
                }
                if (e instanceof SocketException) {
                    return FormValidation.error((Throwable)e, (String)"Connection error");
                }
                return FormValidation.error((Throwable)ex, (String)"Failed to connect to StackRox portal, please provide a valid portal address and API token");
            }
        }

        private boolean checkRoxAuthStatus(String portalAddress, String apiToken, boolean tlsVerify, String caCertPEM) throws IOException {
            ApiClient apiClient = ApiClientFactory.newApiClient(portalAddress, apiToken, caCertPEM, this.validationMode(tlsVerify), 10);
            try {
                V1AuthStatus status = new AuthServiceApi(apiClient).authServiceGetAuthStatus();
                return !Strings.isNullOrEmpty((String)status.getUserId());
            }
            catch (ApiException e) {
                throw ServiceException.fromApiException("Could not get auth status", e);
            }
        }

        private ApiClientFactory.StackRoxTlsValidationMode validationMode(boolean tlsVerify) {
            return tlsVerify ? ApiClientFactory.StackRoxTlsValidationMode.VALIDATE : ApiClientFactory.StackRoxTlsValidationMode.INSECURE_ACCEPT_ANY;
        }
    }
}

