/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.api;

import com.google.gson.reflect.TypeToken;
import com.stackrox.invoker.ApiCallback;
import com.stackrox.invoker.ApiClient;
import com.stackrox.invoker.ApiException;
import com.stackrox.invoker.ApiResponse;
import com.stackrox.invoker.Configuration;
import com.stackrox.invoker.Pair;
import com.stackrox.model.ComputeEffectiveAccessScopeRequestPayload;
import com.stackrox.model.RoleServicePutPermissionSetBody;
import com.stackrox.model.RoleServicePutSimpleAccessScopeBody;
import com.stackrox.model.RoleServiceUpdateRoleBody;
import com.stackrox.model.StorageEffectiveAccessScope;
import com.stackrox.model.StoragePermissionSet;
import com.stackrox.model.StorageRole;
import com.stackrox.model.StorageSimpleAccessScope;
import com.stackrox.model.V1GetClustersForPermissionsResponse;
import com.stackrox.model.V1GetNamespacesForClusterAndPermissionsResponse;
import com.stackrox.model.V1GetPermissionsResponse;
import com.stackrox.model.V1GetResourcesResponse;
import com.stackrox.model.V1GetRolesResponse;
import com.stackrox.model.V1ListPermissionSetsResponse;
import com.stackrox.model.V1ListSimpleAccessScopesResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class RoleServiceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public RoleServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleServiceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call roleServiceComputeEffectiveAccessScopeCall(@Nonnull ComputeEffectiveAccessScopeRequestPayload computeEffectiveAccessScopeRequestPayload, @Nullable String detail, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ComputeEffectiveAccessScopeRequestPayload localVarPostBody = computeEffectiveAccessScopeRequestPayload;
        String localVarPath = "/v1/computeeffectiveaccessscope";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (detail != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("detail", detail));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceComputeEffectiveAccessScopeValidateBeforeCall(@Nonnull ComputeEffectiveAccessScopeRequestPayload computeEffectiveAccessScopeRequestPayload, @Nullable String detail, ApiCallback _callback) throws ApiException {
        if (computeEffectiveAccessScopeRequestPayload == null) {
            throw new ApiException("Missing the required parameter 'computeEffectiveAccessScopeRequestPayload' when calling roleServiceComputeEffectiveAccessScope(Async)");
        }
        return this.roleServiceComputeEffectiveAccessScopeCall(computeEffectiveAccessScopeRequestPayload, detail, _callback);
    }

    public StorageEffectiveAccessScope roleServiceComputeEffectiveAccessScope(@Nonnull ComputeEffectiveAccessScopeRequestPayload computeEffectiveAccessScopeRequestPayload, @Nullable String detail) throws ApiException {
        ApiResponse<StorageEffectiveAccessScope> localVarResp = this.roleServiceComputeEffectiveAccessScopeWithHttpInfo(computeEffectiveAccessScopeRequestPayload, detail);
        return localVarResp.getData();
    }

    public ApiResponse<StorageEffectiveAccessScope> roleServiceComputeEffectiveAccessScopeWithHttpInfo(@Nonnull ComputeEffectiveAccessScopeRequestPayload computeEffectiveAccessScopeRequestPayload, @Nullable String detail) throws ApiException {
        Call localVarCall = this.roleServiceComputeEffectiveAccessScopeValidateBeforeCall(computeEffectiveAccessScopeRequestPayload, detail, null);
        Type localVarReturnType = new TypeToken<StorageEffectiveAccessScope>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceComputeEffectiveAccessScopeAsync(@Nonnull ComputeEffectiveAccessScopeRequestPayload computeEffectiveAccessScopeRequestPayload, @Nullable String detail, ApiCallback<StorageEffectiveAccessScope> _callback) throws ApiException {
        Call localVarCall = this.roleServiceComputeEffectiveAccessScopeValidateBeforeCall(computeEffectiveAccessScopeRequestPayload, detail, _callback);
        Type localVarReturnType = new TypeToken<StorageEffectiveAccessScope>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceCreateRoleCall(@Nonnull String name, @Nonnull StorageRole storageRole, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        StorageRole localVarPostBody = storageRole;
        String localVarPath = "/v1/roles/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceCreateRoleValidateBeforeCall(@Nonnull String name, @Nonnull StorageRole storageRole, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling roleServiceCreateRole(Async)");
        }
        if (storageRole == null) {
            throw new ApiException("Missing the required parameter 'storageRole' when calling roleServiceCreateRole(Async)");
        }
        return this.roleServiceCreateRoleCall(name, storageRole, _callback);
    }

    public Object roleServiceCreateRole(@Nonnull String name, @Nonnull StorageRole storageRole) throws ApiException {
        ApiResponse<Object> localVarResp = this.roleServiceCreateRoleWithHttpInfo(name, storageRole);
        return localVarResp.getData();
    }

    public ApiResponse<Object> roleServiceCreateRoleWithHttpInfo(@Nonnull String name, @Nonnull StorageRole storageRole) throws ApiException {
        Call localVarCall = this.roleServiceCreateRoleValidateBeforeCall(name, storageRole, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceCreateRoleAsync(@Nonnull String name, @Nonnull StorageRole storageRole, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.roleServiceCreateRoleValidateBeforeCall(name, storageRole, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceDeletePermissionSetCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/permissionsets/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceDeletePermissionSetValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling roleServiceDeletePermissionSet(Async)");
        }
        return this.roleServiceDeletePermissionSetCall(id, _callback);
    }

    public Object roleServiceDeletePermissionSet(@Nonnull String id) throws ApiException {
        ApiResponse<Object> localVarResp = this.roleServiceDeletePermissionSetWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Object> roleServiceDeletePermissionSetWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.roleServiceDeletePermissionSetValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceDeletePermissionSetAsync(@Nonnull String id, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.roleServiceDeletePermissionSetValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceDeleteRoleCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/roles/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceDeleteRoleValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling roleServiceDeleteRole(Async)");
        }
        return this.roleServiceDeleteRoleCall(id, _callback);
    }

    public Object roleServiceDeleteRole(@Nonnull String id) throws ApiException {
        ApiResponse<Object> localVarResp = this.roleServiceDeleteRoleWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Object> roleServiceDeleteRoleWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.roleServiceDeleteRoleValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceDeleteRoleAsync(@Nonnull String id, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.roleServiceDeleteRoleValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceDeleteSimpleAccessScopeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/simpleaccessscopes/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceDeleteSimpleAccessScopeValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling roleServiceDeleteSimpleAccessScope(Async)");
        }
        return this.roleServiceDeleteSimpleAccessScopeCall(id, _callback);
    }

    public Object roleServiceDeleteSimpleAccessScope(@Nonnull String id) throws ApiException {
        ApiResponse<Object> localVarResp = this.roleServiceDeleteSimpleAccessScopeWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Object> roleServiceDeleteSimpleAccessScopeWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.roleServiceDeleteSimpleAccessScopeValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceDeleteSimpleAccessScopeAsync(@Nonnull String id, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.roleServiceDeleteSimpleAccessScopeValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceGetClustersForPermissionsCall(@Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, @Nullable List<String> permissions, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/sac/clusters";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (paginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.limit", paginationLimit));
        }
        if (paginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.offset", paginationOffset));
        }
        if (paginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.field", paginationSortOptionField));
        }
        if (paginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.reversed", paginationSortOptionReversed));
        }
        if (paginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.aggrFunc", paginationSortOptionAggregateByAggrFunc));
        }
        if (paginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.distinct", paginationSortOptionAggregateByDistinct));
        }
        if (permissions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "permissions", permissions));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceGetClustersForPermissionsValidateBeforeCall(@Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, @Nullable List<String> permissions, ApiCallback _callback) throws ApiException {
        return this.roleServiceGetClustersForPermissionsCall(paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, permissions, _callback);
    }

    public V1GetClustersForPermissionsResponse roleServiceGetClustersForPermissions(@Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, @Nullable List<String> permissions) throws ApiException {
        ApiResponse<V1GetClustersForPermissionsResponse> localVarResp = this.roleServiceGetClustersForPermissionsWithHttpInfo(paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, permissions);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetClustersForPermissionsResponse> roleServiceGetClustersForPermissionsWithHttpInfo(@Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, @Nullable List<String> permissions) throws ApiException {
        Call localVarCall = this.roleServiceGetClustersForPermissionsValidateBeforeCall(paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, permissions, null);
        Type localVarReturnType = new TypeToken<V1GetClustersForPermissionsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceGetClustersForPermissionsAsync(@Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, @Nullable List<String> permissions, ApiCallback<V1GetClustersForPermissionsResponse> _callback) throws ApiException {
        Call localVarCall = this.roleServiceGetClustersForPermissionsValidateBeforeCall(paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, permissions, _callback);
        Type localVarReturnType = new TypeToken<V1GetClustersForPermissionsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceGetMyPermissionsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/mypermissions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceGetMyPermissionsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.roleServiceGetMyPermissionsCall(_callback);
    }

    public V1GetPermissionsResponse roleServiceGetMyPermissions() throws ApiException {
        ApiResponse<V1GetPermissionsResponse> localVarResp = this.roleServiceGetMyPermissionsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<V1GetPermissionsResponse> roleServiceGetMyPermissionsWithHttpInfo() throws ApiException {
        Call localVarCall = this.roleServiceGetMyPermissionsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1GetPermissionsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceGetMyPermissionsAsync(ApiCallback<V1GetPermissionsResponse> _callback) throws ApiException {
        Call localVarCall = this.roleServiceGetMyPermissionsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1GetPermissionsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceGetNamespacesForClusterAndPermissionsCall(@Nonnull String clusterId, @Nullable List<String> permissions, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/sac/clusters/{clusterId}/namespaces".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (permissions != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "permissions", permissions));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceGetNamespacesForClusterAndPermissionsValidateBeforeCall(@Nonnull String clusterId, @Nullable List<String> permissions, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling roleServiceGetNamespacesForClusterAndPermissions(Async)");
        }
        return this.roleServiceGetNamespacesForClusterAndPermissionsCall(clusterId, permissions, _callback);
    }

    public V1GetNamespacesForClusterAndPermissionsResponse roleServiceGetNamespacesForClusterAndPermissions(@Nonnull String clusterId, @Nullable List<String> permissions) throws ApiException {
        ApiResponse<V1GetNamespacesForClusterAndPermissionsResponse> localVarResp = this.roleServiceGetNamespacesForClusterAndPermissionsWithHttpInfo(clusterId, permissions);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetNamespacesForClusterAndPermissionsResponse> roleServiceGetNamespacesForClusterAndPermissionsWithHttpInfo(@Nonnull String clusterId, @Nullable List<String> permissions) throws ApiException {
        Call localVarCall = this.roleServiceGetNamespacesForClusterAndPermissionsValidateBeforeCall(clusterId, permissions, null);
        Type localVarReturnType = new TypeToken<V1GetNamespacesForClusterAndPermissionsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceGetNamespacesForClusterAndPermissionsAsync(@Nonnull String clusterId, @Nullable List<String> permissions, ApiCallback<V1GetNamespacesForClusterAndPermissionsResponse> _callback) throws ApiException {
        Call localVarCall = this.roleServiceGetNamespacesForClusterAndPermissionsValidateBeforeCall(clusterId, permissions, _callback);
        Type localVarReturnType = new TypeToken<V1GetNamespacesForClusterAndPermissionsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceGetPermissionSetCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/permissionsets/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceGetPermissionSetValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling roleServiceGetPermissionSet(Async)");
        }
        return this.roleServiceGetPermissionSetCall(id, _callback);
    }

    public StoragePermissionSet roleServiceGetPermissionSet(@Nonnull String id) throws ApiException {
        ApiResponse<StoragePermissionSet> localVarResp = this.roleServiceGetPermissionSetWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<StoragePermissionSet> roleServiceGetPermissionSetWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.roleServiceGetPermissionSetValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<StoragePermissionSet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceGetPermissionSetAsync(@Nonnull String id, ApiCallback<StoragePermissionSet> _callback) throws ApiException {
        Call localVarCall = this.roleServiceGetPermissionSetValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<StoragePermissionSet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceGetResourcesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/resources";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceGetResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.roleServiceGetResourcesCall(_callback);
    }

    public V1GetResourcesResponse roleServiceGetResources() throws ApiException {
        ApiResponse<V1GetResourcesResponse> localVarResp = this.roleServiceGetResourcesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<V1GetResourcesResponse> roleServiceGetResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.roleServiceGetResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1GetResourcesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceGetResourcesAsync(ApiCallback<V1GetResourcesResponse> _callback) throws ApiException {
        Call localVarCall = this.roleServiceGetResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1GetResourcesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceGetRoleCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/roles/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceGetRoleValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling roleServiceGetRole(Async)");
        }
        return this.roleServiceGetRoleCall(id, _callback);
    }

    public StorageRole roleServiceGetRole(@Nonnull String id) throws ApiException {
        ApiResponse<StorageRole> localVarResp = this.roleServiceGetRoleWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<StorageRole> roleServiceGetRoleWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.roleServiceGetRoleValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<StorageRole>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceGetRoleAsync(@Nonnull String id, ApiCallback<StorageRole> _callback) throws ApiException {
        Call localVarCall = this.roleServiceGetRoleValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<StorageRole>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceGetRolesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceGetRolesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.roleServiceGetRolesCall(_callback);
    }

    public V1GetRolesResponse roleServiceGetRoles() throws ApiException {
        ApiResponse<V1GetRolesResponse> localVarResp = this.roleServiceGetRolesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<V1GetRolesResponse> roleServiceGetRolesWithHttpInfo() throws ApiException {
        Call localVarCall = this.roleServiceGetRolesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1GetRolesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceGetRolesAsync(ApiCallback<V1GetRolesResponse> _callback) throws ApiException {
        Call localVarCall = this.roleServiceGetRolesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1GetRolesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceGetSimpleAccessScopeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/simpleaccessscopes/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceGetSimpleAccessScopeValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling roleServiceGetSimpleAccessScope(Async)");
        }
        return this.roleServiceGetSimpleAccessScopeCall(id, _callback);
    }

    public StorageSimpleAccessScope roleServiceGetSimpleAccessScope(@Nonnull String id) throws ApiException {
        ApiResponse<StorageSimpleAccessScope> localVarResp = this.roleServiceGetSimpleAccessScopeWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<StorageSimpleAccessScope> roleServiceGetSimpleAccessScopeWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.roleServiceGetSimpleAccessScopeValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<StorageSimpleAccessScope>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceGetSimpleAccessScopeAsync(@Nonnull String id, ApiCallback<StorageSimpleAccessScope> _callback) throws ApiException {
        Call localVarCall = this.roleServiceGetSimpleAccessScopeValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<StorageSimpleAccessScope>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceListPermissionSetsCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/permissionsets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceListPermissionSetsValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.roleServiceListPermissionSetsCall(_callback);
    }

    public V1ListPermissionSetsResponse roleServiceListPermissionSets() throws ApiException {
        ApiResponse<V1ListPermissionSetsResponse> localVarResp = this.roleServiceListPermissionSetsWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<V1ListPermissionSetsResponse> roleServiceListPermissionSetsWithHttpInfo() throws ApiException {
        Call localVarCall = this.roleServiceListPermissionSetsValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1ListPermissionSetsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceListPermissionSetsAsync(ApiCallback<V1ListPermissionSetsResponse> _callback) throws ApiException {
        Call localVarCall = this.roleServiceListPermissionSetsValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1ListPermissionSetsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceListSimpleAccessScopesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/simpleaccessscopes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceListSimpleAccessScopesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.roleServiceListSimpleAccessScopesCall(_callback);
    }

    public V1ListSimpleAccessScopesResponse roleServiceListSimpleAccessScopes() throws ApiException {
        ApiResponse<V1ListSimpleAccessScopesResponse> localVarResp = this.roleServiceListSimpleAccessScopesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<V1ListSimpleAccessScopesResponse> roleServiceListSimpleAccessScopesWithHttpInfo() throws ApiException {
        Call localVarCall = this.roleServiceListSimpleAccessScopesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1ListSimpleAccessScopesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceListSimpleAccessScopesAsync(ApiCallback<V1ListSimpleAccessScopesResponse> _callback) throws ApiException {
        Call localVarCall = this.roleServiceListSimpleAccessScopesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1ListSimpleAccessScopesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServicePostPermissionSetCall(@Nonnull StoragePermissionSet storagePermissionSet, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        StoragePermissionSet localVarPostBody = storagePermissionSet;
        String localVarPath = "/v1/permissionsets";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServicePostPermissionSetValidateBeforeCall(@Nonnull StoragePermissionSet storagePermissionSet, ApiCallback _callback) throws ApiException {
        if (storagePermissionSet == null) {
            throw new ApiException("Missing the required parameter 'storagePermissionSet' when calling roleServicePostPermissionSet(Async)");
        }
        return this.roleServicePostPermissionSetCall(storagePermissionSet, _callback);
    }

    public StoragePermissionSet roleServicePostPermissionSet(@Nonnull StoragePermissionSet storagePermissionSet) throws ApiException {
        ApiResponse<StoragePermissionSet> localVarResp = this.roleServicePostPermissionSetWithHttpInfo(storagePermissionSet);
        return localVarResp.getData();
    }

    public ApiResponse<StoragePermissionSet> roleServicePostPermissionSetWithHttpInfo(@Nonnull StoragePermissionSet storagePermissionSet) throws ApiException {
        Call localVarCall = this.roleServicePostPermissionSetValidateBeforeCall(storagePermissionSet, null);
        Type localVarReturnType = new TypeToken<StoragePermissionSet>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServicePostPermissionSetAsync(@Nonnull StoragePermissionSet storagePermissionSet, ApiCallback<StoragePermissionSet> _callback) throws ApiException {
        Call localVarCall = this.roleServicePostPermissionSetValidateBeforeCall(storagePermissionSet, _callback);
        Type localVarReturnType = new TypeToken<StoragePermissionSet>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServicePostSimpleAccessScopeCall(@Nonnull StorageSimpleAccessScope storageSimpleAccessScope, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        StorageSimpleAccessScope localVarPostBody = storageSimpleAccessScope;
        String localVarPath = "/v1/simpleaccessscopes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServicePostSimpleAccessScopeValidateBeforeCall(@Nonnull StorageSimpleAccessScope storageSimpleAccessScope, ApiCallback _callback) throws ApiException {
        if (storageSimpleAccessScope == null) {
            throw new ApiException("Missing the required parameter 'storageSimpleAccessScope' when calling roleServicePostSimpleAccessScope(Async)");
        }
        return this.roleServicePostSimpleAccessScopeCall(storageSimpleAccessScope, _callback);
    }

    public StorageSimpleAccessScope roleServicePostSimpleAccessScope(@Nonnull StorageSimpleAccessScope storageSimpleAccessScope) throws ApiException {
        ApiResponse<StorageSimpleAccessScope> localVarResp = this.roleServicePostSimpleAccessScopeWithHttpInfo(storageSimpleAccessScope);
        return localVarResp.getData();
    }

    public ApiResponse<StorageSimpleAccessScope> roleServicePostSimpleAccessScopeWithHttpInfo(@Nonnull StorageSimpleAccessScope storageSimpleAccessScope) throws ApiException {
        Call localVarCall = this.roleServicePostSimpleAccessScopeValidateBeforeCall(storageSimpleAccessScope, null);
        Type localVarReturnType = new TypeToken<StorageSimpleAccessScope>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServicePostSimpleAccessScopeAsync(@Nonnull StorageSimpleAccessScope storageSimpleAccessScope, ApiCallback<StorageSimpleAccessScope> _callback) throws ApiException {
        Call localVarCall = this.roleServicePostSimpleAccessScopeValidateBeforeCall(storageSimpleAccessScope, _callback);
        Type localVarReturnType = new TypeToken<StorageSimpleAccessScope>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServicePutPermissionSetCall(@Nonnull String id, @Nonnull RoleServicePutPermissionSetBody roleServicePutPermissionSetBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RoleServicePutPermissionSetBody localVarPostBody = roleServicePutPermissionSetBody;
        String localVarPath = "/v1/permissionsets/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServicePutPermissionSetValidateBeforeCall(@Nonnull String id, @Nonnull RoleServicePutPermissionSetBody roleServicePutPermissionSetBody, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling roleServicePutPermissionSet(Async)");
        }
        if (roleServicePutPermissionSetBody == null) {
            throw new ApiException("Missing the required parameter 'roleServicePutPermissionSetBody' when calling roleServicePutPermissionSet(Async)");
        }
        return this.roleServicePutPermissionSetCall(id, roleServicePutPermissionSetBody, _callback);
    }

    public Object roleServicePutPermissionSet(@Nonnull String id, @Nonnull RoleServicePutPermissionSetBody roleServicePutPermissionSetBody) throws ApiException {
        ApiResponse<Object> localVarResp = this.roleServicePutPermissionSetWithHttpInfo(id, roleServicePutPermissionSetBody);
        return localVarResp.getData();
    }

    public ApiResponse<Object> roleServicePutPermissionSetWithHttpInfo(@Nonnull String id, @Nonnull RoleServicePutPermissionSetBody roleServicePutPermissionSetBody) throws ApiException {
        Call localVarCall = this.roleServicePutPermissionSetValidateBeforeCall(id, roleServicePutPermissionSetBody, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServicePutPermissionSetAsync(@Nonnull String id, @Nonnull RoleServicePutPermissionSetBody roleServicePutPermissionSetBody, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.roleServicePutPermissionSetValidateBeforeCall(id, roleServicePutPermissionSetBody, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServicePutSimpleAccessScopeCall(@Nonnull String id, @Nonnull RoleServicePutSimpleAccessScopeBody roleServicePutSimpleAccessScopeBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RoleServicePutSimpleAccessScopeBody localVarPostBody = roleServicePutSimpleAccessScopeBody;
        String localVarPath = "/v1/simpleaccessscopes/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServicePutSimpleAccessScopeValidateBeforeCall(@Nonnull String id, @Nonnull RoleServicePutSimpleAccessScopeBody roleServicePutSimpleAccessScopeBody, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling roleServicePutSimpleAccessScope(Async)");
        }
        if (roleServicePutSimpleAccessScopeBody == null) {
            throw new ApiException("Missing the required parameter 'roleServicePutSimpleAccessScopeBody' when calling roleServicePutSimpleAccessScope(Async)");
        }
        return this.roleServicePutSimpleAccessScopeCall(id, roleServicePutSimpleAccessScopeBody, _callback);
    }

    public Object roleServicePutSimpleAccessScope(@Nonnull String id, @Nonnull RoleServicePutSimpleAccessScopeBody roleServicePutSimpleAccessScopeBody) throws ApiException {
        ApiResponse<Object> localVarResp = this.roleServicePutSimpleAccessScopeWithHttpInfo(id, roleServicePutSimpleAccessScopeBody);
        return localVarResp.getData();
    }

    public ApiResponse<Object> roleServicePutSimpleAccessScopeWithHttpInfo(@Nonnull String id, @Nonnull RoleServicePutSimpleAccessScopeBody roleServicePutSimpleAccessScopeBody) throws ApiException {
        Call localVarCall = this.roleServicePutSimpleAccessScopeValidateBeforeCall(id, roleServicePutSimpleAccessScopeBody, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServicePutSimpleAccessScopeAsync(@Nonnull String id, @Nonnull RoleServicePutSimpleAccessScopeBody roleServicePutSimpleAccessScopeBody, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.roleServicePutSimpleAccessScopeValidateBeforeCall(id, roleServicePutSimpleAccessScopeBody, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call roleServiceUpdateRoleCall(@Nonnull String name, @Nonnull RoleServiceUpdateRoleBody roleServiceUpdateRoleBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        RoleServiceUpdateRoleBody localVarPostBody = roleServiceUpdateRoleBody;
        String localVarPath = "/v1/roles/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call roleServiceUpdateRoleValidateBeforeCall(@Nonnull String name, @Nonnull RoleServiceUpdateRoleBody roleServiceUpdateRoleBody, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling roleServiceUpdateRole(Async)");
        }
        if (roleServiceUpdateRoleBody == null) {
            throw new ApiException("Missing the required parameter 'roleServiceUpdateRoleBody' when calling roleServiceUpdateRole(Async)");
        }
        return this.roleServiceUpdateRoleCall(name, roleServiceUpdateRoleBody, _callback);
    }

    public Object roleServiceUpdateRole(@Nonnull String name, @Nonnull RoleServiceUpdateRoleBody roleServiceUpdateRoleBody) throws ApiException {
        ApiResponse<Object> localVarResp = this.roleServiceUpdateRoleWithHttpInfo(name, roleServiceUpdateRoleBody);
        return localVarResp.getData();
    }

    public ApiResponse<Object> roleServiceUpdateRoleWithHttpInfo(@Nonnull String name, @Nonnull RoleServiceUpdateRoleBody roleServiceUpdateRoleBody) throws ApiException {
        Call localVarCall = this.roleServiceUpdateRoleValidateBeforeCall(name, roleServiceUpdateRoleBody, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call roleServiceUpdateRoleAsync(@Nonnull String name, @Nonnull RoleServiceUpdateRoleBody roleServiceUpdateRoleBody, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.roleServiceUpdateRoleValidateBeforeCall(name, roleServiceUpdateRoleBody, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

