/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.api;

import com.google.gson.reflect.TypeToken;
import com.stackrox.invoker.ApiCallback;
import com.stackrox.invoker.ApiClient;
import com.stackrox.invoker.ApiException;
import com.stackrox.invoker.ApiResponse;
import com.stackrox.invoker.Configuration;
import com.stackrox.invoker.Pair;
import com.stackrox.model.StorageNode;
import com.stackrox.model.StreamResultOfV1ExportNodeResponse;
import com.stackrox.model.V1ListNodesResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class NodeServiceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NodeServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NodeServiceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call nodeServiceExportNodesCall(@Nullable Integer timeout, @Nullable String query, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/export/nodes";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (timeout != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeout", timeout));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call nodeServiceExportNodesValidateBeforeCall(@Nullable Integer timeout, @Nullable String query, ApiCallback _callback) throws ApiException {
        return this.nodeServiceExportNodesCall(timeout, query, _callback);
    }

    public StreamResultOfV1ExportNodeResponse nodeServiceExportNodes(@Nullable Integer timeout, @Nullable String query) throws ApiException {
        ApiResponse<StreamResultOfV1ExportNodeResponse> localVarResp = this.nodeServiceExportNodesWithHttpInfo(timeout, query);
        return localVarResp.getData();
    }

    public ApiResponse<StreamResultOfV1ExportNodeResponse> nodeServiceExportNodesWithHttpInfo(@Nullable Integer timeout, @Nullable String query) throws ApiException {
        Call localVarCall = this.nodeServiceExportNodesValidateBeforeCall(timeout, query, null);
        Type localVarReturnType = new TypeToken<StreamResultOfV1ExportNodeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call nodeServiceExportNodesAsync(@Nullable Integer timeout, @Nullable String query, ApiCallback<StreamResultOfV1ExportNodeResponse> _callback) throws ApiException {
        Call localVarCall = this.nodeServiceExportNodesValidateBeforeCall(timeout, query, _callback);
        Type localVarReturnType = new TypeToken<StreamResultOfV1ExportNodeResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call nodeServiceGetNodeCall(@Nonnull String clusterId, @Nonnull String nodeId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/nodes/{clusterId}/{nodeId}".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString())).replace("{nodeId}", this.localVarApiClient.escapeString(nodeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call nodeServiceGetNodeValidateBeforeCall(@Nonnull String clusterId, @Nonnull String nodeId, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling nodeServiceGetNode(Async)");
        }
        if (nodeId == null) {
            throw new ApiException("Missing the required parameter 'nodeId' when calling nodeServiceGetNode(Async)");
        }
        return this.nodeServiceGetNodeCall(clusterId, nodeId, _callback);
    }

    public StorageNode nodeServiceGetNode(@Nonnull String clusterId, @Nonnull String nodeId) throws ApiException {
        ApiResponse<StorageNode> localVarResp = this.nodeServiceGetNodeWithHttpInfo(clusterId, nodeId);
        return localVarResp.getData();
    }

    public ApiResponse<StorageNode> nodeServiceGetNodeWithHttpInfo(@Nonnull String clusterId, @Nonnull String nodeId) throws ApiException {
        Call localVarCall = this.nodeServiceGetNodeValidateBeforeCall(clusterId, nodeId, null);
        Type localVarReturnType = new TypeToken<StorageNode>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call nodeServiceGetNodeAsync(@Nonnull String clusterId, @Nonnull String nodeId, ApiCallback<StorageNode> _callback) throws ApiException {
        Call localVarCall = this.nodeServiceGetNodeValidateBeforeCall(clusterId, nodeId, _callback);
        Type localVarReturnType = new TypeToken<StorageNode>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call nodeServiceListNodesCall(@Nonnull String clusterId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/nodes/{clusterId}".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call nodeServiceListNodesValidateBeforeCall(@Nonnull String clusterId, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling nodeServiceListNodes(Async)");
        }
        return this.nodeServiceListNodesCall(clusterId, _callback);
    }

    public V1ListNodesResponse nodeServiceListNodes(@Nonnull String clusterId) throws ApiException {
        ApiResponse<V1ListNodesResponse> localVarResp = this.nodeServiceListNodesWithHttpInfo(clusterId);
        return localVarResp.getData();
    }

    public ApiResponse<V1ListNodesResponse> nodeServiceListNodesWithHttpInfo(@Nonnull String clusterId) throws ApiException {
        Call localVarCall = this.nodeServiceListNodesValidateBeforeCall(clusterId, null);
        Type localVarReturnType = new TypeToken<V1ListNodesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call nodeServiceListNodesAsync(@Nonnull String clusterId, ApiCallback<V1ListNodesResponse> _callback) throws ApiException {
        Call localVarCall = this.nodeServiceListNodesValidateBeforeCall(clusterId, _callback);
        Type localVarReturnType = new TypeToken<V1ListNodesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

