/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.api;

import com.google.gson.reflect.TypeToken;
import com.stackrox.invoker.ApiCallback;
import com.stackrox.invoker.ApiClient;
import com.stackrox.invoker.ApiException;
import com.stackrox.invoker.ApiResponse;
import com.stackrox.invoker.Configuration;
import com.stackrox.invoker.Pair;
import com.stackrox.model.NetworkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody;
import com.stackrox.model.NetworkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody;
import com.stackrox.model.StorageNetworkPolicy;
import com.stackrox.model.StorageNetworkPolicyModification;
import com.stackrox.model.V1GenerateNetworkPoliciesResponse;
import com.stackrox.model.V1GetAllowedPeersFromCurrentPolicyForDeploymentResponse;
import com.stackrox.model.V1GetBaselineGeneratedPolicyForDeploymentResponse;
import com.stackrox.model.V1GetDiffFlowsResponse;
import com.stackrox.model.V1GetUndoModificationForDeploymentResponse;
import com.stackrox.model.V1GetUndoModificationResponse;
import com.stackrox.model.V1NetworkGraph;
import com.stackrox.model.V1NetworkGraphEpoch;
import com.stackrox.model.V1NetworkPoliciesResponse;
import com.stackrox.model.V1SimulateNetworkGraphResponse;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class NetworkPolicyServiceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NetworkPolicyServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NetworkPolicyServiceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call networkPolicyServiceApplyNetworkPolicyCall(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        StorageNetworkPolicyModification localVarPostBody = storageNetworkPolicyModification;
        String localVarPath = "/v1/networkpolicies/apply/{clusterId}".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceApplyNetworkPolicyValidateBeforeCall(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling networkPolicyServiceApplyNetworkPolicy(Async)");
        }
        if (storageNetworkPolicyModification == null) {
            throw new ApiException("Missing the required parameter 'storageNetworkPolicyModification' when calling networkPolicyServiceApplyNetworkPolicy(Async)");
        }
        return this.networkPolicyServiceApplyNetworkPolicyCall(clusterId, storageNetworkPolicyModification, _callback);
    }

    public Object networkPolicyServiceApplyNetworkPolicy(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification) throws ApiException {
        ApiResponse<Object> localVarResp = this.networkPolicyServiceApplyNetworkPolicyWithHttpInfo(clusterId, storageNetworkPolicyModification);
        return localVarResp.getData();
    }

    public ApiResponse<Object> networkPolicyServiceApplyNetworkPolicyWithHttpInfo(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification) throws ApiException {
        Call localVarCall = this.networkPolicyServiceApplyNetworkPolicyValidateBeforeCall(clusterId, storageNetworkPolicyModification, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceApplyNetworkPolicyAsync(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceApplyNetworkPolicyValidateBeforeCall(clusterId, storageNetworkPolicyModification, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceApplyNetworkPolicyYamlForDeploymentCall(@Nonnull String deploymentId, @Nonnull NetworkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody localVarPostBody = networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody;
        String localVarPath = "/v1/networkpolicies/apply/deployment/{deploymentId}".replace("{deploymentId}", this.localVarApiClient.escapeString(deploymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceApplyNetworkPolicyYamlForDeploymentValidateBeforeCall(@Nonnull String deploymentId, @Nonnull NetworkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody, ApiCallback _callback) throws ApiException {
        if (deploymentId == null) {
            throw new ApiException("Missing the required parameter 'deploymentId' when calling networkPolicyServiceApplyNetworkPolicyYamlForDeployment(Async)");
        }
        if (networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody == null) {
            throw new ApiException("Missing the required parameter 'networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody' when calling networkPolicyServiceApplyNetworkPolicyYamlForDeployment(Async)");
        }
        return this.networkPolicyServiceApplyNetworkPolicyYamlForDeploymentCall(deploymentId, networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody, _callback);
    }

    public Object networkPolicyServiceApplyNetworkPolicyYamlForDeployment(@Nonnull String deploymentId, @Nonnull NetworkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody) throws ApiException {
        ApiResponse<Object> localVarResp = this.networkPolicyServiceApplyNetworkPolicyYamlForDeploymentWithHttpInfo(deploymentId, networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody);
        return localVarResp.getData();
    }

    public ApiResponse<Object> networkPolicyServiceApplyNetworkPolicyYamlForDeploymentWithHttpInfo(@Nonnull String deploymentId, @Nonnull NetworkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody) throws ApiException {
        Call localVarCall = this.networkPolicyServiceApplyNetworkPolicyYamlForDeploymentValidateBeforeCall(deploymentId, networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceApplyNetworkPolicyYamlForDeploymentAsync(@Nonnull String deploymentId, @Nonnull NetworkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceApplyNetworkPolicyYamlForDeploymentValidateBeforeCall(deploymentId, networkPolicyServiceApplyNetworkPolicyYamlForDeploymentBody, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceGenerateNetworkPoliciesCall(@Nonnull String clusterId, @Nullable String query, @Nullable String deleteExisting, @Nullable OffsetDateTime networkDataSince, @Nullable Boolean includePorts, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkpolicies/generate/{clusterId}".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (deleteExisting != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deleteExisting", deleteExisting));
        }
        if (networkDataSince != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("networkDataSince", networkDataSince));
        }
        if (includePorts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includePorts", includePorts));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceGenerateNetworkPoliciesValidateBeforeCall(@Nonnull String clusterId, @Nullable String query, @Nullable String deleteExisting, @Nullable OffsetDateTime networkDataSince, @Nullable Boolean includePorts, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling networkPolicyServiceGenerateNetworkPolicies(Async)");
        }
        return this.networkPolicyServiceGenerateNetworkPoliciesCall(clusterId, query, deleteExisting, networkDataSince, includePorts, _callback);
    }

    public V1GenerateNetworkPoliciesResponse networkPolicyServiceGenerateNetworkPolicies(@Nonnull String clusterId, @Nullable String query, @Nullable String deleteExisting, @Nullable OffsetDateTime networkDataSince, @Nullable Boolean includePorts) throws ApiException {
        ApiResponse<V1GenerateNetworkPoliciesResponse> localVarResp = this.networkPolicyServiceGenerateNetworkPoliciesWithHttpInfo(clusterId, query, deleteExisting, networkDataSince, includePorts);
        return localVarResp.getData();
    }

    public ApiResponse<V1GenerateNetworkPoliciesResponse> networkPolicyServiceGenerateNetworkPoliciesWithHttpInfo(@Nonnull String clusterId, @Nullable String query, @Nullable String deleteExisting, @Nullable OffsetDateTime networkDataSince, @Nullable Boolean includePorts) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGenerateNetworkPoliciesValidateBeforeCall(clusterId, query, deleteExisting, networkDataSince, includePorts, null);
        Type localVarReturnType = new TypeToken<V1GenerateNetworkPoliciesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceGenerateNetworkPoliciesAsync(@Nonnull String clusterId, @Nullable String query, @Nullable String deleteExisting, @Nullable OffsetDateTime networkDataSince, @Nullable Boolean includePorts, ApiCallback<V1GenerateNetworkPoliciesResponse> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGenerateNetworkPoliciesValidateBeforeCall(clusterId, query, deleteExisting, networkDataSince, includePorts, _callback);
        Type localVarReturnType = new TypeToken<V1GenerateNetworkPoliciesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceGetAllowedPeersFromCurrentPolicyForDeploymentCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkpolicies/allowedpeers/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceGetAllowedPeersFromCurrentPolicyForDeploymentValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling networkPolicyServiceGetAllowedPeersFromCurrentPolicyForDeployment(Async)");
        }
        return this.networkPolicyServiceGetAllowedPeersFromCurrentPolicyForDeploymentCall(id, _callback);
    }

    public V1GetAllowedPeersFromCurrentPolicyForDeploymentResponse networkPolicyServiceGetAllowedPeersFromCurrentPolicyForDeployment(@Nonnull String id) throws ApiException {
        ApiResponse<V1GetAllowedPeersFromCurrentPolicyForDeploymentResponse> localVarResp = this.networkPolicyServiceGetAllowedPeersFromCurrentPolicyForDeploymentWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetAllowedPeersFromCurrentPolicyForDeploymentResponse> networkPolicyServiceGetAllowedPeersFromCurrentPolicyForDeploymentWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetAllowedPeersFromCurrentPolicyForDeploymentValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<V1GetAllowedPeersFromCurrentPolicyForDeploymentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceGetAllowedPeersFromCurrentPolicyForDeploymentAsync(@Nonnull String id, ApiCallback<V1GetAllowedPeersFromCurrentPolicyForDeploymentResponse> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetAllowedPeersFromCurrentPolicyForDeploymentValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<V1GetAllowedPeersFromCurrentPolicyForDeploymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentCall(@Nonnull String deploymentId, @Nonnull NetworkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody localVarPostBody = networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody;
        String localVarPath = "/v1/networkpolicies/generate/baseline/{deploymentId}".replace("{deploymentId}", this.localVarApiClient.escapeString(deploymentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentValidateBeforeCall(@Nonnull String deploymentId, @Nonnull NetworkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody, ApiCallback _callback) throws ApiException {
        if (deploymentId == null) {
            throw new ApiException("Missing the required parameter 'deploymentId' when calling networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeployment(Async)");
        }
        if (networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody == null) {
            throw new ApiException("Missing the required parameter 'networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody' when calling networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeployment(Async)");
        }
        return this.networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentCall(deploymentId, networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody, _callback);
    }

    public V1GetBaselineGeneratedPolicyForDeploymentResponse networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeployment(@Nonnull String deploymentId, @Nonnull NetworkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody) throws ApiException {
        ApiResponse<V1GetBaselineGeneratedPolicyForDeploymentResponse> localVarResp = this.networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentWithHttpInfo(deploymentId, networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetBaselineGeneratedPolicyForDeploymentResponse> networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentWithHttpInfo(@Nonnull String deploymentId, @Nonnull NetworkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentValidateBeforeCall(deploymentId, networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody, null);
        Type localVarReturnType = new TypeToken<V1GetBaselineGeneratedPolicyForDeploymentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentAsync(@Nonnull String deploymentId, @Nonnull NetworkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody, ApiCallback<V1GetBaselineGeneratedPolicyForDeploymentResponse> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentValidateBeforeCall(deploymentId, networkPolicyServiceGetBaselineGeneratedNetworkPolicyForDeploymentBody, _callback);
        Type localVarReturnType = new TypeToken<V1GetBaselineGeneratedPolicyForDeploymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceGetDiffFlowsBetweenPolicyAndBaselineForDeploymentCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkpolicies/baselinecomparison/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceGetDiffFlowsBetweenPolicyAndBaselineForDeploymentValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling networkPolicyServiceGetDiffFlowsBetweenPolicyAndBaselineForDeployment(Async)");
        }
        return this.networkPolicyServiceGetDiffFlowsBetweenPolicyAndBaselineForDeploymentCall(id, _callback);
    }

    public V1GetDiffFlowsResponse networkPolicyServiceGetDiffFlowsBetweenPolicyAndBaselineForDeployment(@Nonnull String id) throws ApiException {
        ApiResponse<V1GetDiffFlowsResponse> localVarResp = this.networkPolicyServiceGetDiffFlowsBetweenPolicyAndBaselineForDeploymentWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetDiffFlowsResponse> networkPolicyServiceGetDiffFlowsBetweenPolicyAndBaselineForDeploymentWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetDiffFlowsBetweenPolicyAndBaselineForDeploymentValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<V1GetDiffFlowsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceGetDiffFlowsBetweenPolicyAndBaselineForDeploymentAsync(@Nonnull String id, ApiCallback<V1GetDiffFlowsResponse> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetDiffFlowsBetweenPolicyAndBaselineForDeploymentValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<V1GetDiffFlowsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceGetDiffFlowsFromUndoModificationForDeploymentCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkpolicies/undobaselinecomparison/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceGetDiffFlowsFromUndoModificationForDeploymentValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling networkPolicyServiceGetDiffFlowsFromUndoModificationForDeployment(Async)");
        }
        return this.networkPolicyServiceGetDiffFlowsFromUndoModificationForDeploymentCall(id, _callback);
    }

    public V1GetDiffFlowsResponse networkPolicyServiceGetDiffFlowsFromUndoModificationForDeployment(@Nonnull String id) throws ApiException {
        ApiResponse<V1GetDiffFlowsResponse> localVarResp = this.networkPolicyServiceGetDiffFlowsFromUndoModificationForDeploymentWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetDiffFlowsResponse> networkPolicyServiceGetDiffFlowsFromUndoModificationForDeploymentWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetDiffFlowsFromUndoModificationForDeploymentValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<V1GetDiffFlowsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceGetDiffFlowsFromUndoModificationForDeploymentAsync(@Nonnull String id, ApiCallback<V1GetDiffFlowsResponse> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetDiffFlowsFromUndoModificationForDeploymentValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<V1GetDiffFlowsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceGetNetworkGraphCall(@Nonnull String clusterId, @Nullable String query, @Nullable Boolean includePorts, @Nullable String scopeQuery, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkpolicies/cluster/{clusterId}".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (includePorts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includePorts", includePorts));
        }
        if (scopeQuery != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("scope.query", scopeQuery));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceGetNetworkGraphValidateBeforeCall(@Nonnull String clusterId, @Nullable String query, @Nullable Boolean includePorts, @Nullable String scopeQuery, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling networkPolicyServiceGetNetworkGraph(Async)");
        }
        return this.networkPolicyServiceGetNetworkGraphCall(clusterId, query, includePorts, scopeQuery, _callback);
    }

    public V1NetworkGraph networkPolicyServiceGetNetworkGraph(@Nonnull String clusterId, @Nullable String query, @Nullable Boolean includePorts, @Nullable String scopeQuery) throws ApiException {
        ApiResponse<V1NetworkGraph> localVarResp = this.networkPolicyServiceGetNetworkGraphWithHttpInfo(clusterId, query, includePorts, scopeQuery);
        return localVarResp.getData();
    }

    public ApiResponse<V1NetworkGraph> networkPolicyServiceGetNetworkGraphWithHttpInfo(@Nonnull String clusterId, @Nullable String query, @Nullable Boolean includePorts, @Nullable String scopeQuery) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetNetworkGraphValidateBeforeCall(clusterId, query, includePorts, scopeQuery, null);
        Type localVarReturnType = new TypeToken<V1NetworkGraph>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceGetNetworkGraphAsync(@Nonnull String clusterId, @Nullable String query, @Nullable Boolean includePorts, @Nullable String scopeQuery, ApiCallback<V1NetworkGraph> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetNetworkGraphValidateBeforeCall(clusterId, query, includePorts, scopeQuery, _callback);
        Type localVarReturnType = new TypeToken<V1NetworkGraph>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceGetNetworkGraphEpochCall(@Nullable String clusterId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkpolicies/graph/epoch";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (clusterId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("clusterId", clusterId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceGetNetworkGraphEpochValidateBeforeCall(@Nullable String clusterId, ApiCallback _callback) throws ApiException {
        return this.networkPolicyServiceGetNetworkGraphEpochCall(clusterId, _callback);
    }

    public V1NetworkGraphEpoch networkPolicyServiceGetNetworkGraphEpoch(@Nullable String clusterId) throws ApiException {
        ApiResponse<V1NetworkGraphEpoch> localVarResp = this.networkPolicyServiceGetNetworkGraphEpochWithHttpInfo(clusterId);
        return localVarResp.getData();
    }

    public ApiResponse<V1NetworkGraphEpoch> networkPolicyServiceGetNetworkGraphEpochWithHttpInfo(@Nullable String clusterId) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetNetworkGraphEpochValidateBeforeCall(clusterId, null);
        Type localVarReturnType = new TypeToken<V1NetworkGraphEpoch>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceGetNetworkGraphEpochAsync(@Nullable String clusterId, ApiCallback<V1NetworkGraphEpoch> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetNetworkGraphEpochValidateBeforeCall(clusterId, _callback);
        Type localVarReturnType = new TypeToken<V1NetworkGraphEpoch>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceGetNetworkPoliciesCall(@Nullable String clusterId, @Nullable String deploymentQuery, @Nullable String namespace, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkpolicies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (clusterId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("clusterId", clusterId));
        }
        if (deploymentQuery != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deploymentQuery", deploymentQuery));
        }
        if (namespace != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("namespace", namespace));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceGetNetworkPoliciesValidateBeforeCall(@Nullable String clusterId, @Nullable String deploymentQuery, @Nullable String namespace, ApiCallback _callback) throws ApiException {
        return this.networkPolicyServiceGetNetworkPoliciesCall(clusterId, deploymentQuery, namespace, _callback);
    }

    public V1NetworkPoliciesResponse networkPolicyServiceGetNetworkPolicies(@Nullable String clusterId, @Nullable String deploymentQuery, @Nullable String namespace) throws ApiException {
        ApiResponse<V1NetworkPoliciesResponse> localVarResp = this.networkPolicyServiceGetNetworkPoliciesWithHttpInfo(clusterId, deploymentQuery, namespace);
        return localVarResp.getData();
    }

    public ApiResponse<V1NetworkPoliciesResponse> networkPolicyServiceGetNetworkPoliciesWithHttpInfo(@Nullable String clusterId, @Nullable String deploymentQuery, @Nullable String namespace) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetNetworkPoliciesValidateBeforeCall(clusterId, deploymentQuery, namespace, null);
        Type localVarReturnType = new TypeToken<V1NetworkPoliciesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceGetNetworkPoliciesAsync(@Nullable String clusterId, @Nullable String deploymentQuery, @Nullable String namespace, ApiCallback<V1NetworkPoliciesResponse> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetNetworkPoliciesValidateBeforeCall(clusterId, deploymentQuery, namespace, _callback);
        Type localVarReturnType = new TypeToken<V1NetworkPoliciesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceGetNetworkPolicyCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkpolicies/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceGetNetworkPolicyValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling networkPolicyServiceGetNetworkPolicy(Async)");
        }
        return this.networkPolicyServiceGetNetworkPolicyCall(id, _callback);
    }

    public StorageNetworkPolicy networkPolicyServiceGetNetworkPolicy(@Nonnull String id) throws ApiException {
        ApiResponse<StorageNetworkPolicy> localVarResp = this.networkPolicyServiceGetNetworkPolicyWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<StorageNetworkPolicy> networkPolicyServiceGetNetworkPolicyWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetNetworkPolicyValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<StorageNetworkPolicy>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceGetNetworkPolicyAsync(@Nonnull String id, ApiCallback<StorageNetworkPolicy> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetNetworkPolicyValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<StorageNetworkPolicy>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceGetUndoModificationCall(@Nonnull String clusterId, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkpolicies/undo/{clusterId}".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceGetUndoModificationValidateBeforeCall(@Nonnull String clusterId, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling networkPolicyServiceGetUndoModification(Async)");
        }
        return this.networkPolicyServiceGetUndoModificationCall(clusterId, _callback);
    }

    public V1GetUndoModificationResponse networkPolicyServiceGetUndoModification(@Nonnull String clusterId) throws ApiException {
        ApiResponse<V1GetUndoModificationResponse> localVarResp = this.networkPolicyServiceGetUndoModificationWithHttpInfo(clusterId);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetUndoModificationResponse> networkPolicyServiceGetUndoModificationWithHttpInfo(@Nonnull String clusterId) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetUndoModificationValidateBeforeCall(clusterId, null);
        Type localVarReturnType = new TypeToken<V1GetUndoModificationResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceGetUndoModificationAsync(@Nonnull String clusterId, ApiCallback<V1GetUndoModificationResponse> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetUndoModificationValidateBeforeCall(clusterId, _callback);
        Type localVarReturnType = new TypeToken<V1GetUndoModificationResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceGetUndoModificationForDeploymentCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkpolicies/undo/deployment/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceGetUndoModificationForDeploymentValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling networkPolicyServiceGetUndoModificationForDeployment(Async)");
        }
        return this.networkPolicyServiceGetUndoModificationForDeploymentCall(id, _callback);
    }

    public V1GetUndoModificationForDeploymentResponse networkPolicyServiceGetUndoModificationForDeployment(@Nonnull String id) throws ApiException {
        ApiResponse<V1GetUndoModificationForDeploymentResponse> localVarResp = this.networkPolicyServiceGetUndoModificationForDeploymentWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetUndoModificationForDeploymentResponse> networkPolicyServiceGetUndoModificationForDeploymentWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetUndoModificationForDeploymentValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<V1GetUndoModificationForDeploymentResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceGetUndoModificationForDeploymentAsync(@Nonnull String id, ApiCallback<V1GetUndoModificationForDeploymentResponse> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceGetUndoModificationForDeploymentValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<V1GetUndoModificationForDeploymentResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceSendNetworkPolicyYAMLCall(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, @Nullable List<String> notifierIds, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        StorageNetworkPolicyModification localVarPostBody = storageNetworkPolicyModification;
        String localVarPath = "/v1/networkpolicies/simulate/{clusterId}/notify".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (notifierIds != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "notifierIds", notifierIds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceSendNetworkPolicyYAMLValidateBeforeCall(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, @Nullable List<String> notifierIds, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling networkPolicyServiceSendNetworkPolicyYAML(Async)");
        }
        if (storageNetworkPolicyModification == null) {
            throw new ApiException("Missing the required parameter 'storageNetworkPolicyModification' when calling networkPolicyServiceSendNetworkPolicyYAML(Async)");
        }
        return this.networkPolicyServiceSendNetworkPolicyYAMLCall(clusterId, storageNetworkPolicyModification, notifierIds, _callback);
    }

    public Object networkPolicyServiceSendNetworkPolicyYAML(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, @Nullable List<String> notifierIds) throws ApiException {
        ApiResponse<Object> localVarResp = this.networkPolicyServiceSendNetworkPolicyYAMLWithHttpInfo(clusterId, storageNetworkPolicyModification, notifierIds);
        return localVarResp.getData();
    }

    public ApiResponse<Object> networkPolicyServiceSendNetworkPolicyYAMLWithHttpInfo(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, @Nullable List<String> notifierIds) throws ApiException {
        Call localVarCall = this.networkPolicyServiceSendNetworkPolicyYAMLValidateBeforeCall(clusterId, storageNetworkPolicyModification, notifierIds, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceSendNetworkPolicyYAMLAsync(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, @Nullable List<String> notifierIds, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceSendNetworkPolicyYAMLValidateBeforeCall(clusterId, storageNetworkPolicyModification, notifierIds, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkPolicyServiceSimulateNetworkGraphCall(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, @Nullable String query, @Nullable Boolean includePorts, @Nullable Boolean includeNodeDiff, @Nullable String scopeQuery, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        StorageNetworkPolicyModification localVarPostBody = storageNetworkPolicyModification;
        String localVarPath = "/v1/networkpolicies/simulate/{clusterId}".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (includePorts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includePorts", includePorts));
        }
        if (includeNodeDiff != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeNodeDiff", includeNodeDiff));
        }
        if (scopeQuery != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("scope.query", scopeQuery));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPolicyServiceSimulateNetworkGraphValidateBeforeCall(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, @Nullable String query, @Nullable Boolean includePorts, @Nullable Boolean includeNodeDiff, @Nullable String scopeQuery, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling networkPolicyServiceSimulateNetworkGraph(Async)");
        }
        if (storageNetworkPolicyModification == null) {
            throw new ApiException("Missing the required parameter 'storageNetworkPolicyModification' when calling networkPolicyServiceSimulateNetworkGraph(Async)");
        }
        return this.networkPolicyServiceSimulateNetworkGraphCall(clusterId, storageNetworkPolicyModification, query, includePorts, includeNodeDiff, scopeQuery, _callback);
    }

    public V1SimulateNetworkGraphResponse networkPolicyServiceSimulateNetworkGraph(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, @Nullable String query, @Nullable Boolean includePorts, @Nullable Boolean includeNodeDiff, @Nullable String scopeQuery) throws ApiException {
        ApiResponse<V1SimulateNetworkGraphResponse> localVarResp = this.networkPolicyServiceSimulateNetworkGraphWithHttpInfo(clusterId, storageNetworkPolicyModification, query, includePorts, includeNodeDiff, scopeQuery);
        return localVarResp.getData();
    }

    public ApiResponse<V1SimulateNetworkGraphResponse> networkPolicyServiceSimulateNetworkGraphWithHttpInfo(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, @Nullable String query, @Nullable Boolean includePorts, @Nullable Boolean includeNodeDiff, @Nullable String scopeQuery) throws ApiException {
        Call localVarCall = this.networkPolicyServiceSimulateNetworkGraphValidateBeforeCall(clusterId, storageNetworkPolicyModification, query, includePorts, includeNodeDiff, scopeQuery, null);
        Type localVarReturnType = new TypeToken<V1SimulateNetworkGraphResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkPolicyServiceSimulateNetworkGraphAsync(@Nonnull String clusterId, @Nonnull StorageNetworkPolicyModification storageNetworkPolicyModification, @Nullable String query, @Nullable Boolean includePorts, @Nullable Boolean includeNodeDiff, @Nullable String scopeQuery, ApiCallback<V1SimulateNetworkGraphResponse> _callback) throws ApiException {
        Call localVarCall = this.networkPolicyServiceSimulateNetworkGraphValidateBeforeCall(clusterId, storageNetworkPolicyModification, query, includePorts, includeNodeDiff, scopeQuery, _callback);
        Type localVarReturnType = new TypeToken<V1SimulateNetworkGraphResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

