/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.api;

import com.google.gson.reflect.TypeToken;
import com.stackrox.invoker.ApiCallback;
import com.stackrox.invoker.ApiClient;
import com.stackrox.invoker.ApiException;
import com.stackrox.invoker.ApiResponse;
import com.stackrox.invoker.Configuration;
import com.stackrox.invoker.Pair;
import com.stackrox.model.NetworkGraphServiceCreateExternalNetworkEntityBody;
import com.stackrox.model.NetworkGraphServicePatchExternalNetworkEntityBody;
import com.stackrox.model.StorageNetworkEntity;
import com.stackrox.model.StorageNetworkGraphConfig;
import com.stackrox.model.V1GetExternalNetworkEntitiesResponse;
import com.stackrox.model.V1GetExternalNetworkFlowsMetadataResponse;
import com.stackrox.model.V1GetExternalNetworkFlowsResponse;
import com.stackrox.model.V1NetworkGraph;
import com.stackrox.model.V1PutNetworkGraphConfigRequest;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class NetworkGraphServiceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NetworkGraphServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NetworkGraphServiceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call networkGraphServiceCreateExternalNetworkEntityCall(@Nonnull String clusterId, @Nonnull NetworkGraphServiceCreateExternalNetworkEntityBody networkGraphServiceCreateExternalNetworkEntityBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkGraphServiceCreateExternalNetworkEntityBody localVarPostBody = networkGraphServiceCreateExternalNetworkEntityBody;
        String localVarPath = "/v1/networkgraph/cluster/{clusterId}/externalentities".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkGraphServiceCreateExternalNetworkEntityValidateBeforeCall(@Nonnull String clusterId, @Nonnull NetworkGraphServiceCreateExternalNetworkEntityBody networkGraphServiceCreateExternalNetworkEntityBody, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling networkGraphServiceCreateExternalNetworkEntity(Async)");
        }
        if (networkGraphServiceCreateExternalNetworkEntityBody == null) {
            throw new ApiException("Missing the required parameter 'networkGraphServiceCreateExternalNetworkEntityBody' when calling networkGraphServiceCreateExternalNetworkEntity(Async)");
        }
        return this.networkGraphServiceCreateExternalNetworkEntityCall(clusterId, networkGraphServiceCreateExternalNetworkEntityBody, _callback);
    }

    public StorageNetworkEntity networkGraphServiceCreateExternalNetworkEntity(@Nonnull String clusterId, @Nonnull NetworkGraphServiceCreateExternalNetworkEntityBody networkGraphServiceCreateExternalNetworkEntityBody) throws ApiException {
        ApiResponse<StorageNetworkEntity> localVarResp = this.networkGraphServiceCreateExternalNetworkEntityWithHttpInfo(clusterId, networkGraphServiceCreateExternalNetworkEntityBody);
        return localVarResp.getData();
    }

    public ApiResponse<StorageNetworkEntity> networkGraphServiceCreateExternalNetworkEntityWithHttpInfo(@Nonnull String clusterId, @Nonnull NetworkGraphServiceCreateExternalNetworkEntityBody networkGraphServiceCreateExternalNetworkEntityBody) throws ApiException {
        Call localVarCall = this.networkGraphServiceCreateExternalNetworkEntityValidateBeforeCall(clusterId, networkGraphServiceCreateExternalNetworkEntityBody, null);
        Type localVarReturnType = new TypeToken<StorageNetworkEntity>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkGraphServiceCreateExternalNetworkEntityAsync(@Nonnull String clusterId, @Nonnull NetworkGraphServiceCreateExternalNetworkEntityBody networkGraphServiceCreateExternalNetworkEntityBody, ApiCallback<StorageNetworkEntity> _callback) throws ApiException {
        Call localVarCall = this.networkGraphServiceCreateExternalNetworkEntityValidateBeforeCall(clusterId, networkGraphServiceCreateExternalNetworkEntityBody, _callback);
        Type localVarReturnType = new TypeToken<StorageNetworkEntity>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkGraphServiceDeleteExternalNetworkEntityCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkgraph/externalentities/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkGraphServiceDeleteExternalNetworkEntityValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling networkGraphServiceDeleteExternalNetworkEntity(Async)");
        }
        return this.networkGraphServiceDeleteExternalNetworkEntityCall(id, _callback);
    }

    public Object networkGraphServiceDeleteExternalNetworkEntity(@Nonnull String id) throws ApiException {
        ApiResponse<Object> localVarResp = this.networkGraphServiceDeleteExternalNetworkEntityWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<Object> networkGraphServiceDeleteExternalNetworkEntityWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.networkGraphServiceDeleteExternalNetworkEntityValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkGraphServiceDeleteExternalNetworkEntityAsync(@Nonnull String id, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.networkGraphServiceDeleteExternalNetworkEntityValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkGraphServiceGetExternalNetworkEntitiesCall(@Nonnull String clusterId, @Nullable String query, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkgraph/cluster/{clusterId}/externalentities".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkGraphServiceGetExternalNetworkEntitiesValidateBeforeCall(@Nonnull String clusterId, @Nullable String query, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling networkGraphServiceGetExternalNetworkEntities(Async)");
        }
        return this.networkGraphServiceGetExternalNetworkEntitiesCall(clusterId, query, _callback);
    }

    public V1GetExternalNetworkEntitiesResponse networkGraphServiceGetExternalNetworkEntities(@Nonnull String clusterId, @Nullable String query) throws ApiException {
        ApiResponse<V1GetExternalNetworkEntitiesResponse> localVarResp = this.networkGraphServiceGetExternalNetworkEntitiesWithHttpInfo(clusterId, query);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetExternalNetworkEntitiesResponse> networkGraphServiceGetExternalNetworkEntitiesWithHttpInfo(@Nonnull String clusterId, @Nullable String query) throws ApiException {
        Call localVarCall = this.networkGraphServiceGetExternalNetworkEntitiesValidateBeforeCall(clusterId, query, null);
        Type localVarReturnType = new TypeToken<V1GetExternalNetworkEntitiesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkGraphServiceGetExternalNetworkEntitiesAsync(@Nonnull String clusterId, @Nullable String query, ApiCallback<V1GetExternalNetworkEntitiesResponse> _callback) throws ApiException {
        Call localVarCall = this.networkGraphServiceGetExternalNetworkEntitiesValidateBeforeCall(clusterId, query, _callback);
        Type localVarReturnType = new TypeToken<V1GetExternalNetworkEntitiesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkGraphServiceGetExternalNetworkFlowsCall(@Nonnull String clusterId, @Nonnull String entityId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkgraph/cluster/{clusterId}/externalentities/{entityId}/flows".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString())).replace("{entityId}", this.localVarApiClient.escapeString(entityId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since", since));
        }
        if (paginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.limit", paginationLimit));
        }
        if (paginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.offset", paginationOffset));
        }
        if (paginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.field", paginationSortOptionField));
        }
        if (paginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.reversed", paginationSortOptionReversed));
        }
        if (paginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.aggrFunc", paginationSortOptionAggregateByAggrFunc));
        }
        if (paginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.distinct", paginationSortOptionAggregateByDistinct));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkGraphServiceGetExternalNetworkFlowsValidateBeforeCall(@Nonnull String clusterId, @Nonnull String entityId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling networkGraphServiceGetExternalNetworkFlows(Async)");
        }
        if (entityId == null) {
            throw new ApiException("Missing the required parameter 'entityId' when calling networkGraphServiceGetExternalNetworkFlows(Async)");
        }
        return this.networkGraphServiceGetExternalNetworkFlowsCall(clusterId, entityId, query, since, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
    }

    public V1GetExternalNetworkFlowsResponse networkGraphServiceGetExternalNetworkFlows(@Nonnull String clusterId, @Nonnull String entityId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        ApiResponse<V1GetExternalNetworkFlowsResponse> localVarResp = this.networkGraphServiceGetExternalNetworkFlowsWithHttpInfo(clusterId, entityId, query, since, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetExternalNetworkFlowsResponse> networkGraphServiceGetExternalNetworkFlowsWithHttpInfo(@Nonnull String clusterId, @Nonnull String entityId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        Call localVarCall = this.networkGraphServiceGetExternalNetworkFlowsValidateBeforeCall(clusterId, entityId, query, since, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, null);
        Type localVarReturnType = new TypeToken<V1GetExternalNetworkFlowsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkGraphServiceGetExternalNetworkFlowsAsync(@Nonnull String clusterId, @Nonnull String entityId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback<V1GetExternalNetworkFlowsResponse> _callback) throws ApiException {
        Call localVarCall = this.networkGraphServiceGetExternalNetworkFlowsValidateBeforeCall(clusterId, entityId, query, since, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
        Type localVarReturnType = new TypeToken<V1GetExternalNetworkFlowsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkGraphServiceGetExternalNetworkFlowsMetadataCall(@Nonnull String clusterId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkgraph/cluster/{clusterId}/externalentities/metadata".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since", since));
        }
        if (paginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.limit", paginationLimit));
        }
        if (paginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.offset", paginationOffset));
        }
        if (paginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.field", paginationSortOptionField));
        }
        if (paginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.reversed", paginationSortOptionReversed));
        }
        if (paginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.aggrFunc", paginationSortOptionAggregateByAggrFunc));
        }
        if (paginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.distinct", paginationSortOptionAggregateByDistinct));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkGraphServiceGetExternalNetworkFlowsMetadataValidateBeforeCall(@Nonnull String clusterId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling networkGraphServiceGetExternalNetworkFlowsMetadata(Async)");
        }
        return this.networkGraphServiceGetExternalNetworkFlowsMetadataCall(clusterId, query, since, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
    }

    public V1GetExternalNetworkFlowsMetadataResponse networkGraphServiceGetExternalNetworkFlowsMetadata(@Nonnull String clusterId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        ApiResponse<V1GetExternalNetworkFlowsMetadataResponse> localVarResp = this.networkGraphServiceGetExternalNetworkFlowsMetadataWithHttpInfo(clusterId, query, since, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetExternalNetworkFlowsMetadataResponse> networkGraphServiceGetExternalNetworkFlowsMetadataWithHttpInfo(@Nonnull String clusterId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        Call localVarCall = this.networkGraphServiceGetExternalNetworkFlowsMetadataValidateBeforeCall(clusterId, query, since, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, null);
        Type localVarReturnType = new TypeToken<V1GetExternalNetworkFlowsMetadataResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkGraphServiceGetExternalNetworkFlowsMetadataAsync(@Nonnull String clusterId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback<V1GetExternalNetworkFlowsMetadataResponse> _callback) throws ApiException {
        Call localVarCall = this.networkGraphServiceGetExternalNetworkFlowsMetadataValidateBeforeCall(clusterId, query, since, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
        Type localVarReturnType = new TypeToken<V1GetExternalNetworkFlowsMetadataResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkGraphServiceGetNetworkGraphCall(@Nonnull String clusterId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Boolean includePorts, @Nullable String scopeQuery, @Nullable Boolean includePolicies, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkgraph/cluster/{clusterId}".replace("{clusterId}", this.localVarApiClient.escapeString(clusterId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (since != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("since", since));
        }
        if (includePorts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includePorts", includePorts));
        }
        if (scopeQuery != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("scope.query", scopeQuery));
        }
        if (includePolicies != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includePolicies", includePolicies));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkGraphServiceGetNetworkGraphValidateBeforeCall(@Nonnull String clusterId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Boolean includePorts, @Nullable String scopeQuery, @Nullable Boolean includePolicies, ApiCallback _callback) throws ApiException {
        if (clusterId == null) {
            throw new ApiException("Missing the required parameter 'clusterId' when calling networkGraphServiceGetNetworkGraph(Async)");
        }
        return this.networkGraphServiceGetNetworkGraphCall(clusterId, query, since, includePorts, scopeQuery, includePolicies, _callback);
    }

    public V1NetworkGraph networkGraphServiceGetNetworkGraph(@Nonnull String clusterId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Boolean includePorts, @Nullable String scopeQuery, @Nullable Boolean includePolicies) throws ApiException {
        ApiResponse<V1NetworkGraph> localVarResp = this.networkGraphServiceGetNetworkGraphWithHttpInfo(clusterId, query, since, includePorts, scopeQuery, includePolicies);
        return localVarResp.getData();
    }

    public ApiResponse<V1NetworkGraph> networkGraphServiceGetNetworkGraphWithHttpInfo(@Nonnull String clusterId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Boolean includePorts, @Nullable String scopeQuery, @Nullable Boolean includePolicies) throws ApiException {
        Call localVarCall = this.networkGraphServiceGetNetworkGraphValidateBeforeCall(clusterId, query, since, includePorts, scopeQuery, includePolicies, null);
        Type localVarReturnType = new TypeToken<V1NetworkGraph>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkGraphServiceGetNetworkGraphAsync(@Nonnull String clusterId, @Nullable String query, @Nullable OffsetDateTime since, @Nullable Boolean includePorts, @Nullable String scopeQuery, @Nullable Boolean includePolicies, ApiCallback<V1NetworkGraph> _callback) throws ApiException {
        Call localVarCall = this.networkGraphServiceGetNetworkGraphValidateBeforeCall(clusterId, query, since, includePorts, scopeQuery, includePolicies, _callback);
        Type localVarReturnType = new TypeToken<V1NetworkGraph>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkGraphServiceGetNetworkGraphConfigCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/networkgraph/config";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkGraphServiceGetNetworkGraphConfigValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.networkGraphServiceGetNetworkGraphConfigCall(_callback);
    }

    public StorageNetworkGraphConfig networkGraphServiceGetNetworkGraphConfig() throws ApiException {
        ApiResponse<StorageNetworkGraphConfig> localVarResp = this.networkGraphServiceGetNetworkGraphConfigWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<StorageNetworkGraphConfig> networkGraphServiceGetNetworkGraphConfigWithHttpInfo() throws ApiException {
        Call localVarCall = this.networkGraphServiceGetNetworkGraphConfigValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<StorageNetworkGraphConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkGraphServiceGetNetworkGraphConfigAsync(ApiCallback<StorageNetworkGraphConfig> _callback) throws ApiException {
        Call localVarCall = this.networkGraphServiceGetNetworkGraphConfigValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<StorageNetworkGraphConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkGraphServicePatchExternalNetworkEntityCall(@Nonnull String id, @Nonnull NetworkGraphServicePatchExternalNetworkEntityBody networkGraphServicePatchExternalNetworkEntityBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkGraphServicePatchExternalNetworkEntityBody localVarPostBody = networkGraphServicePatchExternalNetworkEntityBody;
        String localVarPath = "/v1/networkgraph/externalentities/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkGraphServicePatchExternalNetworkEntityValidateBeforeCall(@Nonnull String id, @Nonnull NetworkGraphServicePatchExternalNetworkEntityBody networkGraphServicePatchExternalNetworkEntityBody, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling networkGraphServicePatchExternalNetworkEntity(Async)");
        }
        if (networkGraphServicePatchExternalNetworkEntityBody == null) {
            throw new ApiException("Missing the required parameter 'networkGraphServicePatchExternalNetworkEntityBody' when calling networkGraphServicePatchExternalNetworkEntity(Async)");
        }
        return this.networkGraphServicePatchExternalNetworkEntityCall(id, networkGraphServicePatchExternalNetworkEntityBody, _callback);
    }

    public StorageNetworkEntity networkGraphServicePatchExternalNetworkEntity(@Nonnull String id, @Nonnull NetworkGraphServicePatchExternalNetworkEntityBody networkGraphServicePatchExternalNetworkEntityBody) throws ApiException {
        ApiResponse<StorageNetworkEntity> localVarResp = this.networkGraphServicePatchExternalNetworkEntityWithHttpInfo(id, networkGraphServicePatchExternalNetworkEntityBody);
        return localVarResp.getData();
    }

    public ApiResponse<StorageNetworkEntity> networkGraphServicePatchExternalNetworkEntityWithHttpInfo(@Nonnull String id, @Nonnull NetworkGraphServicePatchExternalNetworkEntityBody networkGraphServicePatchExternalNetworkEntityBody) throws ApiException {
        Call localVarCall = this.networkGraphServicePatchExternalNetworkEntityValidateBeforeCall(id, networkGraphServicePatchExternalNetworkEntityBody, null);
        Type localVarReturnType = new TypeToken<StorageNetworkEntity>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkGraphServicePatchExternalNetworkEntityAsync(@Nonnull String id, @Nonnull NetworkGraphServicePatchExternalNetworkEntityBody networkGraphServicePatchExternalNetworkEntityBody, ApiCallback<StorageNetworkEntity> _callback) throws ApiException {
        Call localVarCall = this.networkGraphServicePatchExternalNetworkEntityValidateBeforeCall(id, networkGraphServicePatchExternalNetworkEntityBody, _callback);
        Type localVarReturnType = new TypeToken<StorageNetworkEntity>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call networkGraphServicePutNetworkGraphConfigCall(@Nonnull V1PutNetworkGraphConfigRequest v1PutNetworkGraphConfigRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1PutNetworkGraphConfigRequest localVarPostBody = v1PutNetworkGraphConfigRequest;
        String localVarPath = "/v1/networkgraph/config";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkGraphServicePutNetworkGraphConfigValidateBeforeCall(@Nonnull V1PutNetworkGraphConfigRequest v1PutNetworkGraphConfigRequest, ApiCallback _callback) throws ApiException {
        if (v1PutNetworkGraphConfigRequest == null) {
            throw new ApiException("Missing the required parameter 'v1PutNetworkGraphConfigRequest' when calling networkGraphServicePutNetworkGraphConfig(Async)");
        }
        return this.networkGraphServicePutNetworkGraphConfigCall(v1PutNetworkGraphConfigRequest, _callback);
    }

    public StorageNetworkGraphConfig networkGraphServicePutNetworkGraphConfig(@Nonnull V1PutNetworkGraphConfigRequest v1PutNetworkGraphConfigRequest) throws ApiException {
        ApiResponse<StorageNetworkGraphConfig> localVarResp = this.networkGraphServicePutNetworkGraphConfigWithHttpInfo(v1PutNetworkGraphConfigRequest);
        return localVarResp.getData();
    }

    public ApiResponse<StorageNetworkGraphConfig> networkGraphServicePutNetworkGraphConfigWithHttpInfo(@Nonnull V1PutNetworkGraphConfigRequest v1PutNetworkGraphConfigRequest) throws ApiException {
        Call localVarCall = this.networkGraphServicePutNetworkGraphConfigValidateBeforeCall(v1PutNetworkGraphConfigRequest, null);
        Type localVarReturnType = new TypeToken<StorageNetworkGraphConfig>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call networkGraphServicePutNetworkGraphConfigAsync(@Nonnull V1PutNetworkGraphConfigRequest v1PutNetworkGraphConfigRequest, ApiCallback<StorageNetworkGraphConfig> _callback) throws ApiException {
        Call localVarCall = this.networkGraphServicePutNetworkGraphConfigValidateBeforeCall(v1PutNetworkGraphConfigRequest, _callback);
        Type localVarReturnType = new TypeToken<StorageNetworkGraphConfig>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

