/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.api;

import com.google.gson.reflect.TypeToken;
import com.stackrox.invoker.ApiCallback;
import com.stackrox.invoker.ApiClient;
import com.stackrox.invoker.ApiException;
import com.stackrox.invoker.ApiResponse;
import com.stackrox.invoker.Configuration;
import com.stackrox.invoker.Pair;
import com.stackrox.model.ImageSBOMRequest;
import com.stackrox.model.SBOMSPDX23Document;
import com.stackrox.model.StorageImage;
import com.stackrox.model.StreamResultOfV1ExportImageResponse;
import com.stackrox.model.V1CountImagesResponse;
import com.stackrox.model.V1DeleteImagesResponse;
import com.stackrox.model.V1GetWatchedImagesResponse;
import com.stackrox.model.V1ListImagesResponse;
import com.stackrox.model.V1ScanImageRequest;
import com.stackrox.model.V1WatchImageRequest;
import com.stackrox.model.V1WatchImageResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class ImageServiceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ImageServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ImageServiceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call generateSBOMCall(@Nonnull ImageSBOMRequest imageSBOMRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ImageSBOMRequest localVarPostBody = imageSBOMRequest;
        String localVarPath = "/api/v1/images/sbom";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call generateSBOMValidateBeforeCall(@Nonnull ImageSBOMRequest imageSBOMRequest, ApiCallback _callback) throws ApiException {
        if (imageSBOMRequest == null) {
            throw new ApiException("Missing the required parameter 'imageSBOMRequest' when calling generateSBOM(Async)");
        }
        return this.generateSBOMCall(imageSBOMRequest, _callback);
    }

    public SBOMSPDX23Document generateSBOM(@Nonnull ImageSBOMRequest imageSBOMRequest) throws ApiException {
        ApiResponse<SBOMSPDX23Document> localVarResp = this.generateSBOMWithHttpInfo(imageSBOMRequest);
        return localVarResp.getData();
    }

    public ApiResponse<SBOMSPDX23Document> generateSBOMWithHttpInfo(@Nonnull ImageSBOMRequest imageSBOMRequest) throws ApiException {
        Call localVarCall = this.generateSBOMValidateBeforeCall(imageSBOMRequest, null);
        Type localVarReturnType = new TypeToken<SBOMSPDX23Document>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call generateSBOMAsync(@Nonnull ImageSBOMRequest imageSBOMRequest, ApiCallback<SBOMSPDX23Document> _callback) throws ApiException {
        Call localVarCall = this.generateSBOMValidateBeforeCall(imageSBOMRequest, _callback);
        Type localVarReturnType = new TypeToken<SBOMSPDX23Document>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call imageServiceCountImagesCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/imagescount";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (paginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.limit", paginationLimit));
        }
        if (paginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.offset", paginationOffset));
        }
        if (paginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.field", paginationSortOptionField));
        }
        if (paginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.reversed", paginationSortOptionReversed));
        }
        if (paginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.aggrFunc", paginationSortOptionAggregateByAggrFunc));
        }
        if (paginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.distinct", paginationSortOptionAggregateByDistinct));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageServiceCountImagesValidateBeforeCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        return this.imageServiceCountImagesCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
    }

    public V1CountImagesResponse imageServiceCountImages(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        ApiResponse<V1CountImagesResponse> localVarResp = this.imageServiceCountImagesWithHttpInfo(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct);
        return localVarResp.getData();
    }

    public ApiResponse<V1CountImagesResponse> imageServiceCountImagesWithHttpInfo(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        Call localVarCall = this.imageServiceCountImagesValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, null);
        Type localVarReturnType = new TypeToken<V1CountImagesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call imageServiceCountImagesAsync(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback<V1CountImagesResponse> _callback) throws ApiException {
        Call localVarCall = this.imageServiceCountImagesValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
        Type localVarReturnType = new TypeToken<V1CountImagesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call imageServiceDeleteImagesCall(@Nullable String queryQuery, @Nullable Integer queryPaginationLimit, @Nullable Integer queryPaginationOffset, @Nullable String queryPaginationSortOptionField, @Nullable Boolean queryPaginationSortOptionReversed, @Nullable String queryPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean queryPaginationSortOptionAggregateByDistinct, @Nullable Boolean confirm, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/images";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (queryQuery != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.query", queryQuery));
        }
        if (queryPaginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.limit", queryPaginationLimit));
        }
        if (queryPaginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.offset", queryPaginationOffset));
        }
        if (queryPaginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.sortOption.field", queryPaginationSortOptionField));
        }
        if (queryPaginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.sortOption.reversed", queryPaginationSortOptionReversed));
        }
        if (queryPaginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.sortOption.aggregateBy.aggrFunc", queryPaginationSortOptionAggregateByAggrFunc));
        }
        if (queryPaginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.sortOption.aggregateBy.distinct", queryPaginationSortOptionAggregateByDistinct));
        }
        if (confirm != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("confirm", confirm));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageServiceDeleteImagesValidateBeforeCall(@Nullable String queryQuery, @Nullable Integer queryPaginationLimit, @Nullable Integer queryPaginationOffset, @Nullable String queryPaginationSortOptionField, @Nullable Boolean queryPaginationSortOptionReversed, @Nullable String queryPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean queryPaginationSortOptionAggregateByDistinct, @Nullable Boolean confirm, ApiCallback _callback) throws ApiException {
        return this.imageServiceDeleteImagesCall(queryQuery, queryPaginationLimit, queryPaginationOffset, queryPaginationSortOptionField, queryPaginationSortOptionReversed, queryPaginationSortOptionAggregateByAggrFunc, queryPaginationSortOptionAggregateByDistinct, confirm, _callback);
    }

    public V1DeleteImagesResponse imageServiceDeleteImages(@Nullable String queryQuery, @Nullable Integer queryPaginationLimit, @Nullable Integer queryPaginationOffset, @Nullable String queryPaginationSortOptionField, @Nullable Boolean queryPaginationSortOptionReversed, @Nullable String queryPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean queryPaginationSortOptionAggregateByDistinct, @Nullable Boolean confirm) throws ApiException {
        ApiResponse<V1DeleteImagesResponse> localVarResp = this.imageServiceDeleteImagesWithHttpInfo(queryQuery, queryPaginationLimit, queryPaginationOffset, queryPaginationSortOptionField, queryPaginationSortOptionReversed, queryPaginationSortOptionAggregateByAggrFunc, queryPaginationSortOptionAggregateByDistinct, confirm);
        return localVarResp.getData();
    }

    public ApiResponse<V1DeleteImagesResponse> imageServiceDeleteImagesWithHttpInfo(@Nullable String queryQuery, @Nullable Integer queryPaginationLimit, @Nullable Integer queryPaginationOffset, @Nullable String queryPaginationSortOptionField, @Nullable Boolean queryPaginationSortOptionReversed, @Nullable String queryPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean queryPaginationSortOptionAggregateByDistinct, @Nullable Boolean confirm) throws ApiException {
        Call localVarCall = this.imageServiceDeleteImagesValidateBeforeCall(queryQuery, queryPaginationLimit, queryPaginationOffset, queryPaginationSortOptionField, queryPaginationSortOptionReversed, queryPaginationSortOptionAggregateByAggrFunc, queryPaginationSortOptionAggregateByDistinct, confirm, null);
        Type localVarReturnType = new TypeToken<V1DeleteImagesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call imageServiceDeleteImagesAsync(@Nullable String queryQuery, @Nullable Integer queryPaginationLimit, @Nullable Integer queryPaginationOffset, @Nullable String queryPaginationSortOptionField, @Nullable Boolean queryPaginationSortOptionReversed, @Nullable String queryPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean queryPaginationSortOptionAggregateByDistinct, @Nullable Boolean confirm, ApiCallback<V1DeleteImagesResponse> _callback) throws ApiException {
        Call localVarCall = this.imageServiceDeleteImagesValidateBeforeCall(queryQuery, queryPaginationLimit, queryPaginationOffset, queryPaginationSortOptionField, queryPaginationSortOptionReversed, queryPaginationSortOptionAggregateByAggrFunc, queryPaginationSortOptionAggregateByDistinct, confirm, _callback);
        Type localVarReturnType = new TypeToken<V1DeleteImagesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call imageServiceExportImagesCall(@Nullable Integer timeout, @Nullable String query, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/export/images";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (timeout != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeout", timeout));
        }
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageServiceExportImagesValidateBeforeCall(@Nullable Integer timeout, @Nullable String query, ApiCallback _callback) throws ApiException {
        return this.imageServiceExportImagesCall(timeout, query, _callback);
    }

    public StreamResultOfV1ExportImageResponse imageServiceExportImages(@Nullable Integer timeout, @Nullable String query) throws ApiException {
        ApiResponse<StreamResultOfV1ExportImageResponse> localVarResp = this.imageServiceExportImagesWithHttpInfo(timeout, query);
        return localVarResp.getData();
    }

    public ApiResponse<StreamResultOfV1ExportImageResponse> imageServiceExportImagesWithHttpInfo(@Nullable Integer timeout, @Nullable String query) throws ApiException {
        Call localVarCall = this.imageServiceExportImagesValidateBeforeCall(timeout, query, null);
        Type localVarReturnType = new TypeToken<StreamResultOfV1ExportImageResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call imageServiceExportImagesAsync(@Nullable Integer timeout, @Nullable String query, ApiCallback<StreamResultOfV1ExportImageResponse> _callback) throws ApiException {
        Call localVarCall = this.imageServiceExportImagesValidateBeforeCall(timeout, query, _callback);
        Type localVarReturnType = new TypeToken<StreamResultOfV1ExportImageResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call imageServiceGetImageCall(@Nonnull String id, @Nullable Boolean includeSnoozed, @Nullable Boolean stripDescription, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/images/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (includeSnoozed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("includeSnoozed", includeSnoozed));
        }
        if (stripDescription != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("stripDescription", stripDescription));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageServiceGetImageValidateBeforeCall(@Nonnull String id, @Nullable Boolean includeSnoozed, @Nullable Boolean stripDescription, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling imageServiceGetImage(Async)");
        }
        return this.imageServiceGetImageCall(id, includeSnoozed, stripDescription, _callback);
    }

    public StorageImage imageServiceGetImage(@Nonnull String id, @Nullable Boolean includeSnoozed, @Nullable Boolean stripDescription) throws ApiException {
        ApiResponse<StorageImage> localVarResp = this.imageServiceGetImageWithHttpInfo(id, includeSnoozed, stripDescription);
        return localVarResp.getData();
    }

    public ApiResponse<StorageImage> imageServiceGetImageWithHttpInfo(@Nonnull String id, @Nullable Boolean includeSnoozed, @Nullable Boolean stripDescription) throws ApiException {
        Call localVarCall = this.imageServiceGetImageValidateBeforeCall(id, includeSnoozed, stripDescription, null);
        Type localVarReturnType = new TypeToken<StorageImage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call imageServiceGetImageAsync(@Nonnull String id, @Nullable Boolean includeSnoozed, @Nullable Boolean stripDescription, ApiCallback<StorageImage> _callback) throws ApiException {
        Call localVarCall = this.imageServiceGetImageValidateBeforeCall(id, includeSnoozed, stripDescription, _callback);
        Type localVarReturnType = new TypeToken<StorageImage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call imageServiceGetWatchedImagesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/watchedimages";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageServiceGetWatchedImagesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.imageServiceGetWatchedImagesCall(_callback);
    }

    public V1GetWatchedImagesResponse imageServiceGetWatchedImages() throws ApiException {
        ApiResponse<V1GetWatchedImagesResponse> localVarResp = this.imageServiceGetWatchedImagesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<V1GetWatchedImagesResponse> imageServiceGetWatchedImagesWithHttpInfo() throws ApiException {
        Call localVarCall = this.imageServiceGetWatchedImagesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1GetWatchedImagesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call imageServiceGetWatchedImagesAsync(ApiCallback<V1GetWatchedImagesResponse> _callback) throws ApiException {
        Call localVarCall = this.imageServiceGetWatchedImagesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1GetWatchedImagesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call imageServiceInvalidateScanAndRegistryCachesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/images/cache/invalidate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageServiceInvalidateScanAndRegistryCachesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.imageServiceInvalidateScanAndRegistryCachesCall(_callback);
    }

    public Object imageServiceInvalidateScanAndRegistryCaches() throws ApiException {
        ApiResponse<Object> localVarResp = this.imageServiceInvalidateScanAndRegistryCachesWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<Object> imageServiceInvalidateScanAndRegistryCachesWithHttpInfo() throws ApiException {
        Call localVarCall = this.imageServiceInvalidateScanAndRegistryCachesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call imageServiceInvalidateScanAndRegistryCachesAsync(ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.imageServiceInvalidateScanAndRegistryCachesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call imageServiceListImagesCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/images";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (paginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.limit", paginationLimit));
        }
        if (paginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.offset", paginationOffset));
        }
        if (paginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.field", paginationSortOptionField));
        }
        if (paginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.reversed", paginationSortOptionReversed));
        }
        if (paginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.aggrFunc", paginationSortOptionAggregateByAggrFunc));
        }
        if (paginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.distinct", paginationSortOptionAggregateByDistinct));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageServiceListImagesValidateBeforeCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        return this.imageServiceListImagesCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
    }

    public V1ListImagesResponse imageServiceListImages(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        ApiResponse<V1ListImagesResponse> localVarResp = this.imageServiceListImagesWithHttpInfo(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct);
        return localVarResp.getData();
    }

    public ApiResponse<V1ListImagesResponse> imageServiceListImagesWithHttpInfo(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        Call localVarCall = this.imageServiceListImagesValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, null);
        Type localVarReturnType = new TypeToken<V1ListImagesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call imageServiceListImagesAsync(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback<V1ListImagesResponse> _callback) throws ApiException {
        Call localVarCall = this.imageServiceListImagesValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
        Type localVarReturnType = new TypeToken<V1ListImagesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call imageServiceScanImageCall(@Nonnull V1ScanImageRequest v1ScanImageRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1ScanImageRequest localVarPostBody = v1ScanImageRequest;
        String localVarPath = "/v1/images/scan";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageServiceScanImageValidateBeforeCall(@Nonnull V1ScanImageRequest v1ScanImageRequest, ApiCallback _callback) throws ApiException {
        if (v1ScanImageRequest == null) {
            throw new ApiException("Missing the required parameter 'v1ScanImageRequest' when calling imageServiceScanImage(Async)");
        }
        return this.imageServiceScanImageCall(v1ScanImageRequest, _callback);
    }

    public StorageImage imageServiceScanImage(@Nonnull V1ScanImageRequest v1ScanImageRequest) throws ApiException {
        ApiResponse<StorageImage> localVarResp = this.imageServiceScanImageWithHttpInfo(v1ScanImageRequest);
        return localVarResp.getData();
    }

    public ApiResponse<StorageImage> imageServiceScanImageWithHttpInfo(@Nonnull V1ScanImageRequest v1ScanImageRequest) throws ApiException {
        Call localVarCall = this.imageServiceScanImageValidateBeforeCall(v1ScanImageRequest, null);
        Type localVarReturnType = new TypeToken<StorageImage>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call imageServiceScanImageAsync(@Nonnull V1ScanImageRequest v1ScanImageRequest, ApiCallback<StorageImage> _callback) throws ApiException {
        Call localVarCall = this.imageServiceScanImageValidateBeforeCall(v1ScanImageRequest, _callback);
        Type localVarReturnType = new TypeToken<StorageImage>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call imageServiceUnwatchImageCall(@Nullable String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/watchedimages";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageServiceUnwatchImageValidateBeforeCall(@Nullable String name, ApiCallback _callback) throws ApiException {
        return this.imageServiceUnwatchImageCall(name, _callback);
    }

    public Object imageServiceUnwatchImage(@Nullable String name) throws ApiException {
        ApiResponse<Object> localVarResp = this.imageServiceUnwatchImageWithHttpInfo(name);
        return localVarResp.getData();
    }

    public ApiResponse<Object> imageServiceUnwatchImageWithHttpInfo(@Nullable String name) throws ApiException {
        Call localVarCall = this.imageServiceUnwatchImageValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call imageServiceUnwatchImageAsync(@Nullable String name, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.imageServiceUnwatchImageValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call imageServiceWatchImageCall(@Nonnull V1WatchImageRequest v1WatchImageRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1WatchImageRequest localVarPostBody = v1WatchImageRequest;
        String localVarPath = "/v1/watchedimages";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call imageServiceWatchImageValidateBeforeCall(@Nonnull V1WatchImageRequest v1WatchImageRequest, ApiCallback _callback) throws ApiException {
        if (v1WatchImageRequest == null) {
            throw new ApiException("Missing the required parameter 'v1WatchImageRequest' when calling imageServiceWatchImage(Async)");
        }
        return this.imageServiceWatchImageCall(v1WatchImageRequest, _callback);
    }

    public V1WatchImageResponse imageServiceWatchImage(@Nonnull V1WatchImageRequest v1WatchImageRequest) throws ApiException {
        ApiResponse<V1WatchImageResponse> localVarResp = this.imageServiceWatchImageWithHttpInfo(v1WatchImageRequest);
        return localVarResp.getData();
    }

    public ApiResponse<V1WatchImageResponse> imageServiceWatchImageWithHttpInfo(@Nonnull V1WatchImageRequest v1WatchImageRequest) throws ApiException {
        Call localVarCall = this.imageServiceWatchImageValidateBeforeCall(v1WatchImageRequest, null);
        Type localVarReturnType = new TypeToken<V1WatchImageResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call imageServiceWatchImageAsync(@Nonnull V1WatchImageRequest v1WatchImageRequest, ApiCallback<V1WatchImageResponse> _callback) throws ApiException {
        Call localVarCall = this.imageServiceWatchImageValidateBeforeCall(v1WatchImageRequest, _callback);
        Type localVarReturnType = new TypeToken<V1WatchImageResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

