/*
 * Decompiled with CFR 0.152.
 */
package com.stackrox.api;

import com.google.gson.reflect.TypeToken;
import com.stackrox.invoker.ApiCallback;
import com.stackrox.invoker.ApiClient;
import com.stackrox.invoker.ApiException;
import com.stackrox.invoker.ApiResponse;
import com.stackrox.invoker.Configuration;
import com.stackrox.invoker.Pair;
import com.stackrox.model.AlertServiceResolveAlertBody;
import com.stackrox.model.StorageAlert;
import com.stackrox.model.V1CountAlertsResponse;
import com.stackrox.model.V1DeleteAlertsResponse;
import com.stackrox.model.V1GetAlertTimeseriesResponse;
import com.stackrox.model.V1GetAlertsCountsResponse;
import com.stackrox.model.V1GetAlertsGroupResponse;
import com.stackrox.model.V1ListAlertsResponse;
import com.stackrox.model.V1ResolveAlertsRequest;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;

public class AlertServiceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlertServiceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlertServiceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call alertServiceCountAlertsCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/alertscount";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (paginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.limit", paginationLimit));
        }
        if (paginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.offset", paginationOffset));
        }
        if (paginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.field", paginationSortOptionField));
        }
        if (paginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.reversed", paginationSortOptionReversed));
        }
        if (paginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.aggrFunc", paginationSortOptionAggregateByAggrFunc));
        }
        if (paginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.distinct", paginationSortOptionAggregateByDistinct));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call alertServiceCountAlertsValidateBeforeCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        return this.alertServiceCountAlertsCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
    }

    public V1CountAlertsResponse alertServiceCountAlerts(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        ApiResponse<V1CountAlertsResponse> localVarResp = this.alertServiceCountAlertsWithHttpInfo(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct);
        return localVarResp.getData();
    }

    public ApiResponse<V1CountAlertsResponse> alertServiceCountAlertsWithHttpInfo(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        Call localVarCall = this.alertServiceCountAlertsValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, null);
        Type localVarReturnType = new TypeToken<V1CountAlertsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call alertServiceCountAlertsAsync(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback<V1CountAlertsResponse> _callback) throws ApiException {
        Call localVarCall = this.alertServiceCountAlertsValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
        Type localVarReturnType = new TypeToken<V1CountAlertsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call alertServiceDeleteAlertsCall(@Nullable String queryQuery, @Nullable Integer queryPaginationLimit, @Nullable Integer queryPaginationOffset, @Nullable String queryPaginationSortOptionField, @Nullable Boolean queryPaginationSortOptionReversed, @Nullable String queryPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean queryPaginationSortOptionAggregateByDistinct, @Nullable Boolean confirm, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/alerts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (queryQuery != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.query", queryQuery));
        }
        if (queryPaginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.limit", queryPaginationLimit));
        }
        if (queryPaginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.offset", queryPaginationOffset));
        }
        if (queryPaginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.sortOption.field", queryPaginationSortOptionField));
        }
        if (queryPaginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.sortOption.reversed", queryPaginationSortOptionReversed));
        }
        if (queryPaginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.sortOption.aggregateBy.aggrFunc", queryPaginationSortOptionAggregateByAggrFunc));
        }
        if (queryPaginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query.pagination.sortOption.aggregateBy.distinct", queryPaginationSortOptionAggregateByDistinct));
        }
        if (confirm != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("confirm", confirm));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call alertServiceDeleteAlertsValidateBeforeCall(@Nullable String queryQuery, @Nullable Integer queryPaginationLimit, @Nullable Integer queryPaginationOffset, @Nullable String queryPaginationSortOptionField, @Nullable Boolean queryPaginationSortOptionReversed, @Nullable String queryPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean queryPaginationSortOptionAggregateByDistinct, @Nullable Boolean confirm, ApiCallback _callback) throws ApiException {
        return this.alertServiceDeleteAlertsCall(queryQuery, queryPaginationLimit, queryPaginationOffset, queryPaginationSortOptionField, queryPaginationSortOptionReversed, queryPaginationSortOptionAggregateByAggrFunc, queryPaginationSortOptionAggregateByDistinct, confirm, _callback);
    }

    public V1DeleteAlertsResponse alertServiceDeleteAlerts(@Nullable String queryQuery, @Nullable Integer queryPaginationLimit, @Nullable Integer queryPaginationOffset, @Nullable String queryPaginationSortOptionField, @Nullable Boolean queryPaginationSortOptionReversed, @Nullable String queryPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean queryPaginationSortOptionAggregateByDistinct, @Nullable Boolean confirm) throws ApiException {
        ApiResponse<V1DeleteAlertsResponse> localVarResp = this.alertServiceDeleteAlertsWithHttpInfo(queryQuery, queryPaginationLimit, queryPaginationOffset, queryPaginationSortOptionField, queryPaginationSortOptionReversed, queryPaginationSortOptionAggregateByAggrFunc, queryPaginationSortOptionAggregateByDistinct, confirm);
        return localVarResp.getData();
    }

    public ApiResponse<V1DeleteAlertsResponse> alertServiceDeleteAlertsWithHttpInfo(@Nullable String queryQuery, @Nullable Integer queryPaginationLimit, @Nullable Integer queryPaginationOffset, @Nullable String queryPaginationSortOptionField, @Nullable Boolean queryPaginationSortOptionReversed, @Nullable String queryPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean queryPaginationSortOptionAggregateByDistinct, @Nullable Boolean confirm) throws ApiException {
        Call localVarCall = this.alertServiceDeleteAlertsValidateBeforeCall(queryQuery, queryPaginationLimit, queryPaginationOffset, queryPaginationSortOptionField, queryPaginationSortOptionReversed, queryPaginationSortOptionAggregateByAggrFunc, queryPaginationSortOptionAggregateByDistinct, confirm, null);
        Type localVarReturnType = new TypeToken<V1DeleteAlertsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call alertServiceDeleteAlertsAsync(@Nullable String queryQuery, @Nullable Integer queryPaginationLimit, @Nullable Integer queryPaginationOffset, @Nullable String queryPaginationSortOptionField, @Nullable Boolean queryPaginationSortOptionReversed, @Nullable String queryPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean queryPaginationSortOptionAggregateByDistinct, @Nullable Boolean confirm, ApiCallback<V1DeleteAlertsResponse> _callback) throws ApiException {
        Call localVarCall = this.alertServiceDeleteAlertsValidateBeforeCall(queryQuery, queryPaginationLimit, queryPaginationOffset, queryPaginationSortOptionField, queryPaginationSortOptionReversed, queryPaginationSortOptionAggregateByAggrFunc, queryPaginationSortOptionAggregateByDistinct, confirm, _callback);
        Type localVarReturnType = new TypeToken<V1DeleteAlertsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call alertServiceGetAlertCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/alerts/{id}".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call alertServiceGetAlertValidateBeforeCall(@Nonnull String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling alertServiceGetAlert(Async)");
        }
        return this.alertServiceGetAlertCall(id, _callback);
    }

    public StorageAlert alertServiceGetAlert(@Nonnull String id) throws ApiException {
        ApiResponse<StorageAlert> localVarResp = this.alertServiceGetAlertWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<StorageAlert> alertServiceGetAlertWithHttpInfo(@Nonnull String id) throws ApiException {
        Call localVarCall = this.alertServiceGetAlertValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<StorageAlert>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call alertServiceGetAlertAsync(@Nonnull String id, ApiCallback<StorageAlert> _callback) throws ApiException {
        Call localVarCall = this.alertServiceGetAlertValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<StorageAlert>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call alertServiceGetAlertTimeseriesCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/alerts/summary/timeseries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (paginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.limit", paginationLimit));
        }
        if (paginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.offset", paginationOffset));
        }
        if (paginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.field", paginationSortOptionField));
        }
        if (paginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.reversed", paginationSortOptionReversed));
        }
        if (paginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.aggrFunc", paginationSortOptionAggregateByAggrFunc));
        }
        if (paginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.distinct", paginationSortOptionAggregateByDistinct));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call alertServiceGetAlertTimeseriesValidateBeforeCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        return this.alertServiceGetAlertTimeseriesCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
    }

    public V1GetAlertTimeseriesResponse alertServiceGetAlertTimeseries(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        ApiResponse<V1GetAlertTimeseriesResponse> localVarResp = this.alertServiceGetAlertTimeseriesWithHttpInfo(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetAlertTimeseriesResponse> alertServiceGetAlertTimeseriesWithHttpInfo(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        Call localVarCall = this.alertServiceGetAlertTimeseriesValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, null);
        Type localVarReturnType = new TypeToken<V1GetAlertTimeseriesResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call alertServiceGetAlertTimeseriesAsync(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback<V1GetAlertTimeseriesResponse> _callback) throws ApiException {
        Call localVarCall = this.alertServiceGetAlertTimeseriesValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
        Type localVarReturnType = new TypeToken<V1GetAlertTimeseriesResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call alertServiceGetAlertsCountsCall(@Nullable String requestQuery, @Nullable Integer requestPaginationLimit, @Nullable Integer requestPaginationOffset, @Nullable String requestPaginationSortOptionField, @Nullable Boolean requestPaginationSortOptionReversed, @Nullable String requestPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean requestPaginationSortOptionAggregateByDistinct, @Nullable String groupBy, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/alerts/summary/counts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (requestQuery != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("request.query", requestQuery));
        }
        if (requestPaginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("request.pagination.limit", requestPaginationLimit));
        }
        if (requestPaginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("request.pagination.offset", requestPaginationOffset));
        }
        if (requestPaginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("request.pagination.sortOption.field", requestPaginationSortOptionField));
        }
        if (requestPaginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("request.pagination.sortOption.reversed", requestPaginationSortOptionReversed));
        }
        if (requestPaginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("request.pagination.sortOption.aggregateBy.aggrFunc", requestPaginationSortOptionAggregateByAggrFunc));
        }
        if (requestPaginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("request.pagination.sortOption.aggregateBy.distinct", requestPaginationSortOptionAggregateByDistinct));
        }
        if (groupBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("groupBy", groupBy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call alertServiceGetAlertsCountsValidateBeforeCall(@Nullable String requestQuery, @Nullable Integer requestPaginationLimit, @Nullable Integer requestPaginationOffset, @Nullable String requestPaginationSortOptionField, @Nullable Boolean requestPaginationSortOptionReversed, @Nullable String requestPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean requestPaginationSortOptionAggregateByDistinct, @Nullable String groupBy, ApiCallback _callback) throws ApiException {
        return this.alertServiceGetAlertsCountsCall(requestQuery, requestPaginationLimit, requestPaginationOffset, requestPaginationSortOptionField, requestPaginationSortOptionReversed, requestPaginationSortOptionAggregateByAggrFunc, requestPaginationSortOptionAggregateByDistinct, groupBy, _callback);
    }

    public V1GetAlertsCountsResponse alertServiceGetAlertsCounts(@Nullable String requestQuery, @Nullable Integer requestPaginationLimit, @Nullable Integer requestPaginationOffset, @Nullable String requestPaginationSortOptionField, @Nullable Boolean requestPaginationSortOptionReversed, @Nullable String requestPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean requestPaginationSortOptionAggregateByDistinct, @Nullable String groupBy) throws ApiException {
        ApiResponse<V1GetAlertsCountsResponse> localVarResp = this.alertServiceGetAlertsCountsWithHttpInfo(requestQuery, requestPaginationLimit, requestPaginationOffset, requestPaginationSortOptionField, requestPaginationSortOptionReversed, requestPaginationSortOptionAggregateByAggrFunc, requestPaginationSortOptionAggregateByDistinct, groupBy);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetAlertsCountsResponse> alertServiceGetAlertsCountsWithHttpInfo(@Nullable String requestQuery, @Nullable Integer requestPaginationLimit, @Nullable Integer requestPaginationOffset, @Nullable String requestPaginationSortOptionField, @Nullable Boolean requestPaginationSortOptionReversed, @Nullable String requestPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean requestPaginationSortOptionAggregateByDistinct, @Nullable String groupBy) throws ApiException {
        Call localVarCall = this.alertServiceGetAlertsCountsValidateBeforeCall(requestQuery, requestPaginationLimit, requestPaginationOffset, requestPaginationSortOptionField, requestPaginationSortOptionReversed, requestPaginationSortOptionAggregateByAggrFunc, requestPaginationSortOptionAggregateByDistinct, groupBy, null);
        Type localVarReturnType = new TypeToken<V1GetAlertsCountsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call alertServiceGetAlertsCountsAsync(@Nullable String requestQuery, @Nullable Integer requestPaginationLimit, @Nullable Integer requestPaginationOffset, @Nullable String requestPaginationSortOptionField, @Nullable Boolean requestPaginationSortOptionReversed, @Nullable String requestPaginationSortOptionAggregateByAggrFunc, @Nullable Boolean requestPaginationSortOptionAggregateByDistinct, @Nullable String groupBy, ApiCallback<V1GetAlertsCountsResponse> _callback) throws ApiException {
        Call localVarCall = this.alertServiceGetAlertsCountsValidateBeforeCall(requestQuery, requestPaginationLimit, requestPaginationOffset, requestPaginationSortOptionField, requestPaginationSortOptionReversed, requestPaginationSortOptionAggregateByAggrFunc, requestPaginationSortOptionAggregateByDistinct, groupBy, _callback);
        Type localVarReturnType = new TypeToken<V1GetAlertsCountsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call alertServiceGetAlertsGroupCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/alerts/summary/groups";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (paginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.limit", paginationLimit));
        }
        if (paginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.offset", paginationOffset));
        }
        if (paginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.field", paginationSortOptionField));
        }
        if (paginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.reversed", paginationSortOptionReversed));
        }
        if (paginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.aggrFunc", paginationSortOptionAggregateByAggrFunc));
        }
        if (paginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.distinct", paginationSortOptionAggregateByDistinct));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call alertServiceGetAlertsGroupValidateBeforeCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        return this.alertServiceGetAlertsGroupCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
    }

    public V1GetAlertsGroupResponse alertServiceGetAlertsGroup(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        ApiResponse<V1GetAlertsGroupResponse> localVarResp = this.alertServiceGetAlertsGroupWithHttpInfo(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct);
        return localVarResp.getData();
    }

    public ApiResponse<V1GetAlertsGroupResponse> alertServiceGetAlertsGroupWithHttpInfo(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        Call localVarCall = this.alertServiceGetAlertsGroupValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, null);
        Type localVarReturnType = new TypeToken<V1GetAlertsGroupResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call alertServiceGetAlertsGroupAsync(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback<V1GetAlertsGroupResponse> _callback) throws ApiException {
        Call localVarCall = this.alertServiceGetAlertsGroupValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
        Type localVarReturnType = new TypeToken<V1GetAlertsGroupResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call alertServiceListAlertsCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/alerts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (query != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("query", query));
        }
        if (paginationLimit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.limit", paginationLimit));
        }
        if (paginationOffset != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.offset", paginationOffset));
        }
        if (paginationSortOptionField != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.field", paginationSortOptionField));
        }
        if (paginationSortOptionReversed != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.reversed", paginationSortOptionReversed));
        }
        if (paginationSortOptionAggregateByAggrFunc != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.aggrFunc", paginationSortOptionAggregateByAggrFunc));
        }
        if (paginationSortOptionAggregateByDistinct != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pagination.sortOption.aggregateBy.distinct", paginationSortOptionAggregateByDistinct));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call alertServiceListAlertsValidateBeforeCall(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback _callback) throws ApiException {
        return this.alertServiceListAlertsCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
    }

    public V1ListAlertsResponse alertServiceListAlerts(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        ApiResponse<V1ListAlertsResponse> localVarResp = this.alertServiceListAlertsWithHttpInfo(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct);
        return localVarResp.getData();
    }

    public ApiResponse<V1ListAlertsResponse> alertServiceListAlertsWithHttpInfo(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct) throws ApiException {
        Call localVarCall = this.alertServiceListAlertsValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, null);
        Type localVarReturnType = new TypeToken<V1ListAlertsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call alertServiceListAlertsAsync(@Nullable String query, @Nullable Integer paginationLimit, @Nullable Integer paginationOffset, @Nullable String paginationSortOptionField, @Nullable Boolean paginationSortOptionReversed, @Nullable String paginationSortOptionAggregateByAggrFunc, @Nullable Boolean paginationSortOptionAggregateByDistinct, ApiCallback<V1ListAlertsResponse> _callback) throws ApiException {
        Call localVarCall = this.alertServiceListAlertsValidateBeforeCall(query, paginationLimit, paginationOffset, paginationSortOptionField, paginationSortOptionReversed, paginationSortOptionAggregateByAggrFunc, paginationSortOptionAggregateByDistinct, _callback);
        Type localVarReturnType = new TypeToken<V1ListAlertsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call alertServiceResolveAlertCall(@Nonnull String id, @Nonnull AlertServiceResolveAlertBody alertServiceResolveAlertBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlertServiceResolveAlertBody localVarPostBody = alertServiceResolveAlertBody;
        String localVarPath = "/v1/alerts/{id}/resolve".replace("{id}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call alertServiceResolveAlertValidateBeforeCall(@Nonnull String id, @Nonnull AlertServiceResolveAlertBody alertServiceResolveAlertBody, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling alertServiceResolveAlert(Async)");
        }
        if (alertServiceResolveAlertBody == null) {
            throw new ApiException("Missing the required parameter 'alertServiceResolveAlertBody' when calling alertServiceResolveAlert(Async)");
        }
        return this.alertServiceResolveAlertCall(id, alertServiceResolveAlertBody, _callback);
    }

    public Object alertServiceResolveAlert(@Nonnull String id, @Nonnull AlertServiceResolveAlertBody alertServiceResolveAlertBody) throws ApiException {
        ApiResponse<Object> localVarResp = this.alertServiceResolveAlertWithHttpInfo(id, alertServiceResolveAlertBody);
        return localVarResp.getData();
    }

    public ApiResponse<Object> alertServiceResolveAlertWithHttpInfo(@Nonnull String id, @Nonnull AlertServiceResolveAlertBody alertServiceResolveAlertBody) throws ApiException {
        Call localVarCall = this.alertServiceResolveAlertValidateBeforeCall(id, alertServiceResolveAlertBody, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call alertServiceResolveAlertAsync(@Nonnull String id, @Nonnull AlertServiceResolveAlertBody alertServiceResolveAlertBody, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.alertServiceResolveAlertValidateBeforeCall(id, alertServiceResolveAlertBody, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call alertServiceResolveAlertsCall(@Nonnull V1ResolveAlertsRequest v1ResolveAlertsRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1ResolveAlertsRequest localVarPostBody = v1ResolveAlertsRequest;
        String localVarPath = "/v1/alerts/resolve";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"basicAuth", "bearerAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call alertServiceResolveAlertsValidateBeforeCall(@Nonnull V1ResolveAlertsRequest v1ResolveAlertsRequest, ApiCallback _callback) throws ApiException {
        if (v1ResolveAlertsRequest == null) {
            throw new ApiException("Missing the required parameter 'v1ResolveAlertsRequest' when calling alertServiceResolveAlerts(Async)");
        }
        return this.alertServiceResolveAlertsCall(v1ResolveAlertsRequest, _callback);
    }

    public Object alertServiceResolveAlerts(@Nonnull V1ResolveAlertsRequest v1ResolveAlertsRequest) throws ApiException {
        ApiResponse<Object> localVarResp = this.alertServiceResolveAlertsWithHttpInfo(v1ResolveAlertsRequest);
        return localVarResp.getData();
    }

    public ApiResponse<Object> alertServiceResolveAlertsWithHttpInfo(@Nonnull V1ResolveAlertsRequest v1ResolveAlertsRequest) throws ApiException {
        Call localVarCall = this.alertServiceResolveAlertsValidateBeforeCall(v1ResolveAlertsRequest, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call alertServiceResolveAlertsAsync(@Nonnull V1ResolveAlertsRequest v1ResolveAlertsRequest, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.alertServiceResolveAlertsValidateBeforeCall(v1ResolveAlertsRequest, _callback);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

