/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sshsteps.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.ClassLoaderSanityThreadFactory;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import jenkins.model.Jenkins;
import lombok.Generated;
import org.apache.log4j.MDC;
import org.jenkinsci.plugins.sshsteps.steps.BasicSSHStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.springframework.security.core.Authentication;

public abstract class SSHStepExecution<T>
extends StepExecution {
    private final transient TaskListener listener;
    private final transient Launcher launcher;
    private static ExecutorService executorService;
    private final BasicSSHStep step;
    private volatile transient Future<?> task;
    private transient String threadName;
    private transient Throwable stopCause;

    protected SSHStepExecution(BasicSSHStep step, @NonNull StepContext context) throws IOException, InterruptedException {
        super(context);
        this.listener = (TaskListener)context.get(TaskListener.class);
        this.launcher = (Launcher)context.get(Launcher.class);
        this.step = step;
    }

    static synchronized ExecutorService getExecutorService() {
        if (executorService == null) {
            executorService = Executors.newCachedThreadPool((ThreadFactory)new NamingThreadFactory((ThreadFactory)new ClassLoaderSanityThreadFactory((ThreadFactory)new DaemonThreadFactory()), "org.jenkinsci.plugins.ssh.util.SSHStepExecution"));
        }
        return executorService;
    }

    protected abstract T run() throws Exception;

    protected VirtualChannel getChannel() {
        VirtualChannel channel = this.getLauncher().getChannel();
        if (channel == null) {
            throw new IllegalArgumentException("Unable to get the channel, Perhaps you forgot to surround the code with a step that provides this, such as: node, dockerNode");
        }
        return channel;
    }

    public final boolean start() {
        Authentication auth = Jenkins.getAuthentication2();
        this.task = SSHStepExecution.getExecutorService().submit(() -> {
            this.threadName = Thread.currentThread().getName();
            try {
                T ret;
                MDC.put((String)"execution.id", (String)UUID.randomUUID().toString());
                try (ACLContext acl = ACL.as2((Authentication)auth);){
                    ret = this.run();
                }
                this.getContext().onSuccess(ret);
            }
            catch (Throwable x) {
                if (this.stopCause == null) {
                    this.getContext().onFailure(x);
                } else {
                    this.stopCause.addSuppressed(x);
                }
            }
            finally {
                MDC.clear();
            }
        });
        return false;
    }

    public void stop(@NonNull Throwable cause) throws Exception {
        if (this.task != null) {
            this.stopCause = cause;
            this.task.cancel(true);
        }
        super.stop(cause);
    }

    public void onResume() {
        this.getContext().onFailure((Throwable)new Exception("Resume after a restart not supported for non-blocking synchronous steps"));
    }

    @NonNull
    public String getStatus() {
        if (this.threadName != null) {
            return "running in thread: " + this.threadName;
        }
        return "not yet scheduled";
    }

    @Generated
    public TaskListener getListener() {
        return this.listener;
    }

    @Generated
    public Launcher getLauncher() {
        return this.launcher;
    }

    @Generated
    public BasicSSHStep getStep() {
        return this.step;
    }
}

