/*
 * Decompiled with CFR 0.152.
 */
package shaded.splk.org.apache.http.protocol;

import java.io.IOException;
import shaded.splk.org.apache.http.HttpEntityEnclosingRequest;
import shaded.splk.org.apache.http.HttpException;
import shaded.splk.org.apache.http.HttpRequest;
import shaded.splk.org.apache.http.HttpRequestInterceptor;
import shaded.splk.org.apache.http.annotation.Contract;
import shaded.splk.org.apache.http.annotation.ThreadingBehavior;
import shaded.splk.org.apache.http.protocol.HttpContext;
import shaded.splk.org.apache.http.protocol.HttpDateGenerator;
import shaded.splk.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

