/*
 * Decompiled with CFR 0.152.
 */
package shaded.splk.org.apache.http.protocol;

import java.io.IOException;
import shaded.splk.org.apache.http.HttpException;
import shaded.splk.org.apache.http.HttpRequest;
import shaded.splk.org.apache.http.HttpRequestInterceptor;
import shaded.splk.org.apache.http.annotation.Contract;
import shaded.splk.org.apache.http.annotation.ThreadingBehavior;
import shaded.splk.org.apache.http.protocol.HttpContext;
import shaded.splk.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

