/*
 * Decompiled with CFR 0.152.
 */
package shaded.splk.org.apache.http.impl.entity;

import java.io.IOException;
import shaded.splk.org.apache.http.Header;
import shaded.splk.org.apache.http.HttpEntity;
import shaded.splk.org.apache.http.HttpException;
import shaded.splk.org.apache.http.HttpMessage;
import shaded.splk.org.apache.http.annotation.Contract;
import shaded.splk.org.apache.http.annotation.ThreadingBehavior;
import shaded.splk.org.apache.http.entity.BasicHttpEntity;
import shaded.splk.org.apache.http.entity.ContentLengthStrategy;
import shaded.splk.org.apache.http.impl.io.ChunkedInputStream;
import shaded.splk.org.apache.http.impl.io.ContentLengthInputStream;
import shaded.splk.org.apache.http.impl.io.IdentityInputStream;
import shaded.splk.org.apache.http.io.SessionInputBuffer;
import shaded.splk.org.apache.http.util.Args;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inBuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inBuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inBuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inBuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inBuffer, HttpMessage message) throws HttpException, IOException {
        Args.notNull(inBuffer, "Session input buffer");
        Args.notNull(message, "HTTP message");
        return this.doDeserialize(inBuffer, message);
    }
}

