/*
 * Decompiled with CFR 0.152.
 */
package shaded.splk.org.apache.http.client.protocol;

import java.io.IOException;
import shaded.splk.org.apache.http.HttpEntity;
import shaded.splk.org.apache.http.HttpEntityEnclosingRequest;
import shaded.splk.org.apache.http.HttpException;
import shaded.splk.org.apache.http.HttpRequest;
import shaded.splk.org.apache.http.HttpRequestInterceptor;
import shaded.splk.org.apache.http.HttpVersion;
import shaded.splk.org.apache.http.ProtocolVersion;
import shaded.splk.org.apache.http.annotation.Contract;
import shaded.splk.org.apache.http.annotation.ThreadingBehavior;
import shaded.splk.org.apache.http.client.config.RequestConfig;
import shaded.splk.org.apache.http.client.protocol.HttpClientContext;
import shaded.splk.org.apache.http.protocol.HttpContext;
import shaded.splk.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

