/*
 * Decompiled with CFR 0.152.
 */
package shaded.splk.org.apache.http.client.protocol;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.splk.org.apache.http.HttpException;
import shaded.splk.org.apache.http.HttpHost;
import shaded.splk.org.apache.http.HttpRequest;
import shaded.splk.org.apache.http.HttpRequestInterceptor;
import shaded.splk.org.apache.http.annotation.Contract;
import shaded.splk.org.apache.http.annotation.ThreadingBehavior;
import shaded.splk.org.apache.http.auth.AuthProtocolState;
import shaded.splk.org.apache.http.auth.AuthScheme;
import shaded.splk.org.apache.http.auth.AuthScope;
import shaded.splk.org.apache.http.auth.AuthState;
import shaded.splk.org.apache.http.auth.Credentials;
import shaded.splk.org.apache.http.client.AuthCache;
import shaded.splk.org.apache.http.client.CredentialsProvider;
import shaded.splk.org.apache.http.client.protocol.HttpClientContext;
import shaded.splk.org.apache.http.conn.routing.RouteInfo;
import shaded.splk.org.apache.http.protocol.HttpContext;
import shaded.splk.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAuthCache
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthScheme authScheme;
        AuthScheme authScheme2;
        AuthState targetState;
        Args.notNull(request, "HTTP request");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache == null) {
            this.log.debug((Object)"Auth cache not set in the context");
            return;
        }
        CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
        if (credsProvider == null) {
            this.log.debug((Object)"Credentials provider not set in the context");
            return;
        }
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug((Object)"Route info not set in the context");
            return;
        }
        HttpHost target = clientContext.getTargetHost();
        if (target == null) {
            this.log.debug((Object)"Target host not set in the context");
            return;
        }
        if (target.getPort() < 0) {
            target = new HttpHost(target.getHostName(), route.getTargetHost().getPort(), target.getSchemeName());
        }
        if ((targetState = clientContext.getTargetAuthState()) != null && targetState.getState() == AuthProtocolState.UNCHALLENGED && (authScheme2 = authCache.get(target)) != null) {
            this.doPreemptiveAuth(target, authScheme2, targetState, credsProvider);
        }
        HttpHost proxy = route.getProxyHost();
        AuthState proxyState = clientContext.getProxyAuthState();
        if (proxy != null && proxyState != null && proxyState.getState() == AuthProtocolState.UNCHALLENGED && (authScheme = authCache.get(proxy)) != null) {
            this.doPreemptiveAuth(proxy, authScheme, proxyState, credsProvider);
        }
    }

    private void doPreemptiveAuth(HttpHost host, AuthScheme authScheme, AuthState authState, CredentialsProvider credsProvider) {
        AuthScope authScope;
        Credentials creds;
        String schemeName = authScheme.getSchemeName();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Re-using cached '" + schemeName + "' auth scheme for " + host));
        }
        if ((creds = credsProvider.getCredentials(authScope = new AuthScope(host, AuthScope.ANY_REALM, schemeName))) != null) {
            authState.update(authScheme, creds);
        } else {
            this.log.debug((Object)"No credentials for preemptive authentication");
        }
    }
}

