/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.listeners;

import com.splunk.splunkjenkins.listeners.Messages;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import java.io.File;

@Extension
public class LoggingItemListener
extends ItemListener {
    public void onCreated(Item item) {
        LogEventHelper.logUserAction(LogEventHelper.getUserName(), Messages.audit_create_item(this.getConfigPath(item)));
    }

    public void onCopied(Item src, Item item) {
        LogEventHelper.logUserAction(LogEventHelper.getUserName(), Messages.audit_cloned_item(this.getConfigPath(item), this.getConfigPath(src)));
    }

    public void onDeleted(Item item) {
        LogEventHelper.logUserAction(LogEventHelper.getUserName(), Messages.audit_delete_item(this.getConfigPath(item)));
    }

    public void onRenamed(Item item, String oldName, String newName) {
    }

    public void onUpdated(Item item) {
        LogEventHelper.logUserAction(LogEventHelper.getUserName(), Messages.audit_update_item(this.getConfigPath(item)));
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
        LogEventHelper.logUserAction(LogEventHelper.getUserName(), Messages.audit_rename_item(oldFullName, newFullName));
    }

    private String getConfigPath(Item item) {
        if (item == null) {
            return "unknown";
        }
        return LogEventHelper.getRelativeJenkinsHomePath(String.valueOf(item.getRootDir()) + File.separator + "config.xml");
    }

    public void onBeforeShutdown() {
        SplunkLogService.getInstance().stopWorker();
        SplunkLogService.getInstance().releaseConnection();
    }
}

