/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.splunk.splunkjenkins.Constants;
import com.splunk.splunkjenkins.Messages;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.model.MetaDataConfigItem;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.GroovyCodeSource;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class SplunkJenkinsInstallation
extends GlobalConfiguration {
    private static transient boolean logHandlerRegistered = false;
    private static final transient Logger LOG = Logger.getLogger(SplunkJenkinsInstallation.class.getName());
    private static volatile transient SplunkJenkinsInstallation cachedConfig;
    private static final transient Pattern uuidPattern;
    private boolean enabled = false;
    private String host;
    private Secret token;
    private boolean useSSL = true;
    private Integer port = 8088;
    private long maxEventsBatchSize = 262144L;
    private long retriesOnError = 3L;
    private boolean rawEventEnabled = true;
    private String scriptPath;
    private String metaDataConfig;
    private String scriptContent;
    private String splunkAppUrl;
    private String metadataHost;
    private String metadataSource;
    private String ignoredJobs;
    private Boolean globalPipelineFilter;
    public transient Properties metaDataProperties = new Properties();
    private transient String jsonUrl;
    private transient String rawUrl;
    private transient File scriptFile;
    private transient long scriptTimestamp;
    private transient String postActionScript;
    private transient Set<MetaDataConfigItem> metadataItemSet = new HashSet<MetaDataConfigItem>();
    private transient String defaultMetaData;
    private transient Pattern ignoredJobPattern;

    public SplunkJenkinsInstallation(boolean useConfigFile) {
        if (useConfigFile) {
            this.load();
        }
    }

    public final synchronized void load() {
        super.load();
        this.migrate();
        try (InputStream metaInput = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("metadata.properties");){
            this.defaultMetaData = IOUtils.toString((InputStream)metaInput);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public SplunkJenkinsInstallation() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SplunkJenkinsInstallation get() {
        if (cachedConfig != null) return cachedConfig;
        if (Jenkins.getInstanceOrNull() == null) {
            return SplunkJenkinsInstallation.buildTempInstance();
        }
        Class<SplunkJenkinsInstallation> clazz = SplunkJenkinsInstallation.class;
        synchronized (SplunkJenkinsInstallation.class) {
            if (cachedConfig != null || (cachedConfig = (SplunkJenkinsInstallation)Jenkins.getInstance().getDescriptor(SplunkJenkinsInstallation.class)) != null) return cachedConfig;
            // ** MonitorExit[var0] (shouldn't be in output)
            return SplunkJenkinsInstallation.buildTempInstance();
        }
    }

    private static SplunkJenkinsInstallation buildTempInstance() {
        SplunkJenkinsInstallation temp = new SplunkJenkinsInstallation(false);
        temp.enabled = false;
        return temp;
    }

    public static boolean isLogHandlerRegistered() {
        return logHandlerRegistered && Jenkins.getInstance() != null;
    }

    public static void markComplete(boolean completed) {
        logHandlerRegistered = completed;
    }

    public static void initOnAgent(SplunkJenkinsInstallation config) {
        cachedConfig = config;
        config.updateCache();
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        this.metadataItemSet = null;
        boolean previousState = this.enabled;
        req.bindJSON((Object)this, formData);
        if (this.metadataItemSet == null) {
            this.metaDataConfig = "";
        }
        if ("file".equals(formData.get("commandsOrFileInSplunkins"))) {
            this.scriptContent = null;
        } else {
            this.scriptPath = null;
        }
        this.updateCache();
        this.save();
        if (previousState && !this.enabled) {
            SplunkLogService.getInstance().stopWorker();
            SplunkLogService.getInstance().releaseConnection();
        }
        return true;
    }

    @RequirePOST
    public FormValidation doCheckHost(@QueryParameter(value="value") String hostName) {
        if (StringUtils.isBlank((CharSequence)hostName)) {
            return FormValidation.warning((String)Messages.PleaseProvideHost());
        }
        if (hostName.startsWith("http://") || hostName.startsWith("https://")) {
            try {
                URI uri = new URI(hostName);
                String domain = uri.getHost();
                return FormValidation.warning((String)Messages.HostNameSchemaWarning(domain));
            }
            catch (URISyntaxException e) {
                return FormValidation.warning((String)Messages.HostNameInvalid());
            }
        }
        if ((hostName.endsWith("cloud.splunk.com") || hostName.endsWith("splunkcloud.com") || hostName.endsWith("splunktrial.com")) && !hostName.startsWith("input-") && !hostName.startsWith("http-inputs-")) {
            return FormValidation.warning((String)Messages.CloudHostPrefix(hostName));
        }
        return FormValidation.ok();
    }

    @RequirePOST
    public FormValidation doCheckToken(@QueryParameter(value="value") Secret token) {
        String value = Secret.toString((Secret)token);
        if (StringUtils.isBlank((CharSequence)value) || !uuidPattern.matcher(value).find()) {
            return FormValidation.warning((String)Messages.InvalidToken());
        }
        return FormValidation.ok();
    }

    @RequirePOST
    public FormValidation doTestHttpInput(@QueryParameter String host, @QueryParameter int port, @QueryParameter Secret token, @QueryParameter boolean useSSL, @QueryParameter String metaDataConfig) {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        SplunkJenkinsInstallation config = new SplunkJenkinsInstallation(false);
        config.host = host;
        config.port = port;
        config.token = token;
        config.useSSL = useSSL;
        config.metaDataConfig = metaDataConfig;
        config.enabled = true;
        config.updateCache();
        if (!config.isValid()) {
            return FormValidation.error((String)Messages.InvalidHostOrToken());
        }
        return LogEventHelper.verifyHttpInput(config);
    }

    @RequirePOST
    public FormValidation doCheckScriptContent(@QueryParameter String value) {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        if (StringUtils.isBlank((CharSequence)value)) {
            return FormValidation.ok();
        }
        return LogEventHelper.validateGroovyScript(value);
    }

    @RequirePOST
    public FormValidation doCheckMaxEventsBatchSize(@QueryParameter int value) {
        if (value < Constants.MIN_BUFFER_SIZE || value > 0x800000) {
            return FormValidation.error((String)String.format("please consider a value between %d and %d", Constants.MIN_BUFFER_SIZE, 0x800000));
        }
        return FormValidation.ok();
    }

    @RequirePOST
    public FormValidation doCheckIgnoredJobs(@QueryParameter String value) {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        try {
            Pattern.compile(value);
        }
        catch (PatternSyntaxException ex) {
            return FormValidation.errorWithMarkup((String)Messages.InvalidPattern());
        }
        return FormValidation.ok();
    }

    protected void updateCache() {
        if (!this.enabled) {
            return;
        }
        if (this.scriptPath != null) {
            this.scriptFile = new File(this.scriptPath);
            this.refreshScriptText();
        } else if (LogEventHelper.nonEmpty(this.scriptContent)) {
            this.postActionScript = this.scriptContent;
            this.scriptTimestamp = System.currentTimeMillis();
            this.checkApprove(this.postActionScript);
        } else {
            this.postActionScript = null;
            this.scriptTimestamp = 0L;
        }
        if (StringUtils.isEmpty((CharSequence)this.ignoredJobs)) {
            this.ignoredJobPattern = null;
        } else {
            try {
                this.ignoredJobPattern = Pattern.compile(this.ignoredJobs);
            }
            catch (PatternSyntaxException ex) {
                LOG.log(Level.SEVERE, "invalid ignore job pattern {0}, error: {1}", new Object[]{this.ignoredJobs, ex.getDescription()});
            }
        }
        try {
            String scheme = this.useSSL ? "https://" : "http://";
            this.jsonUrl = scheme + this.host + ":" + this.port + "/services/collector/event";
            this.rawUrl = scheme + this.host + ":" + this.port + "/services/collector/raw";
            this.metaDataProperties = new Properties();
            String combinedMetaData = Util.fixNull((String)this.defaultMetaData) + "\n" + Util.fixNull((String)this.metaDataConfig);
            if (!StringUtils.isEmpty((CharSequence)combinedMetaData)) {
                this.metaDataProperties.load(new StringReader(combinedMetaData));
            }
            if (StringUtils.isNotEmpty((CharSequence)this.metadataSource)) {
                this.metaDataProperties.put("source", this.metadataSource);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "update cache failed, splunk host:" + this.host, e);
        }
    }

    private void checkApprove(String scriptText) {
        if (scriptText == null) {
            return;
        }
        Authentication auth = Jenkins.getAuthentication();
        String userName = auth.getName();
        ApprovalContext context = ApprovalContext.create().withUser(userName).withKey(((Object)((Object)this)).getClass().getName());
        ScriptApproval.get().configuring(scriptText, GroovyLanguage.get(), context);
    }

    private void refreshScriptText() {
        if (this.scriptFile == null) {
            return;
        }
        try {
            if (!this.scriptFile.canRead()) {
                this.postActionScript = null;
            } else {
                this.scriptTimestamp = this.scriptFile.lastModified();
                this.postActionScript = IOUtils.toString((URI)this.scriptFile.toURI());
                this.checkApprove(this.postActionScript);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "can not read file " + String.valueOf(this.scriptFile), e);
        }
    }

    public boolean isValid() {
        return this.enabled && this.host != null && this.token != null && StringUtils.isNotEmpty((CharSequence)this.token.getPlainText()) && this.jsonUrl != null && this.rawUrl != null;
    }

    public String getScript() {
        if (this.scriptPath != null && this.scriptFile.lastModified() > this.scriptTimestamp) {
            this.refreshScriptText();
        }
        return this.postActionScript;
    }

    public GroovyCodeSource getCode() {
        String script = this.getScript();
        GroovyCodeSource codeSource = new GroovyCodeSource(script, "SplunkinUserScript" + this.scriptTimestamp, "/groovy/shell");
        return codeSource;
    }

    public boolean isRawEventEnabled() {
        return this.rawEventEnabled;
    }

    public boolean canPostRaw(EventType eventType) {
        return this.rawEventEnabled && eventType.needSplit();
    }

    public Secret getToken() {
        return this.token;
    }

    @NonNull
    public String getTokenValue() {
        return Secret.toString((Secret)this.token);
    }

    public long getMaxRetries() {
        return this.retriesOnError;
    }

    public String getMetaData(String keyName) {
        return this.metaDataProperties.getProperty(keyName);
    }

    public String getJsonUrl() {
        return this.jsonUrl;
    }

    public String getRawUrl() {
        return this.rawUrl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEventDisabled(EventType eventType) {
        return !this.isValid() || this.metaDataProperties == null || "false".equals(this.metaDataProperties.getProperty(eventType.getKey("enabled")));
    }

    public boolean isJobIgnored(String jobUrl) {
        boolean ignored = false;
        if (Constants.JOB_CONSOLE_FILTER_WHITELIST_PATTERN != null && !Constants.JOB_CONSOLE_FILTER_WHITELIST_PATTERN.matcher(jobUrl).find()) {
            LOG.log(Level.FINE, "{0} is not in whitelist set by splunkins.allowConsoleLogPattern", jobUrl);
            ignored = true;
        }
        if (!ignored && this.ignoredJobPattern != null) {
            ignored = this.ignoredJobPattern.matcher(jobUrl).find();
        }
        return ignored;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setToken(Secret token) {
        this.token = token;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public long getMaxEventsBatchSize() {
        return this.maxEventsBatchSize;
    }

    public void setMaxEventsBatchSize(long maxEventsBatchSize) {
        this.maxEventsBatchSize = maxEventsBatchSize > (long)Constants.MIN_BUFFER_SIZE ? maxEventsBatchSize : (long)Constants.MIN_BUFFER_SIZE;
    }

    public void setRawEventEnabled(boolean rawEventEnabled) {
        this.rawEventEnabled = rawEventEnabled;
    }

    public String getMetaDataConfig() {
        return this.metaDataConfig;
    }

    public void setMetaDataConfig(String metaDataConfig) {
        this.metaDataConfig = metaDataConfig;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public long getRetriesOnError() {
        return this.retriesOnError;
    }

    public void setRetriesOnError(long retriesOnError) {
        this.retriesOnError = retriesOnError;
    }

    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public String getScriptContent() {
        return this.scriptContent;
    }

    public void setScriptContent(String scriptContent) {
        this.scriptContent = scriptContent;
    }

    public Map toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("token", this.getTokenValue());
        map.put("rawEventEnabled", this.rawEventEnabled);
        map.put("maxEventsBatchSize", this.maxEventsBatchSize);
        map.put("host", this.host);
        map.put("port", this.port);
        map.put("useSSL", this.useSSL);
        map.put("metaDataConfig", Util.fixNull((String)this.defaultMetaData) + Util.fixNull((String)this.metaDataConfig));
        map.put("retriesOnError", this.retriesOnError);
        map.put("metadataHost", this.metadataHost);
        map.put("metadataSource", this.metadataSource);
        return map;
    }

    public String getScriptOrDefault() {
        if (this.scriptContent == null && this.scriptPath == null) {
            return LogEventHelper.getDefaultDslScript();
        }
        return this.scriptContent;
    }

    public String getSplunkAppUrl() {
        if (StringUtils.isEmpty((CharSequence)this.splunkAppUrl) && StringUtils.isNotEmpty((CharSequence)this.host)) {
            return "http://" + this.host + ":8000/en-US/app/splunk_app_jenkins/";
        }
        return this.splunkAppUrl;
    }

    public String getAppUrlOrHelp() {
        String url = this.getSplunkAppUrl();
        if (StringUtils.isEmpty((CharSequence)url)) {
            return "/plugin/splunk-devops/help-splunkAppUrl.html?";
        }
        return url;
    }

    public void setSplunkAppUrl(String splunkAppUrl) {
        if (!StringUtils.isEmpty((CharSequence)splunkAppUrl) && !((String)splunkAppUrl).endsWith("/")) {
            splunkAppUrl = (String)splunkAppUrl + "/";
        }
        this.splunkAppUrl = splunkAppUrl;
    }

    private String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "jenkins";
        }
    }

    public Set<MetaDataConfigItem> getMetadataItemSet() {
        return this.metadataItemSet;
    }

    public String getMetadataHost() {
        if (this.metadataHost != null) {
            return this.metadataHost;
        }
        if (this.metaDataProperties != null && this.metaDataProperties.containsKey("host")) {
            return this.metaDataProperties.getProperty("host");
        }
        String url = null;
        JenkinsLocationConfiguration jenkinsLocation = JenkinsLocationConfiguration.get();
        if (jenkinsLocation != null) {
            url = jenkinsLocation.getUrl();
        }
        if (url != null && !url.startsWith("http://localhost")) {
            try {
                return new URL(url).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.getLocalHostName();
    }

    public void setMetadataHost(String metadataHost) {
        this.metadataHost = metadataHost;
    }

    public void setMetadataItemSet(Set<MetaDataConfigItem> metadataItemSet) {
        this.metadataItemSet = metadataItemSet;
        this.metaDataConfig = MetaDataConfigItem.toString(metadataItemSet);
    }

    public String getMetadataSource() {
        if (this.metadataSource != null) {
            return this.metadataSource;
        }
        if (this.metaDataProperties != null && this.metaDataProperties.containsKey("source")) {
            return this.metaDataProperties.getProperty("source");
        }
        return "";
    }

    public String getMetadataSource(String suffix) {
        return this.getMetadataSource() + "/" + suffix;
    }

    public void setMetadataSource(String metadataSource) {
        this.metadataSource = metadataSource;
    }

    private void migrate() {
        String hash;
        if (this.scriptContent != null && Constants.SCRIPT_TEXT_MD5_HASH.contains((Object)(hash = DigestUtils.md5Hex((String)this.scriptContent)))) {
            this.scriptContent = LogEventHelper.getDefaultDslScript();
        }
        this.metadataItemSet = MetaDataConfigItem.loadProps(this.metaDataConfig);
        if (this.globalPipelineFilter == null) {
            this.globalPipelineFilter = true;
        }
    }

    public String getIgnoredJobs() {
        return this.ignoredJobs;
    }

    public void setIgnoredJobs(String ignoredJobs) {
        this.ignoredJobs = ignoredJobs;
    }

    public Boolean getGlobalPipelineFilter() {
        return this.globalPipelineFilter;
    }

    public void setGlobalPipelineFilter(Boolean globalPipelineFilter) {
        this.globalPipelineFilter = globalPipelineFilter;
    }

    public boolean isPipelineFilterEnabled() {
        return Boolean.TRUE.equals(this.globalPipelineFilter);
    }

    static {
        uuidPattern = Pattern.compile("[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}", 2);
    }
}

