/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.console;

import com.splunk.splunkjenkins.Constants;
import com.splunk.splunkjenkins.console.ConsoleRecordCacheUtils;
import com.splunk.splunkjenkins.console.PipelineConsoleDecoder;
import com.splunk.splunkjenkins.model.EventRecord;
import com.splunk.splunkjenkins.model.EventType;
import hudson.util.ByteArrayOutputStream2;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class LabelConsoleLineStream
extends FilterOutputStream {
    private static final int RECEIVE_BUFFER_SIZE = 512;
    private static final Logger LOGGER = Logger.getLogger(LabelConsoleLineStream.class.getName());
    public static final Pattern ANSI_COLOR_ESCAPE = Pattern.compile("\u001b\\[[\\d;]+m");
    private ByteArrayOutputStream2 branch = new ByteArrayOutputStream2(512);
    PipelineConsoleDecoder decoder;
    String source;

    public LabelConsoleLineStream(OutputStream out, String source, PipelineConsoleDecoder decoder) {
        super(out);
        this.decoder = decoder;
        this.source = source;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        if (b == 10) {
            this.eol();
        } else {
            this.branch.write(b);
        }
        if (this.branch.size() > Constants.CONSOLE_TEXT_SINGLE_LINE_MAX_LENGTH) {
            this.eol();
        }
    }

    protected void eol() {
        String line = this.decoder.decodeLine(this.branch.getBuffer(), this.branch.size());
        if (line == null) {
            return;
        }
        this.branch.reset();
        line = ANSI_COLOR_ESCAPE.matcher(line).replaceAll("");
        if (StringUtils.isNotBlank((CharSequence)line)) {
            EventRecord record = new EventRecord((Object)line, EventType.CONSOLE_LOG);
            record.setSource(this.source);
            ConsoleRecordCacheUtils.enqueue(record);
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        ConsoleRecordCacheUtils.flushLog();
        LOGGER.log(Level.FINE, "flush splunk log for " + this.source);
    }
}

