/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.console;

import com.splunk.splunkjenkins.console.SplunkConsoleTaskListenerDecorator;
import com.splunk.splunkjenkins.model.EventRecord;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.JenkinsJVM;

public class ConsoleRecordCacheUtils {
    private static final int CACHED_LINES_LIMIT;
    private static final transient Logger LOGGER;
    private static final transient ConcurrentLinkedQueue<EventRecord> consoleQueue;

    public static void enqueue(EventRecord record) {
        boolean added = consoleQueue.add(record);
        if (!added) {
            LOGGER.warning("failed to add log " + record.getMessageString());
        } else if (consoleQueue.size() > CACHED_LINES_LIMIT) {
            ConsoleRecordCacheUtils.flushLog();
        }
    }

    public static void flushLog() {
        ArrayList<EventRecord> pendingRecords = new ArrayList<EventRecord>();
        try {
            EventRecord record;
            while ((record = consoleQueue.poll()) != null) {
                pendingRecords.add(record);
            }
            SplunkLogService.getInstance().sendBatch(pendingRecords, EventType.CONSOLE_LOG);
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, "flush log error", ex);
        }
    }

    static {
        LOGGER = Logger.getLogger(SplunkConsoleTaskListenerDecorator.class.getName());
        consoleQueue = new ConcurrentLinkedQueue();
        CACHED_LINES_LIMIT = JenkinsJVM.isJenkinsJVM() ? 200 : 10;
    }
}

