/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.cloudbees.workflow.rest.external.ErrorExt;
import com.cloudbees.workflow.rest.external.FlowNodeExt;
import com.cloudbees.workflow.rest.external.StageNodeExt;
import com.cloudbees.workflow.rest.external.StatusExt;
import com.splunk.splunkjenkins.WorkspaceChunkVisitor;
import com.splunk.splunkjenkins.console.SplunkTaskListenerFactory;
import com.splunk.splunkjenkins.model.LoggingJobExtractor;
import hudson.Extension;
import hudson.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StageChunkFinder;

@Extension
public class PipelineRunSupport
extends LoggingJobExtractor<WorkflowRun> {
    private static final Logger LOG = Logger.getLogger(PipelineRunSupport.class.getName());

    public Map<String, Object> extract(WorkflowRun workflowRun, boolean jobCompleted) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (jobCompleted) {
            FlowExecution execution = workflowRun.getExecution();
            if (execution != null) {
                WorkspaceChunkVisitor visitor = new WorkspaceChunkVisitor(workflowRun);
                ForkScanner.visitSimpleChunks((Collection)execution.getCurrentHeads(), (SimpleChunkVisitor)visitor, (ChunkFinder)new StageChunkFinder());
                Collection stages = visitor.getStages();
                LOG.log(Level.FINE, "found stages count", stages.size());
                Map<String, String> execNodes = visitor.getWorkspaceNodes();
                if (!stages.isEmpty()) {
                    ArrayList<Map<String, Object>> labeledStages = new ArrayList<Map<String, Object>>(stages.size());
                    for (StageNodeExt stageNodeExt : stages) {
                        Map<String, Object> stage = this.flowNodeToMap((FlowNodeExt)stageNodeExt, execNodes);
                        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
                        for (FlowNodeExt childNode : stageNodeExt.getStageFlowNodes()) {
                            children.add(this.flowNodeToMap(childNode, execNodes));
                        }
                        if (!children.isEmpty()) {
                            stage.put("children", children);
                        }
                        labeledStages.add(stage);
                    }
                    info.put("stages", labeledStages);
                }
            }
            SplunkTaskListenerFactory.removeCache(workflowRun);
        }
        return info;
    }

    private Map<String, Object> flowNodeToMap(FlowNodeExt node, Map<String, String> execNodes) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ErrorExt error = node.getError();
        result.put("name", node.getName());
        result.put("id", node.getId());
        result.put("status", this.toResult(node.getStatus()));
        result.put("duration", Float.valueOf((float)node.getDurationMillis() / 1000.0f));
        result.put("pause_duration", Float.valueOf((float)node.getPauseDurationMillis() / 1000.0f));
        result.put("start_time", node.getStartTimeMillis() / 1000L);
        if (error != null) {
            result.put("error", error.getMessage());
            result.put("error_type", error.getType());
        }
        result.put("arguments", node.getParameterDescription());
        String execNodeName = node.getExecNode();
        if (StringUtils.isEmpty((CharSequence)execNodeName)) {
            execNodeName = execNodes.get(node.getId());
        }
        result.put("exec_node", execNodeName);
        return result;
    }

    private String toResult(StatusExt status) {
        if (status == null) {
            return "UNKNOWN";
        }
        switch (status) {
            case FAILED: {
                return Result.FAILURE.toString();
            }
            case NOT_EXECUTED: {
                return Result.NOT_BUILT.toString();
            }
        }
        return status.toString();
    }
}

