/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.persistence;

import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import hudson.model.Job;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;

public final class ChartConfigurationFileHandler {
    private static final String FILENAME = "chartConfiguration.properties";
    private final File m_directory;
    private final File m_chartConfiguration;

    public ChartConfigurationFileHandler(Job<?, ?> job) {
        this(job.getRootDir());
    }

    public ChartConfigurationFileHandler(File directory) {
        this.m_directory = directory;
        this.m_chartConfiguration = new File(this.m_directory, FILENAME);
        if (!this.m_chartConfiguration.exists()) {
            try {
                this.m_chartConfiguration.createNewFile();
            }
            catch (IOException ioe) {
                SonargraphLogger.INSTANCE.log(Level.SEVERE, "Failed to create chart configuration file: " + ioe.getMessage(), ioe);
            }
        }
    }

    public void store(ChartConfiguration config) {
        try (FileOutputStream os = new FileOutputStream(this.m_chartConfiguration);){
            Properties props = new Properties();
            props.put("core", String.valueOf(config.core));
            props.put("java", String.valueOf(config.java));
            props.put("cplusplus", String.valueOf(config.cplusplus));
            props.put("csharp", String.valueOf(config.csharp));
            props.put("python", String.valueOf(config.python));
            props.store(os, "Chart Configuration");
        }
        catch (IOException ex) {
            SonargraphLogger.INSTANCE.log(Level.WARNING, "Failed to store chart configuration: " + ex.getMessage(), ex);
        }
    }

    public ChartConfiguration load() {
        ChartConfiguration result = new ChartConfiguration();
        try (FileInputStream is = new FileInputStream(this.m_chartConfiguration);){
            Properties props = new Properties();
            props.load(is);
            result.core = Boolean.parseBoolean(props.getProperty("core", String.valueOf(result.core)));
            result.java = Boolean.parseBoolean(props.getProperty("java", String.valueOf(result.java)));
            result.cplusplus = Boolean.parseBoolean(props.getProperty("cplusplus", String.valueOf(result.cplusplus)));
            result.csharp = Boolean.parseBoolean(props.getProperty("csharp", String.valueOf(result.csharp)));
            result.python = Boolean.parseBoolean(props.getProperty("python", String.valueOf(result.python)));
        }
        catch (IOException ex) {
            SonargraphLogger.INSTANCE.log(Level.WARNING, "Failed to load chart configuration: " + ex.getMessage(), ex);
        }
        return result;
    }

    public static final class ChartConfiguration {
        public boolean core = true;
        public boolean java;
        public boolean cplusplus;
        public boolean csharp;
        public boolean python;
    }
}

