/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.persistence;

import com.hello2morrow.sonargraph.integration.access.model.IExportMetaData;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIds;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

public final class CSVColumnMapper {
    private final Set<String> m_columnNames = new LinkedHashSet<String>();

    public CSVColumnMapper(IExportMetaData metricMetaData, String ... existingColumnNames) {
        this(metricMetaData.getMetricIds().keySet(), existingColumnNames);
    }

    public CSVColumnMapper(MetricIds metricMetaData, String ... existingColumnNames) {
        this(metricMetaData.getMetricIds().keySet(), existingColumnNames);
    }

    private CSVColumnMapper(Set<String> metricIds, String ... existingColumnNames) {
        this.m_columnNames.add("buildnumber");
        this.m_columnNames.add("timestamp");
        for (String columnName : existingColumnNames) {
            this.m_columnNames.add(columnName);
        }
        this.m_columnNames.addAll(metricIds);
    }

    public int getIndex(String columnName) {
        if (!this.m_columnNames.contains(columnName)) {
            return -1;
        }
        ArrayList<String> list = new ArrayList<String>(this.m_columnNames);
        return list.indexOf(columnName);
    }

    public String[] getColumnNames(boolean metricOnly) {
        if (metricOnly) {
            return (String[])this.m_columnNames.stream().skip(2L).toArray(String[]::new);
        }
        return (String[])this.m_columnNames.stream().toArray(String[]::new);
    }
}

