/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.model;

import com.hello2morrow.sonargraph.integration.jenkins.model.IDataPoint;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class BuildDataPoint
implements IDataPoint {
    private final double m_value;
    private final int m_buildNumber;
    private final long m_timestamp;
    private static SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);

    public BuildDataPoint(int buildNumber, double value, long timeInMillis) {
        this.m_buildNumber = buildNumber;
        this.m_value = value;
        this.m_timestamp = timeInMillis;
    }

    @Override
    public int getX() {
        return this.m_buildNumber;
    }

    @Override
    public double getY() {
        return this.m_value;
    }

    public long getTimestamp() {
        return this.m_timestamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_buildNumber;
        result = 31 * result + (int)(this.m_timestamp ^ this.m_timestamp >>> 32);
        long temp = Double.doubleToLongBits(this.m_value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildDataPoint other = (BuildDataPoint)obj;
        if (this.m_buildNumber != other.m_buildNumber) {
            return false;
        }
        if (this.m_timestamp != other.m_timestamp) {
            return false;
        }
        return Double.doubleToLongBits(this.m_value) == Double.doubleToLongBits(other.m_value);
    }

    public String toString() {
        return "Build number: " + this.m_buildNumber + ", value: " + this.m_value + ", date/time: " + DATE_TIME_FORMAT.format(new Date(this.getTimestamp()));
    }
}

