/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.model;

import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.model.BuildDataPoint;
import com.hello2morrow.sonargraph.integration.jenkins.model.IDataPoint;
import com.hello2morrow.sonargraph.integration.jenkins.model.IMetricHistoryProvider;
import com.hello2morrow.sonargraph.integration.jenkins.model.InvalidDataPoint;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricId;
import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public abstract class AbstractPlot {
    private static final Color BACK_GROUND_COLOR = Color.WHITE;
    private static final Color GRID_LINE_COLOR = Color.BLACK;
    protected static final Paint DATA_COLOR = new Color(0, 179, 0);
    private double m_minimumValue = Double.MAX_VALUE;
    private double m_maximumValue = 0.0;
    private int m_datasetSize = 0;
    private long m_timestampOfLastDisplayedPoint = -1L;
    protected IMetricHistoryProvider m_datasetProvider;

    public AbstractPlot(IMetricHistoryProvider datasetProvider) {
        assert (datasetProvider != null) : "Parameter 'datasetProvider' of method 'DiscreteLinePlot' must not be null";
        this.m_datasetProvider = datasetProvider;
    }

    public final JFreeChart createXYChart(MetricId metric, String categoryName, int maximumNumberOfDataPoints, boolean hideLegend) {
        XYDataset dataset = null;
        try {
            dataset = this.createXYDataset(metric, maximumNumberOfDataPoints);
        }
        catch (IOException ioe) {
            SonargraphLogger.INSTANCE.log(Level.SEVERE, "Failed to read metrics from data file '" + this.m_datasetProvider.getStorageName() + "'", ioe);
        }
        JFreeChart chart = this.createChartInternal(metric.getName(), categoryName, metric.getName(), dataset);
        XYPlot plot = (XYPlot)chart.getPlot();
        int dataPoints = 0;
        if (dataset == null) {
            plot.setNoDataMessage("There was an error loading data for metric '" + metric.getName() + "'");
        } else {
            for (int i = 0; i < dataset.getSeriesCount(); ++i) {
                dataPoints += dataset.getItemCount(i);
            }
            if (dataPoints == 0) {
                plot.setNoDataMessage("No data found for metric '" + metric.getName() + "'");
            }
        }
        if (dataset == null || dataPoints == 0) {
            plot.setNoDataMessagePaint((Paint)Color.RED);
            plot.setDomainGridlinesVisible(false);
            plot.setRangeGridlinesVisible(false);
        }
        this.applyRendering(plot);
        this.setRangeAxis(!metric.isFloat(), plot);
        this.applyStandardPlotColors(plot);
        if (hideLegend) {
            chart.removeLegend();
        }
        return chart;
    }

    protected XYDataset createXYDataset(MetricId metric, int maximumNumberOfDataPoints) throws IOException {
        XYSeries xySeries = new XYSeries((Comparable)((Object)metric.getName()));
        List<IDataPoint> dataset = this.m_datasetProvider.readMetricValues(metric);
        int size = dataset.size();
        SonargraphLogger.INSTANCE.fine(size + " data points found for metric '" + metric.getName() + "' in file '" + this.m_datasetProvider.getStorageName() + "'");
        int maxSize = 0;
        if (maximumNumberOfDataPoints > 0) {
            maxSize = maximumNumberOfDataPoints;
        }
        if (maxSize != 0 && size > maxSize) {
            dataset = dataset.subList(size - maxSize, size);
        }
        BuildDataPoint point = null;
        for (IDataPoint datapoint : dataset) {
            if (datapoint instanceof InvalidDataPoint || !(datapoint instanceof BuildDataPoint)) continue;
            point = (BuildDataPoint)datapoint;
            xySeries.add((double)point.getX(), point.getY());
            this.checkMinMaxYValue(point.getY());
        }
        if (point != null) {
            this.setTimestampOfLastDisplayedPoint(point.getTimestamp());
        }
        this.setDataSetSize(xySeries.getItemCount());
        return new XYSeriesCollection(xySeries);
    }

    protected abstract JFreeChart createChartInternal(String var1, String var2, String var3, XYDataset var4);

    protected abstract void applyRendering(XYPlot var1);

    protected void setDataSetSize(int itemCount) {
        this.m_datasetSize = itemCount;
    }

    protected void checkMinMaxYValue(double value) {
        if (this.m_minimumValue > value) {
            this.m_minimumValue = value;
        }
        if (this.m_maximumValue < value) {
            this.m_maximumValue = value;
        }
    }

    protected double getMinimumValue() {
        return this.m_minimumValue;
    }

    protected double getMaximumValue() {
        return this.m_maximumValue;
    }

    protected void setMinimumValue(double minimumValue) {
        this.m_minimumValue = minimumValue;
    }

    protected void setMaximumValue(double maximumValue) {
        this.m_maximumValue = maximumValue;
    }

    public long getTimestampOfLastDisplayedPoint() {
        return this.m_timestampOfLastDisplayedPoint;
    }

    protected void setTimestampOfLastDisplayedPoint(long timestamp) {
        this.m_timestampOfLastDisplayedPoint = timestamp;
    }

    protected void setRangeAxis(boolean hideDecimals, XYPlot plot) {
        if (hideDecimals) {
            plot.getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        }
        if (this.getDatasetSize() == 0) {
            plot.getRangeAxis().setRange(0.0, 1.0);
        } else {
            plot.getRangeAxis().setRange(this.getMinimumValue() - 1.0, this.getMaximumValue() + 1.0);
        }
    }

    private void applyStandardPlotColors(XYPlot plot) {
        plot.setBackgroundPaint((Paint)BACK_GROUND_COLOR);
        plot.setRangeGridlinePaint((Paint)GRID_LINE_COLOR);
    }

    protected int getDatasetSize() {
        return this.m_datasetSize;
    }
}

