/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.access.foundation.ResultWithOutcome;
import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.controller.MetricIdProvider;
import com.hello2morrow.sonargraph.integration.jenkins.controller.Plotter;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.ChartConfigurationFileHandler;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricId;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIds;
import hudson.model.Action;
import hudson.model.Job;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class PipelineChartAction
implements Action {
    private final Job<?, ?> job;
    private final MetricIds metaData;
    private final ChartConfigurationFileHandler.ChartConfiguration chartConfiguration;
    private final ChartConfigurationFileHandler chartConfigurationFileHandler;
    private static final Map<Job<?, ?>, PipelineChartAction> s_instances = new HashMap();

    public static PipelineChartAction getInstance(Job<?, ?> job) {
        if (s_instances.get(job) == null) {
            s_instances.put(job, new PipelineChartAction(job));
        }
        return s_instances.get(job);
    }

    private PipelineChartAction(Job<?, ?> job) {
        this.job = job;
        ResultWithOutcome<MetricIds> metricIds = MetricIdProvider.getMetricIds(job);
        this.metaData = (MetricIds)metricIds.getOutcome();
        this.chartConfigurationFileHandler = new ChartConfigurationFileHandler(job);
        this.chartConfiguration = this.chartConfigurationFileHandler.load();
    }

    public boolean isCore() {
        return this.chartConfiguration.core;
    }

    public boolean isJava() {
        return this.chartConfiguration.java;
    }

    public boolean isCplusplus() {
        return this.chartConfiguration.cplusplus;
    }

    public boolean isCsharp() {
        return this.chartConfiguration.csharp;
    }

    public boolean isPython() {
        return this.chartConfiguration.python;
    }

    public void doSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        JSONObject json = req.getSubmittedForm();
        this.chartConfiguration.core = json.getBoolean("core");
        this.chartConfiguration.java = json.getBoolean("java");
        this.chartConfiguration.cplusplus = json.getBoolean("cplusplus");
        this.chartConfiguration.csharp = json.getBoolean("csharp");
        this.chartConfiguration.python = json.getBoolean("python");
        this.chartConfigurationFileHandler.store(this.chartConfiguration);
        rsp.forwardToPreviousPage(req);
    }

    public Collection<String> getChartsForMetrics() {
        ArrayList<String> chartsForMetrics = new ArrayList<String>();
        for (String next : this.metaData.getMetricIds().keySet()) {
            MetricId nextMetric = this.metaData.getMetricIds().get(next);
            String nextProviderId = nextMetric.getProviderId();
            if (!(nextProviderId.equals("Core") && this.chartConfiguration.core || nextProviderId.startsWith("Java") && this.chartConfiguration.java || nextProviderId.startsWith("CSharp") && this.chartConfiguration.csharp || nextProviderId.startsWith("CPlusPlus") && this.chartConfiguration.cplusplus || nextProviderId.startsWith("Python") && this.chartConfiguration.python) && !nextProviderId.startsWith("./")) continue;
            chartsForMetrics.add(next);
        }
        return chartsForMetrics;
    }

    public void doGetPlot(StaplerRequest2 req, StaplerResponse2 rsp) {
        Plotter.doGetPlot(this.job, this.metaData, req, rsp);
    }

    public Job<?, ?> getJob() {
        return this.job;
    }

    public String getIconFileName() {
        return ConfigParameters.SONARGRAPH_ICON.getValue();
    }

    public String getDisplayName() {
        return ConfigParameters.ACTION_DISPLAY_CHART.getValue();
    }

    public String getUrlName() {
        return ConfigParameters.ACTION_URL_PIPELINE_CHART.getValue();
    }
}

