/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.access.model.Severity;
import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.controller.SonargraphBuildAnalyzer;
import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.PluginVersionReader;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.ReportHistoryFileManager;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractSonargraphRecorder
extends Recorder {
    private static final String DEFAULT_ACTION = "nothing";
    private String architectureViolationsAction = "nothing";
    private String unassignedTypesAction = "nothing";
    private String cyclicElementsAction = "nothing";
    private String thresholdViolationsAction = "nothing";
    private String architectureWarningsAction = "nothing";
    private String workspaceWarningsAction = "nothing";
    private String workItemsAction = "nothing";
    private String emptyWorkspaceAction = "nothing";
    private String qualityGateAction = "nothing";

    public String getArchitectureViolationsAction() {
        return this.architectureViolationsAction;
    }

    public String getUnassignedTypesAction() {
        return this.unassignedTypesAction;
    }

    public String getCyclicElementsAction() {
        return this.cyclicElementsAction;
    }

    public String getThresholdViolationsAction() {
        return this.thresholdViolationsAction;
    }

    public String getArchitectureWarningsAction() {
        return this.architectureWarningsAction;
    }

    public String getWorkspaceWarningsAction() {
        return this.workspaceWarningsAction;
    }

    public String getWorkItemsAction() {
        return this.workItemsAction;
    }

    public String getEmptyWorkspaceAction() {
        return this.emptyWorkspaceAction;
    }

    public String getQualityGateAction() {
        return this.qualityGateAction;
    }

    @DataBoundSetter
    public void setArchitectureViolationsAction(String architectureViolationsAction) {
        this.architectureViolationsAction = architectureViolationsAction;
    }

    @DataBoundSetter
    public void setUnassignedTypesAction(String unassignedTypesAction) {
        this.unassignedTypesAction = unassignedTypesAction;
    }

    @DataBoundSetter
    public void setCyclicElementsAction(String cyclicElementsAction) {
        this.cyclicElementsAction = cyclicElementsAction;
    }

    @DataBoundSetter
    public void setThresholdViolationsAction(String thresholdViolationsAction) {
        this.thresholdViolationsAction = thresholdViolationsAction;
    }

    @DataBoundSetter
    public void setArchitectureWarningsAction(String architectureWarningsAction) {
        this.architectureWarningsAction = architectureWarningsAction;
    }

    @DataBoundSetter
    public void setWorkspaceWarningsAction(String workspaceWarningsAction) {
        this.workspaceWarningsAction = workspaceWarningsAction;
    }

    @DataBoundSetter
    public void setWorkItemsAction(String workItemsAction) {
        this.workItemsAction = workItemsAction;
    }

    @DataBoundSetter
    public void setEmptyWorkspaceAction(String emptyWorkspaceAction) {
        this.emptyWorkspaceAction = emptyWorkspaceAction;
    }

    @DataBoundSetter
    public void setQualityGateAction(String qualityGateAction) {
        this.qualityGateAction = qualityGateAction;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    protected final boolean processSonargraphReport(Run<?, ?> run, FilePath sonargraphReportDirectory, String reportFileName, PrintStream logger) throws IOException, InterruptedException {
        assert (run != null) : "Parameter 'run' of method 'processSonargraphReport' must not be null";
        assert (sonargraphReportDirectory != null) : "Parameter 'sonargraphReportDirectory' of method 'processSonargraphReport' must not be null";
        FilePath projectRootDir = new FilePath(run.getParent().getRootDir());
        ReportHistoryFileManager reportHistoryManager = new ReportHistoryFileManager(projectRootDir, ConfigParameters.REPORT_HISTORY_FOLDER.getValue(), ConfigParameters.SONARGRAPH_REPORT_FILE_NAME.getValue(), logger);
        FilePath reportFile = null;
        try {
            reportFile = reportHistoryManager.storeGeneratedReportDirectory(sonargraphReportDirectory, reportFileName, run.getNumber(), logger);
        }
        catch (IOException ex) {
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Failed to process the generated Sonargraph report", ex);
            return false;
        }
        if (reportFile == null || !reportFile.exists() || reportFile.isRemote() || reportFile.isDirectory()) {
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Sonargraph analysis cannot be executed as Sonargraph report does not exist.", null);
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Report file \"" + String.valueOf(reportFile) + "\" does not exist.", null);
            run.setResult(Result.FAILURE);
            return false;
        }
        SonargraphBuildAnalyzer sonargraphBuildAnalyzer = new SonargraphBuildAnalyzer(reportFile, logger);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("ArchitectureViolation", Severity.NONE, this.architectureViolationsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfMetricValueNotZero("CoreUnassignedComponents", this.unassignedTypesAction);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("CycleGroup", Severity.ERROR, this.cyclicElementsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("ThresholdViolation", Severity.ERROR, this.thresholdViolationsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("ArchitectureConsistency", Severity.NONE, this.architectureWarningsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("Workspace", Severity.NONE, this.workspaceWarningsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("Todo", Severity.NONE, this.workItemsAction);
        sonargraphBuildAnalyzer.changeBuildResultIfMetricValueIsZero("CoreComponents", this.emptyWorkspaceAction);
        sonargraphBuildAnalyzer.changeBuildResultIfIssuesExist("QualityGate", Severity.NONE, this.qualityGateAction);
        Result buildResult = sonargraphBuildAnalyzer.getOverallBuildResult();
        File metricHistoryFile = new File(run.getParent().getRootDir(), ConfigParameters.METRIC_HISTORY_CSV_FILE_PATH.getValue());
        File metricIdsHistoryFile = new File(run.getParent().getRootDir(), ConfigParameters.METRICIDS_HISTORY_JSON_FILE_PATH.getValue());
        try {
            sonargraphBuildAnalyzer.saveMetrics(metricHistoryFile, metricIdsHistoryFile, run.getTimestamp().getTimeInMillis(), run.getNumber());
        }
        catch (IOException ex) {
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Failed to save Sonargraph metrics to CSV data file", ex);
            return false;
        }
        if (buildResult != null) {
            SonargraphLogger.logToConsoleOutput(logger, Level.INFO, "Sonargraph analysis has set the final build result to '" + buildResult.toString() + "'", null);
            run.setResult(buildResult);
        }
        return true;
    }

    protected void logExecutionStart(AbstractBuild<?, ?> build, TaskListener listener, Class<? extends AbstractSonargraphRecorder> recorderClazz) {
        SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Sonargraph Jenkins Plugin, Version '" + PluginVersionReader.INSTANCE.getVersion() + "', post-build step '" + recorderClazz.getName() + "'\nStart structural analysis on project '" + build.getProject().getDisplayName() + "', build number '" + build.getNumber() + "'", null);
    }

    protected void logExecutionStart(Run<?, ?> run, TaskListener listener, Class<? extends AbstractSonargraphRecorder> recorderClazz) {
        SonargraphLogger.logToConsoleOutput(listener.getLogger(), Level.INFO, "Sonargraph Jenkins Plugin, Version '" + PluginVersionReader.INSTANCE.getVersion() + "', post-build step '" + recorderClazz.getName() + "'\nStart structural analysis on project '" + run.getParent().getDisplayName() + "', build number '" + run.getNumber() + "'", null);
    }
}

