/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlElementContentExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlElementContentExtractor.class);
    private static SAXParserFactory s_factory;
    private static SAXParser s_saxParser;
    private static DefaultHandler s_processor;

    private XmlElementContentExtractor() {
    }

    public static String process(File file, String elementName) {
        block14: {
            String string;
            assert (file != null) : "Parameter 'file' of method 'process' must not be null";
            assert (elementName != null && elementName.length() > 0) : "Parameter 'elementName' of method 'process' must not be empty";
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                XmlElementContentExtractor.extractElementValue(elementName, is);
                string = "";
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ElementProcessedException ex) {
                    return ex.getElementContent();
                }
                catch (SAXParseException ex) {
                    break block14;
                }
                catch (ParserConfigurationException ex) {
                    LOGGER.error("Fatal configuration exception", (Throwable)ex);
                    break block14;
                }
                catch (SAXException ex) {
                    LOGGER.error("Generic SAXException while processing " + file.getAbsolutePath(), (Throwable)ex);
                    break block14;
                }
                catch (FileNotFoundException ex) {
                    break block14;
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to determine root element of " + file.getAbsolutePath(), (Throwable)ex);
                }
            }
            ((InputStream)is).close();
            return string;
        }
        return null;
    }

    public static String process(InputStream in, String elementName) {
        assert (in != null) : "Parameter 'in' of method 'process' must not be null";
        assert (elementName != null && elementName.length() > 0) : "Parameter 'elementName' of method 'process' must not be empty";
        try {
            XmlElementContentExtractor.extractElementValue(elementName, in);
            return "";
        }
        catch (ElementProcessedException ex) {
            return ex.getElementContent();
        }
        catch (SAXParseException ex) {
        }
        catch (ParserConfigurationException ex) {
            LOGGER.error("Fatal configuration exception", (Throwable)ex);
        }
        catch (SAXException ex) {
            LOGGER.error("Generic SAXException", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to value for element '" + elementName + "'", (Throwable)ex);
        }
        return null;
    }

    private static void extractElementValue(final String elementName, InputStream is) throws ParserConfigurationException, SAXException, IOException {
        if (s_factory == null) {
            s_factory = SAXParserFactory.newInstance();
        }
        if (s_saxParser == null) {
            s_saxParser = s_factory.newSAXParser();
        }
        if (s_processor == null) {
            s_processor = new DefaultHandler(){
                private StringBuilder m_content;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equals(elementName)) {
                        this.m_content = new StringBuilder();
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (qName.equals(elementName)) {
                        throw new ElementProcessedException(this.m_content.toString());
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.m_content != null) {
                        this.m_content.append(ch, start, length);
                    }
                }
            };
        }
        s_saxParser.parse(is, s_processor);
    }

    private static class ElementProcessedException
    extends SAXException {
        private static final long serialVersionUID = 2126363921505871938L;
        private final String attributeValue;

        public ElementProcessedException(String attributeValue) {
            super("");
            this.attributeValue = attributeValue;
        }

        public String getElementContent() {
            return this.attributeValue;
        }
    }
}

