/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import com.hello2morrow.sonargraph.integration.access.foundation.MigrationCheck;
import com.hello2morrow.sonargraph.integration.access.foundation.Result;
import com.hello2morrow.sonargraph.integration.access.foundation.Utility;
import com.hello2morrow.sonargraph.integration.access.foundation.Version;
import com.hello2morrow.sonargraph.integration.access.model.DependencyPatternType;
import com.hello2morrow.sonargraph.integration.access.model.ElementPatternType;
import com.hello2morrow.sonargraph.integration.access.model.IDependencyPattern;
import com.hello2morrow.sonargraph.integration.access.model.IElementPattern;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IMatching;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.Priority;
import com.hello2morrow.sonargraph.integration.access.model.RefactoringStatus;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import com.hello2morrow.sonargraph.integration.access.model.internal.DeleteRefactoringImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.DependencyPatternImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementPatternImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.FixResolutionImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.IgnoreResolutionImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.IssueImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.MatchingImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.MoveRefactoringImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.MoveRenameRefactoringImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.ProgrammingElementImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.RenameRefactoringImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.ResolutionImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.SoftwareSystemImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.ToDoResolutionImpl;
import com.hello2morrow.sonargraph.integration.access.persistence.ResolutionMigration;
import com.hello2morrow.sonargraph.integration.access.persistence.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDeleteRefactoring;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDependencyPattern;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDependencyPatternType;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElementPattern;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElementPatternType;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdFixMe;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIgnore;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssue;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMatching;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMoveRefactoring;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMoveRenameRefactoring;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdRefactoring;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdRenameRefactoring;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdResolution;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdSoftwareSystemReport;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdToDo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolutionConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolutionConverter.class);
    private final SoftwareSystemImpl softwareSystem;
    private final XsdSoftwareSystemReport report;
    private final Map<Object, IssueImpl> globalXmlIdToIssueMap;

    public ResolutionConverter(SoftwareSystemImpl softwareSystem, XsdSoftwareSystemReport report, Map<Object, IssueImpl> globalXmlIdToIssueMap) {
        this.softwareSystem = softwareSystem;
        this.report = report;
        this.globalXmlIdToIssueMap = globalXmlIdToIssueMap;
    }

    public void convert(Result result) {
        if (this.report.getResolutions() == null) {
            return;
        }
        boolean isPatternMigrationNeeded = ResolutionMigration.isPatternMigrationNeeded(Version.fromString(this.report.getVersion()));
        HashSet<INamedElement> elementsNeedingMigration = new HashSet<INamedElement>();
        for (XsdResolution nextXsdResolution : this.report.getResolutions().getResolution()) {
            ElementImpl resolutionToAdd;
            Priority priority;
            ResolutionType type;
            if (nextXsdResolution.isRefactoring()) {
                type = ResolutionType.REFACTORING;
            } else {
                try {
                    type = ResolutionType.valueOf(nextXsdResolution.getType().toUpperCase());
                }
                catch (Exception e2) {
                    LOGGER.error("Failed to process resolution type '" + nextXsdResolution.getType() + "'", (Throwable)e2);
                    result.addError((Result.ICause)ValidationEventHandlerImpl.ValidationMessageCauses.NOT_SUPPORTED_ENUM_CONSTANT, "Resolution type '" + nextXsdResolution.getType() + "' is not supported and will be ignored.", new Object[0]);
                    continue;
                }
            }
            try {
                priority = Priority.valueOf(Utility.convertStandardNameToConstantName(nextXsdResolution.getPrio()));
            }
            catch (Exception e3) {
                LOGGER.error("Failed to process priority type '" + nextXsdResolution.getPrio() + "'", (Throwable)e3);
                result.addWarning(ValidationEventHandlerImpl.ValidationMessageCauses.NOT_SUPPORTED_ENUM_CONSTANT, "Priority type '" + nextXsdResolution.getPrio() + "' is not supported, setting to '" + String.valueOf(Priority.NONE) + "'", new Object[0]);
                priority = Priority.NONE;
            }
            ArrayList<IIssue> issues = new ArrayList<IIssue>();
            for (Object nextXsdIssue : nextXsdResolution.getIssueIds()) {
                XsdIssue xsdIssue = (XsdIssue)nextXsdIssue;
                IssueImpl nextIssueImpl = this.globalXmlIdToIssueMap.get(xsdIssue);
                assert (nextIssueImpl != null) : "No issue with id '" + xsdIssue.getId() + "' exists";
                nextIssueImpl.setResolutionType(type);
                issues.add(nextIssueImpl);
            }
            List<IElementPattern> elementPatterns = this.createElementPatterns(result, nextXsdResolution);
            List<IDependencyPattern> dependencyPatterns = this.createDependencyPatterns(result, nextXsdResolution, type);
            IMatching matching = this.createMatching(result, nextXsdResolution);
            Integer matchingElementsCount = nextXsdResolution.getMatchingElementsCount();
            String fqName = nextXsdResolution.getFqName();
            String description = nextXsdResolution.getDescription();
            String information = nextXsdResolution.getInformation();
            String assignee = nextXsdResolution.getAssignee();
            Date dateTime = nextXsdResolution.getDate().toGregorianCalendar().getTime();
            String descriptor = MigrationCheck.isPreUnificationOfIssueIds(this.softwareSystem.getVersion()) ? (nextXsdResolution.getDescriptor() != null ? this.convertDeprecatedDescriptor(nextXsdResolution.getDescriptor()) : null) : nextXsdResolution.getDescriptor();
            if (nextXsdResolution instanceof XsdIgnore) {
                resolutionToAdd = new IgnoreResolutionImpl(fqName, priority, issues, matchingElementsCount, description, information, assignee, dateTime, elementPatterns, dependencyPatterns, matching, descriptor);
            } else if (nextXsdResolution instanceof XsdToDo) {
                resolutionToAdd = new ToDoResolutionImpl(fqName, priority, issues, matchingElementsCount, description, information, assignee, dateTime, elementPatterns, dependencyPatterns, matching, descriptor);
            } else if (nextXsdResolution instanceof XsdFixMe) {
                resolutionToAdd = new FixResolutionImpl(fqName, priority, issues, matchingElementsCount, description, information, assignee, dateTime, elementPatterns, dependencyPatterns, matching, descriptor);
            } else if (nextXsdResolution instanceof XsdRefactoring) {
                String elementKind;
                String moveToParentName;
                String targetRootDirectoryFqName;
                XsdRefactoring xsdRefactoring = (XsdRefactoring)nextXsdResolution;
                int potentiallyDoneElementCount = xsdRefactoring.getNumberOfPotentiallyDoneElements();
                RefactoringStatus status = RefactoringStatus.createFromStandardName(xsdRefactoring.getStatus());
                if (nextXsdResolution instanceof XsdDeleteRefactoring) {
                    int numberOfAffectedParserDependencies = ((XsdDeleteRefactoring)nextXsdResolution).getNumberOfAffectedParserDependencies();
                    resolutionToAdd = new DeleteRefactoringImpl(fqName, priority, issues, matchingElementsCount, numberOfAffectedParserDependencies, description, information, assignee, dateTime, elementPatterns, dependencyPatterns, matching, descriptor, status, potentiallyDoneElementCount);
                } else if (nextXsdResolution instanceof XsdRenameRefactoring) {
                    String newName = ((XsdRenameRefactoring)nextXsdResolution).getNewName();
                    resolutionToAdd = new RenameRefactoringImpl(fqName, priority, issues, matchingElementsCount, description, information, assignee, dateTime, elementPatterns, dependencyPatterns, matching, descriptor, status, potentiallyDoneElementCount, newName);
                } else if (nextXsdResolution instanceof XsdMoveRenameRefactoring) {
                    XsdMoveRenameRefactoring xsdMoveRename = (XsdMoveRenameRefactoring)nextXsdResolution;
                    targetRootDirectoryFqName = xsdMoveRename.getTargetRootDirectoryFqName();
                    moveToParentName = xsdMoveRename.getMoveToParentName();
                    elementKind = xsdMoveRename.getElementKind();
                    String newName = xsdMoveRename.getNewName();
                    resolutionToAdd = new MoveRenameRefactoringImpl(fqName, priority, issues, matchingElementsCount, description, information, assignee, dateTime, elementPatterns, dependencyPatterns, matching, descriptor, status, potentiallyDoneElementCount, targetRootDirectoryFqName, moveToParentName, elementKind, newName);
                } else if (nextXsdResolution instanceof XsdMoveRefactoring) {
                    XsdMoveRefactoring xsdMove = (XsdMoveRefactoring)nextXsdResolution;
                    targetRootDirectoryFqName = xsdMove.getTargetRootDirectoryFqName();
                    moveToParentName = xsdMove.getMoveToParentName();
                    elementKind = xsdMove.getElementKind();
                    resolutionToAdd = new MoveRefactoringImpl(fqName, priority, issues, matchingElementsCount, description, information, assignee, dateTime, elementPatterns, dependencyPatterns, matching, descriptor, status, potentiallyDoneElementCount, targetRootDirectoryFqName, moveToParentName, elementKind);
                } else {
                    assert (false) : "Unsupported refactoring " + fqName + ", descriptor: " + descriptor;
                    resolutionToAdd = null;
                }
            } else {
                resolutionToAdd = new ResolutionImpl(fqName, type, priority, issues, matchingElementsCount, nextXsdResolution.isApplicable(), nextXsdResolution.getNumberOfAffectedParserDependencies(), description, information, assignee, dateTime, elementPatterns, dependencyPatterns, matching, descriptor);
            }
            if (isPatternMigrationNeeded) {
                this.softwareSystem.addResolution(ResolutionMigration.migrate(resolutionToAdd, elementsNeedingMigration));
                continue;
            }
            this.softwareSystem.addResolution((IResolution)((Object)resolutionToAdd));
        }
        Set<ProgrammingElementImpl> fieldsToUpdate = elementsNeedingMigration.stream().filter(e -> e instanceof ProgrammingElementImpl).map(e -> (ProgrammingElementImpl)e).collect(Collectors.toSet());
        this.updateFields(fieldsToUpdate);
    }

    private void updateFields(Set<ProgrammingElementImpl> fields) {
        for (ProgrammingElementImpl next : fields) {
            assert (!next.getFqName().endsWith("|f")) : "Already migrated: " + next.getFqName();
            next.updateFqName(next.getFqName() + "|f");
        }
    }

    private String convertDeprecatedDescriptor(String descriptor) {
        assert (descriptor != null) : "Parameter 'descriptor' of method 'convertDeprecatedDescriptor' must not be null";
        if (descriptor.equals("ComponentCycleGroup") || descriptor.equals("NamespaceCycleGroup") || descriptor.equals("DirectoryCycleGroup") || descriptor.equals("ModuleCycleGroup")) {
            return "";
        }
        String search = "(ThresholdViolation)Error(:.*)";
        String replace = "$1$2";
        String result = descriptor.replaceFirst("(ThresholdViolation)Error(:.*)", "$1$2");
        return result;
    }

    private IMatching createMatching(Result result, XsdResolution xsdResolution) {
        MatchingImpl matching;
        XsdMatching xsdMatching = xsdResolution.getMatching();
        if (xsdMatching != null) {
            String matchingInfo = xsdMatching.getInfo();
            if (matchingInfo != null && !matchingInfo.isEmpty()) {
                ArrayList<IElementPattern> matchingPatterns = new ArrayList<IElementPattern>();
                for (XsdElementPattern nextXsdElementPattern : xsdMatching.getElementPattern()) {
                    XsdElementPatternType nextXsdElementPatternType = nextXsdElementPattern.getType();
                    if (nextXsdElementPatternType != null && nextXsdElementPatternType == XsdElementPatternType.FULLY_QUALIFIED_NAME) {
                        String pattern = nextXsdElementPattern.getValue();
                        if (pattern == null || pattern.isEmpty()) {
                            result.addWarning(ValidationEventHandlerImpl.ValidationMessageCauses.XML_VALIDATION_WARNING, "Empty matching pattern", new Object[0]);
                            break;
                        }
                        String hash = nextXsdElementPattern.getHash();
                        if (hash != null && hash.trim().length() > 0) {
                            matchingPatterns.add(new ElementPatternImpl(ElementPatternType.FULLY_QUALIFIED_NAME, pattern, hash));
                            continue;
                        }
                        matchingPatterns.add(new ElementPatternImpl(ElementPatternType.FULLY_QUALIFIED_NAME, pattern));
                        continue;
                    }
                    result.addWarning(ValidationEventHandlerImpl.ValidationMessageCauses.XML_VALIDATION_WARNING, "Unspported pattern type: " + String.valueOf((Object)nextXsdElementPatternType), new Object[0]);
                }
                matching = new MatchingImpl(matchingInfo, matchingPatterns);
            } else {
                result.addWarning(ValidationEventHandlerImpl.ValidationMessageCauses.XML_VALIDATION_WARNING, "Empty matching info", new Object[0]);
                matching = null;
            }
        } else {
            matching = null;
        }
        return matching;
    }

    public List<IDependencyPattern> createDependencyPatterns(Result result, XsdResolution nextResolution, ResolutionType type) {
        ArrayList<IDependencyPattern> dependencyPatterns = new ArrayList<IDependencyPattern>();
        for (XsdDependencyPattern xsdDependency : nextResolution.getDependencyPattern()) {
            DependencyPatternImpl dependencyPattern;
            XsdDependencyPatternType xsdPatternType = xsdDependency.getType();
            String fromPattern = xsdDependency.getFrom();
            String toPattern = xsdDependency.getTo();
            if (fromPattern == null || fromPattern.isEmpty()) {
                result.addError((Result.ICause)ValidationEventHandlerImpl.ValidationMessageCauses.XML_VALIDATION_WARNING, "From pattern is empty.", new Object[0]);
                continue;
            }
            if (toPattern == null || toPattern.isEmpty()) {
                result.addError((Result.ICause)ValidationEventHandlerImpl.ValidationMessageCauses.XML_VALIDATION_WARNING, "To pattern is empty.", new Object[0]);
                continue;
            }
            if (xsdPatternType == null || xsdPatternType == XsdDependencyPatternType.WILDCARD) {
                dependencyPattern = new DependencyPatternImpl(DependencyPatternType.WILDCARD, fromPattern, toPattern);
            } else {
                assert (xsdPatternType == XsdDependencyPatternType.PARSER_DEPENDENCY_ENDPOINT) : "Unexpected type: " + String.valueOf(type);
                dependencyPattern = new DependencyPatternImpl(DependencyPatternType.PARSER_DEPENDENCY_ENDPOINT, fromPattern, toPattern);
            }
            dependencyPatterns.add(dependencyPattern);
        }
        return dependencyPatterns;
    }

    public List<IElementPattern> createElementPatterns(Result result, XsdResolution nextResolution) {
        ArrayList<IElementPattern> elementPatterns = new ArrayList<IElementPattern>();
        for (XsdElementPattern nextXsdElementPattern : nextResolution.getElementPattern()) {
            XsdElementPatternType xsdPatternType = nextXsdElementPattern.getType();
            ElementPatternType patternType = ElementPatternType.valueOf(xsdPatternType.name());
            String pattern = nextXsdElementPattern.getValue();
            if (pattern == null || pattern.isEmpty()) {
                result.addError((Result.ICause)ValidationEventHandlerImpl.ValidationMessageCauses.XML_VALIDATION_WARNING, "Pattern of resolution is empty.", new Object[0]);
                continue;
            }
            ElementPatternImpl elementPattern = new ElementPatternImpl(patternType, pattern);
            elementPatterns.add(elementPattern);
        }
        return elementPatterns;
    }
}

