/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.persistence;

import com.hello2morrow.sonargraph.integration.access.model.IElement;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionMode;
import com.hello2morrow.sonargraph.integration.access.model.Severity;
import com.hello2morrow.sonargraph.integration.access.model.SystemFileType;
import com.hello2morrow.sonargraph.integration.access.model.internal.SoftwareSystemImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.qualitygate.CurrentSystemConditionsImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.qualitygate.DiffAgainstBaselineConditionsImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.qualitygate.QualityGateExcludeFilterImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.qualitygate.QualityGateImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.qualitygate.QualityGateIssueConditionImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.qualitygate.QualityGateIssueDiffConditionImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.qualitygate.QualityGateMetricValueDiffConditionImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.qualitygate.QualityGateThresholdIssueConditionImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.qualitygate.QualityGateThresholdIssueDiffConditionImpl;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.Check;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.Operator;
import com.hello2morrow.sonargraph.integration.access.model.qualitygate.Status;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlReportReaderUtils;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdCheck;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdCurrentSystemConditions;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdDiffAgainstBaselineConditions;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdElementKind;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdExcludeFilter;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssueCondition;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdIssueDiffCondition;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdMetricDiffCondition;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdOperator;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdQualityGate;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdQualityGateStatus;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdThresholdIssueCondition;
import com.hello2morrow.sonargraph.integration.access.persistence.report.XsdThresholdIssueDiffCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class QualityGateReader {
    private static final String LIST_SEPARATOR = ",";
    private final SoftwareSystemImpl m_softwareSystem;
    private final Map<Object, IElement> m_globalXmlToElementMap;

    public QualityGateReader(SoftwareSystemImpl softwareSystem, Map<Object, IElement> globalXmlToElementMap) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'QualityGateReader' must not be null";
        assert (globalXmlToElementMap != null) : "Parameter 'globalXmlToElementMap' of method 'QualityGateReader' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_globalXmlToElementMap = globalXmlToElementMap;
    }

    public void addQualityGate(XsdQualityGate xsdQualityGate) {
        assert (xsdQualityGate != null) : "Parameter 'xsdQualityGate' of method 'addQualityGateDetails' must not be null";
        XsdElementKind xsdKind = XmlReportReaderUtils.getXsdElementKind(xsdQualityGate);
        SystemFileType type = SystemFileType.fromString(xsdQualityGate.getType());
        QualityGateImpl qualityGate = new QualityGateImpl(xsdKind.getStandardKind(), xsdKind.getPresentationKind(), xsdQualityGate.getName(), xsdQualityGate.getPresentationName(), xsdQualityGate.getFqName(), xsdQualityGate.getDescription(), xsdKind.getImageResourceName(), xsdQualityGate.getPath(), type, xsdQualityGate.getLastModified().toGregorianCalendar().getTimeInMillis());
        this.m_softwareSystem.addSystemFileElement(qualityGate);
        this.m_globalXmlToElementMap.put(xsdQualityGate, qualityGate);
        this.processCurrenSystemConditions(xsdQualityGate, qualityGate);
        this.processBaselineConditions(xsdQualityGate, qualityGate);
    }

    private void processBaselineConditions(XsdQualityGate xsdQualityGate, QualityGateImpl qualityGate) {
        XsdDiffAgainstBaselineConditions xsdBaselineConditions = xsdQualityGate.getBaselineConditions();
        DiffAgainstBaselineConditionsImpl baselineConditions = (DiffAgainstBaselineConditionsImpl)qualityGate.getDiffAgainstBaselineConditions();
        this.m_globalXmlToElementMap.put(xsdBaselineConditions, baselineConditions);
        for (XsdIssueDiffCondition xsdCondition : xsdBaselineConditions.getIssueDiffCondition()) {
            QualityGateIssueDiffConditionImpl diffCondition;
            XsdElementKind xsdKind = XmlReportReaderUtils.getXsdElementKind(xsdCondition);
            if (xsdCondition instanceof XsdThresholdIssueDiffCondition) {
                XsdThresholdIssueDiffCondition xsdThresholdCondition = (XsdThresholdIssueDiffCondition)xsdCondition;
                diffCondition = new QualityGateThresholdIssueDiffConditionImpl(xsdKind.getStandardKind(), xsdKind.getPresentationKind(), xsdCondition.getFqName(), xsdCondition.getName(), xsdCondition.getPresentationName(), xsdKind.getImageResourceName(), xsdCondition.getIssueType(), this.convertResolutions(xsdCondition.getResolution()), this.convertSeverities(xsdCondition.getSeverity()), xsdCondition.getInfo(), xsdThresholdCondition.getMetricId(), xsdThresholdCondition.getDiffThreshold(), xsdThresholdCondition.getDiffThresholdRelative(), this.convertOperator(xsdThresholdCondition.getOperator()), this.convertCheck(xsdThresholdCondition.getCheck()), this.convertStatus(xsdCondition.getStatus()));
            } else {
                diffCondition = new QualityGateIssueDiffConditionImpl(xsdKind.getStandardKind(), xsdKind.getPresentationKind(), xsdCondition.getFqName(), xsdCondition.getName(), xsdCondition.getPresentationName(), xsdKind.getImageResourceName(), xsdCondition.getIssueType(), this.convertResolutions(xsdCondition.getResolution()), this.convertSeverities(xsdCondition.getSeverity()), xsdCondition.getInfo(), this.convertCheck(xsdCondition.getCheck()), this.convertStatus(xsdCondition.getStatus()));
            }
            baselineConditions.addQualityGateCondition(diffCondition);
            this.m_globalXmlToElementMap.put(xsdCondition, diffCondition);
        }
        for (XsdMetricDiffCondition xsdMetricCondition : xsdBaselineConditions.getMetricDiffCondition()) {
            XsdElementKind xsdKind = XmlReportReaderUtils.getXsdElementKind(xsdMetricCondition);
            QualityGateMetricValueDiffConditionImpl metricCondition = new QualityGateMetricValueDiffConditionImpl(xsdKind.getStandardKind(), xsdKind.getPresentationKind(), xsdMetricCondition.getName(), xsdMetricCondition.getPresentationName(), xsdMetricCondition.getFqName(), xsdKind.getImageResourceName(), xsdMetricCondition.getMetricId(), this.convertOperator(xsdMetricCondition.getOperator()), xsdMetricCondition.getDiffThreshold(), xsdMetricCondition.getDiffThresholdRelative(), this.convertStatus(xsdMetricCondition.getStatus()));
            baselineConditions.addQualityGateCondition(metricCondition);
            this.m_globalXmlToElementMap.put(xsdMetricCondition, metricCondition);
        }
        for (XsdExcludeFilter nextXsdExclude : xsdBaselineConditions.getExclude()) {
            String issueType = nextXsdExclude.getIssueType();
            List<ResolutionMode> resolutions = this.convertResolutions(nextXsdExclude.getResolution());
            List<Severity> severities = this.convertSeverities(nextXsdExclude.getSeverity());
            XsdElementKind kind = XmlReportReaderUtils.getXsdElementKind(nextXsdExclude);
            String metricId = nextXsdExclude.getMetricId();
            QualityGateExcludeFilterImpl excludeFilter = new QualityGateExcludeFilterImpl(kind.getStandardKind(), kind.getPresentationKind(), nextXsdExclude.getFqName(), nextXsdExclude.getName(), nextXsdExclude.getPresentationName(), kind.getImageResourceName(), issueType, resolutions, severities, metricId, nextXsdExclude.getInfo());
            baselineConditions.addExcludeFilter(excludeFilter);
            this.m_globalXmlToElementMap.put(nextXsdExclude, excludeFilter);
        }
    }

    private Check convertCheck(XsdCheck check) {
        assert (check != null) : "Parameter 'check' of method 'convertCheck' must not be null";
        switch (check) {
            case RELAXED: {
                return Check.RELAXED;
            }
            case STRICT: {
                return Check.STRICT;
            }
        }
        assert (false) : "Unknown check value: " + check.name();
        return null;
    }

    private void processCurrenSystemConditions(XsdQualityGate xsdQualityGate, QualityGateImpl qualityGate) {
        XsdElementKind kind;
        List<Severity> severities;
        List<ResolutionMode> resolutions;
        String issueType;
        XsdCurrentSystemConditions xsdCurrentSystemConditions = xsdQualityGate.getCurrentSystemConditions();
        CurrentSystemConditionsImpl currentSystemConditions = (CurrentSystemConditionsImpl)qualityGate.getCurrentSystemConditions();
        this.m_globalXmlToElementMap.put(xsdCurrentSystemConditions, currentSystemConditions);
        for (XsdIssueCondition nextXsdCondition : xsdCurrentSystemConditions.getIssueCondition()) {
            issueType = nextXsdCondition.getIssueType();
            resolutions = this.convertResolutions(nextXsdCondition.getResolution());
            severities = this.convertSeverities(nextXsdCondition.getSeverity());
            kind = XmlReportReaderUtils.getXsdElementKind(nextXsdCondition);
            if (nextXsdCondition instanceof XsdThresholdIssueCondition) {
                XsdThresholdIssueCondition xsdThresholdCondition = (XsdThresholdIssueCondition)nextXsdCondition;
                String metricId = xsdThresholdCondition.getMetricId();
                QualityGateThresholdIssueConditionImpl condition = new QualityGateThresholdIssueConditionImpl(kind.getStandardKind(), kind.getPresentationKind(), nextXsdCondition.getFqName(), nextXsdCondition.getName(), nextXsdCondition.getPresentationName(), kind.getImageResourceName(), issueType, metricId, resolutions, severities, nextXsdCondition.getInfo(), this.convertOperator(nextXsdCondition.getOperator()), nextXsdCondition.getLimit(), this.convertStatus(nextXsdCondition.getStatus()));
                currentSystemConditions.addCurrentSystemCondition(condition);
                this.m_globalXmlToElementMap.put(xsdThresholdCondition, condition);
                continue;
            }
            QualityGateIssueConditionImpl condition = new QualityGateIssueConditionImpl(kind.getStandardKind(), kind.getPresentationKind(), nextXsdCondition.getFqName(), nextXsdCondition.getName(), nextXsdCondition.getPresentationName(), kind.getImageResourceName(), issueType, resolutions, severities, nextXsdCondition.getInfo(), this.convertOperator(nextXsdCondition.getOperator()), nextXsdCondition.getLimit(), this.convertStatus(nextXsdCondition.getStatus()));
            currentSystemConditions.addCurrentSystemCondition(condition);
            this.m_globalXmlToElementMap.put(nextXsdCondition, condition);
        }
        for (XsdExcludeFilter nextXsdExclude : xsdCurrentSystemConditions.getExclude()) {
            issueType = nextXsdExclude.getIssueType();
            resolutions = this.convertResolutions(nextXsdExclude.getResolution());
            severities = this.convertSeverities(nextXsdExclude.getSeverity());
            kind = XmlReportReaderUtils.getXsdElementKind(nextXsdExclude);
            String metricId = nextXsdExclude.getMetricId();
            QualityGateExcludeFilterImpl excludeFilter = new QualityGateExcludeFilterImpl(kind.getStandardKind(), kind.getPresentationKind(), nextXsdExclude.getFqName(), nextXsdExclude.getName(), nextXsdExclude.getPresentationName(), kind.getImageResourceName(), issueType, resolutions, severities, metricId, nextXsdExclude.getInfo());
            currentSystemConditions.addExcludeFilter(excludeFilter);
            this.m_globalXmlToElementMap.put(nextXsdExclude, excludeFilter);
        }
    }

    private List<Severity> convertSeverities(String severityString) {
        assert (severityString != null && severityString.length() > 0) : "Parameter 'severityString' of method 'convertSeverities' must not be empty";
        List<String> severities = QualityGateReader.convertToList(severityString);
        ArrayList<Severity> severityList = new ArrayList<Severity>(severities.size());
        for (String next : severities) {
            Severity converted = Severity.fromString(next);
            if (converted == null) continue;
            severityList.add(converted);
        }
        return severityList;
    }

    private List<ResolutionMode> convertResolutions(String resolutionModes) {
        assert (resolutionModes != null && resolutionModes.length() > 0) : "Parameter 'resolutionTypes' of method 'convertResolutions' must not be empty";
        List<String> resolutions = QualityGateReader.convertToList(resolutionModes);
        ArrayList<ResolutionMode> resolutionModeList = new ArrayList<ResolutionMode>();
        for (String next : resolutions) {
            ResolutionMode mode = ResolutionMode.fromString(next);
            if (mode == null) continue;
            resolutionModeList.add(mode);
        }
        return resolutionModeList;
    }

    private Status convertStatus(XsdQualityGateStatus xsdStatus) {
        assert (xsdStatus != null) : "Parameter 'xsdStatus' of method 'convertStatus' must not be null";
        switch (xsdStatus) {
            case PASSED: {
                return Status.PASSED;
            }
            case FAILED: {
                return Status.FAILED;
            }
            case NONE: {
                return Status.NONE;
            }
        }
        assert (false) : "Unsupported quality gate status: " + xsdStatus.name();
        return null;
    }

    public static List<String> convertToList(String valueList) {
        assert (valueList != null && !valueList.isEmpty()) : "Parameter 'valueList' of method 'convertToList' must not be empty";
        ArrayList<String> result = new ArrayList<String>();
        for (String next : valueList.split(LIST_SEPARATOR)) {
            result.add(next.trim());
        }
        result.trimToSize();
        return result;
    }

    private Operator convertOperator(XsdOperator operator) {
        switch (operator) {
            case LESS: {
                return Operator.LESS;
            }
            case LESS_OR_EQUAL: {
                return Operator.LESS_OR_EQUAL;
            }
            case EQUAL: {
                return Operator.EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return Operator.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return Operator.GREATER;
            }
            case N_A: {
                return Operator.N_A;
            }
        }
        assert (false) : "Unsupported operator: " + operator.name();
        return null;
    }

    public static class InvalidMetricIdException
    extends Exception {
        private static final long serialVersionUID = 736505155318129756L;

        public InvalidMetricIdException(String message) {
            super(message);
        }
    }
}

