/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IDuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.integration.access.model.ISourceFile;

public final class DuplicateCodeBlockOccurrenceImpl
implements IDuplicateCodeBlockOccurrence {
    private static final long serialVersionUID = -5679562127595114393L;
    private final ISourceFile sourceFile;
    private final int blockSize;
    private final int startLine;
    private final int tolerance;
    private final int endLine;
    private final int[] hash;

    public DuplicateCodeBlockOccurrenceImpl(ISourceFile sourceFile, int blockSize, int startLine, int endLine, int tolerance, int[] hash) {
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'DuplicateCodeBlockOccurrenceImpl' must not be null";
        assert (blockSize > 0) : "Parameter 'blockSize' must be > 0";
        assert (startLine >= 0) : "Parameter 'startLine' must be >= 0";
        assert (tolerance >= 0) : "Parameter 'tolerance' must be >= 0";
        this.sourceFile = sourceFile;
        this.blockSize = blockSize;
        this.startLine = startLine;
        this.endLine = endLine == -1 ? startLine + blockSize - 1 : endLine;
        this.tolerance = tolerance;
        this.hash = hash;
    }

    @Override
    public ISourceFile getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public int getTolerance() {
        return this.tolerance;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int[] getHash() {
        return this.hash;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blockSize;
        result = 31 * result + this.endLine;
        result = 31 * result + (this.hash == null ? 0 : this.hash.hashCode());
        result = 31 * result + (this.sourceFile == null ? 0 : this.sourceFile.hashCode());
        result = 31 * result + this.startLine;
        result = 31 * result + this.tolerance;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DuplicateCodeBlockOccurrenceImpl other = (DuplicateCodeBlockOccurrenceImpl)obj;
        if (this.blockSize != other.blockSize) {
            return false;
        }
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.hash == null ? other.hash != null : !this.hash.equals(other.hash)) {
            return false;
        }
        if (this.sourceFile == null ? other.sourceFile != null : !this.sourceFile.equals(other.sourceFile)) {
            return false;
        }
        if (this.startLine != other.startLine) {
            return false;
        }
        return this.tolerance == other.tolerance;
    }

    public String toString() {
        return "DuplicateCodeBlockOccurrenceImpl [sourceFile=" + String.valueOf(this.sourceFile) + ", blockSize=" + this.blockSize + ", startLine=" + this.startLine + ", tolerance=" + this.tolerance + ", endLine=" + this.endLine + "]";
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.sourceFile.getIdentifyingPath());
        stringBuilder.append(" (").append(this.startLine).append("-").append(this.endLine).append(")");
        return stringBuilder.toString();
    }

    @Override
    public String getPresentationName() {
        return this.getName();
    }
}

