/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IDuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.integration.access.model.IDuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.integration.access.model.IIssueProvider;
import com.hello2morrow.sonargraph.integration.access.model.IIssueType;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.internal.MultiNamedElementIssueImpl;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class DuplicateCodeBlockIssueImpl
extends MultiNamedElementIssueImpl
implements IDuplicateCodeBlockIssue {
    private static final long serialVersionUID = 3572308291532903170L;
    private int blockSize;
    private final List<IDuplicateCodeBlockOccurrence> occurrences;
    private final int duplicateLineCount;

    public DuplicateCodeBlockIssueImpl(String name, String presentationName, String description, IIssueType issueType, IIssueProvider provider, List<IDuplicateCodeBlockOccurrence> occurrences, int duplicateLineCount) {
        super(name, presentationName, description, issueType, provider);
        this.occurrences = occurrences;
        this.duplicateLineCount = duplicateLineCount == -1 ? occurrences.stream().mapToInt(occ -> occ.getBlockSize()).sum() : duplicateLineCount;
    }

    @Override
    public List<INamedElement> getNamedElements() {
        return Collections.unmodifiableList(this.occurrences.stream().map(o -> o.getSourceFile()).distinct().collect(Collectors.toList()));
    }

    @Override
    public List<INamedElement> getAffectedNamedElements() {
        return Collections.unmodifiableList(this.occurrences.stream().map(o -> o.getSourceFile()).distinct().collect(Collectors.toList()));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("Duplicate Code Block with ");
        builder.append(this.occurrences.size()).append(" occurrences, block size '").append(this.blockSize).append("', resolved '").append(this.hasResolution()).append("'");
        this.occurrences.forEach(occ -> builder.append("\n").append("   ").append("   ").append("   ").append("Occurrence in ").append(occ.getSourceFile().getPresentationName()).append(", start '").append(occ.getStartLine()).append("', block size '").append(occ.getBlockSize()).append("', tolerance '").append(occ.getTolerance()).append("'"));
        return builder.toString();
    }

    public void setBlockSize(int blockSize) {
        assert (blockSize > 0) : "Parameter 'blockSize' of method 'setBlockSize' must be > 0";
        this.blockSize = blockSize;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public List<IDuplicateCodeBlockOccurrence> getOccurrences() {
        return Collections.unmodifiableList(this.occurrences);
    }

    @Override
    public int getTotalDuplicateLineCount() {
        return this.duplicateLineCount;
    }
}

