/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IAnalyzer;
import com.hello2morrow.sonargraph.integration.access.model.ICycleGroupIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssueProvider;
import com.hello2morrow.sonargraph.integration.access.model.IIssueType;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.Severity;
import com.hello2morrow.sonargraph.integration.access.model.internal.MultiNamedElementIssueImpl;
import java.util.Collections;
import java.util.List;

public final class CycleGroupIssueImpl
extends MultiNamedElementIssueImpl
implements ICycleGroupIssue {
    private static final long serialVersionUID = 6456637507787653398L;
    private final IAnalyzer analyzer;
    private final List<INamedElement> cyclicElements;
    private final int componentDependenciesToRemove;
    private final int structuralDebtIndex;
    private final int parserDependenciesToRemove;
    private final INamedElement scope;
    private final Severity severity;

    public CycleGroupIssueImpl(String name, String presentationName, String description, IIssueType issueType, Severity severity, IIssueProvider provider, IAnalyzer analyzer, List<INamedElement> cyclicElements, int structuralDebtIndex, int componentDependenciesToRemove, int parserDependenciesToRemove, INamedElement scope) {
        super(name, presentationName, description, issueType, provider);
        assert (analyzer != null) : "Parameter 'analyzer' of method 'CycleGroup' must not be null";
        assert (cyclicElements != null && !cyclicElements.isEmpty()) : "Parameter 'cyclicElements' of method 'CycleGroupIssueImpl' must not be empty";
        assert (severity != null) : "Parameter 'severity' of method 'CycleGroupIssueImpl' must not be null";
        this.analyzer = analyzer;
        this.cyclicElements = cyclicElements;
        this.structuralDebtIndex = structuralDebtIndex;
        this.componentDependenciesToRemove = componentDependenciesToRemove;
        this.parserDependenciesToRemove = parserDependenciesToRemove;
        this.scope = scope;
        this.severity = severity;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public List<INamedElement> getNamedElements() {
        return Collections.unmodifiableList(this.cyclicElements);
    }

    @Override
    public List<INamedElement> getAffectedNamedElements() {
        return Collections.unmodifiableList(this.cyclicElements);
    }

    @Override
    public IAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public int getStructuralDebtIndex() {
        return this.structuralDebtIndex;
    }

    @Override
    public int getComponentDependenciesToRemove() {
        return this.componentDependenciesToRemove;
    }

    @Override
    public int getParserDependenciesToRemove() {
        return this.parserDependenciesToRemove;
    }

    @Override
    public INamedElement getScope() {
        return this.scope;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.getIssueType().toString());
        builder.append(", generated by ").append(this.getIssueProvider().toString()).append(": ").append(this.getDescription()).append(", resolved '").append(this.hasResolution()).append("'");
        this.cyclicElements.forEach(ce -> builder.append("\n").append("   ").append("   ").append("   ").append("Involved element: ").append(ce.getPresentationName()));
        return builder.toString();
    }
}

