/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IConfiguration;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementWithDescriptionImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractConfigurationImpl
extends ElementWithDescriptionImpl
implements IConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfigurationImpl.class);
    private static final long serialVersionUID = 2109849250086262632L;
    private final Map<String, Integer> intProperties = new HashMap<String, Integer>();
    private final Map<String, String> stringProperties = new HashMap<String, String>();
    private final Map<String, Boolean> booleanProperties = new HashMap<String, Boolean>();
    private final Map<String, Float> floatProperties = new HashMap<String, Float>();
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    public AbstractConfigurationImpl(String name, String presentationName, String description) {
        super(name, presentationName, description);
    }

    public final void addIntConfigurationValue(String property, int value) {
        assert (property != null && property.length() > 0) : "Parameter 'property' of method 'addIntConfigurationValue' must not be empty";
        Object prev = this.properties.put(property, value);
        assert (prev == null) : "Integer property '" + property + "' was already present with value '" + String.valueOf(prev) + "', now overwritten with '" + value + "'";
        Integer previous = this.intProperties.put(property, value);
        assert (previous == null) : "Property '" + property + "' was already present with value '" + previous + "', now overwritten with '" + value + "'";
    }

    public final void addStringConfigurationValue(String property, String value) {
        assert (property != null && property.length() > 0) : "Parameter 'property' of method 'addStringConfigurationValue' must not be empty";
        Object prev = this.properties.put(property, value);
        assert (prev == null) : "String property '" + property + "' was already present with value '" + String.valueOf(prev) + "', now overwritten with '" + value + "'";
        String previous = this.stringProperties.put(property, value);
        assert (previous == null) : "Property '" + property + "' was already present with value '" + previous + "', now overwritten with '" + value + "'";
    }

    public final void addBooleanConfigurationValue(String property, boolean value) {
        assert (property != null && property.length() > 0) : "Parameter 'property' of method 'addBooleanConfigurationValue' must not be empty";
        Object prev = this.properties.put(property, value);
        assert (prev == null) : "Boolean property '" + property + "' was already present with value '" + String.valueOf(prev) + "', now overwritten with '" + value + "'";
        Boolean previous = this.booleanProperties.put(property, value);
        assert (previous == null) : "Property '" + property + "' was already present with value '" + previous + "', now overwritten with '" + value + "'";
    }

    public final void addFloatConfigurationValue(String property, float value) {
        assert (property != null && property.length() > 0) : "Parameter 'property' of method 'addFloatConfigurationValue' must not be empty";
        Object prev = this.properties.put(property, Float.valueOf(value));
        assert (prev == null) : "Float property '" + property + "' was already present with value '" + String.valueOf(prev) + "', now overwritten with '" + value + "'";
        Float previous = this.floatProperties.put(property, Float.valueOf(value));
        assert (previous == null) : "Property '" + property + "' was already present with value '" + previous + "', now overwritten with '" + value + "'";
    }

    @Override
    public final Map<String, Object> getConfigurationValues() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public final Integer getIntConfigurationValue(String property) {
        assert (property != null && property.length() > 0) : "Parameter 'property' of method 'getIntConfigurationValue' must not be empty";
        if (this.intProperties.containsKey(property)) {
            return this.intProperties.get(property);
        }
        LOGGER.warn("Integer property '{}' does not exist, returning {}", (Object)property, null);
        return null;
    }

    @Override
    public final String getStringConfigurationValue(String property) {
        assert (property != null && property.length() > 0) : "Parameter 'property' of method 'getStringConfigurationValue' must not be empty";
        if (this.stringProperties.containsKey(property)) {
            return this.stringProperties.get(property);
        }
        LOGGER.warn("String property '{}' does not exist, returning null", (Object)property);
        return null;
    }

    @Override
    public final Boolean getBooleanConfigurationValue(String property) {
        if (this.booleanProperties.containsKey(property)) {
            return this.booleanProperties.get(property);
        }
        LOGGER.warn("Boolean property '{}' does not exist, returning null", (Object)property);
        return false;
    }

    @Override
    public Float getFloatConfigurationValue(String property) {
        assert (property != null && property.length() > 0) : "Parameter 'property' of method 'getFloatConfigurationValue' must not be empty";
        if (this.floatProperties.containsKey(property)) {
            return this.floatProperties.get(property);
        }
        LOGGER.warn("Float property '{}' does not exist, returning {}", (Object)property, null);
        return null;
    }
}

