/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model;

import com.hello2morrow.sonargraph.integration.access.foundation.IEnumeration;
import com.hello2morrow.sonargraph.integration.access.foundation.Utility;
import com.hello2morrow.sonargraph.integration.access.model.IElementWithDescription;
import com.hello2morrow.sonargraph.integration.access.model.IMetricCategory;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IMetricProvider;
import java.util.List;

public interface IMetricId
extends IElementWithDescription {
    public List<IMetricCategory> getCategories();

    public IMetricProvider getProvider();

    public boolean isFloat();

    public List<IMetricLevel> getLevels();

    @Deprecated
    public Double getBestValue();

    @Deprecated
    public Double getWorstValue();

    public double getBest();

    public double getMin();

    public double getMax();

    public SortDirection getSortDirection();

    public double getWorst();

    public static final class StandardName
    extends Enum<StandardName>
    implements IEnumeration {
        public static final /* enum */ StandardName CORE_VIOLATIONS_PARSER_DEPENDENCIES = new StandardName("Number of Violations (Parser Dependencies)");
        public static final /* enum */ StandardName CORE_COMPONENTS = new StandardName("Number of Components");
        public static final /* enum */ StandardName CORE_UNASSIGNED_COMPONENTS = new StandardName("Number of Unassigned Components");
        public static final /* enum */ StandardName CORE_VIOLATING_COMPONENTS = new StandardName("Number of Components with Violations");
        public static final /* enum */ StandardName CORE_NCCD = new StandardName("NCCD");
        String presentationName;
        private static final /* synthetic */ StandardName[] $VALUES;

        public static StandardName[] values() {
            return (StandardName[])$VALUES.clone();
        }

        public static StandardName valueOf(String name) {
            return Enum.valueOf(StandardName.class, name);
        }

        private StandardName(String presentationName) {
            assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'StandardMetricNames' must not be empty";
            this.presentationName = presentationName;
        }

        @Override
        public String getStandardName() {
            return Utility.convertConstantNameToStandardName(this.name());
        }

        @Override
        public String getPresentationName() {
            return this.presentationName;
        }

        static {
            $VALUES = new StandardName[]{CORE_VIOLATIONS_PARSER_DEPENDENCIES, CORE_COMPONENTS, CORE_UNASSIGNED_COMPONENTS, CORE_VIOLATING_COMPONENTS, CORE_NCCD};
        }
    }

    public static enum SortDirection implements IEnumeration
    {
        INDIFFERENT,
        HIGHER_WORSE,
        LOWER_WORSE,
        OPTIMUM_AT_ZERO,
        OPTIMUM_AT;


        @Override
        public String getStandardName() {
            return Utility.convertConstantNameToStandardName(this.name());
        }

        @Override
        public String getPresentationName() {
            return Utility.convertConstantNameToPresentationName(this.name());
        }

        public static SortDirection fromStandardName(String direction) {
            return SortDirection.valueOf(Utility.convertStandardNameToConstantName(direction));
        }
    }
}

