/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.foundation;

import com.hello2morrow.sonargraph.integration.access.foundation.IEnumeration;
import com.hello2morrow.sonargraph.integration.access.foundation.Utility;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Result
implements Serializable {
    private static final long serialVersionUID = -6766490149645425638L;
    private final List<Message> messages = new ArrayList<Message>();
    private final String description;

    public Result(String description) {
        assert (description != null && description.length() > 0) : "Parameter 'description' of method 'Result' must not be empty";
        this.description = description;
    }

    public final List<Message> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public boolean contains(Level status) {
        assert (status != null) : "Parameter 'status' of method 'containsMessageWithStatus' must not be null";
        for (Message nextMessage : this.messages) {
            if (nextMessage.getLevel() != status) continue;
            return true;
        }
        return false;
    }

    public final boolean isSuccess() {
        for (Message nextMessage : this.messages) {
            if (nextMessage.getLevel() != Level.ERROR) continue;
            return false;
        }
        return true;
    }

    public final boolean isFailure() {
        return !this.isSuccess();
    }

    public List<String> getMessages(Level status) {
        assert (status != null) : "Parameter 'status' of method 'getMessages' must not be null";
        return this.messages.stream().filter(m -> m.getLevel() == status).map(m -> m.getMessage()).collect(Collectors.toList());
    }

    public final void addInfo(ICause cause) {
        assert (cause != null) : "Parameter 'cause' of method 'addInfo' must not be null";
        this.messages.add(new Message(Level.INFO, cause, cause.getPresentationName()));
    }

    public final String addInfo(ICause cause, String detail) {
        assert (cause != null) : "Parameter 'cause' of method 'addInfo' must not be null";
        assert (detail != null && detail.length() > 0) : "Parameter 'detail' of method 'addInfo' must not be empty";
        Message message = new Message(Level.INFO, cause, cause.getPresentationName() + ". " + detail);
        this.messages.add(message);
        return message.getMessage();
    }

    public final void addWarning(ICause cause, String detail, Object ... args) {
        assert (cause != null) : "Parameter 'cause' of method 'addWarning' must not be null";
        assert (detail != null && detail.length() > 0) : "Parameter 'detail' of method 'addWarning' must not be empty";
        Message message = new Message(Level.WARNING, cause, cause.getPresentationName() + ". " + String.format(detail, args));
        this.messages.add(message);
    }

    public final void addWarning(ICause cause) {
        assert (cause != null) : "Parameter 'cause' of method 'addWarning' must not be null";
        Message message = new Message(Level.WARNING, cause, cause.getPresentationName() + ".");
        this.messages.add(message);
    }

    public final void addWarning(ICause cause, Throwable throwable) {
        assert (cause != null) : "Parameter 'cause' of method 'addWarning' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'addWarning' must not be null";
        Message message = new Message(Level.WARNING, cause, cause.getPresentationName() + "." + Utility.LINE_SEPARATOR + Utility.collectAll(throwable));
        this.messages.add(message);
    }

    public final void addError(ICause cause) {
        assert (cause != null) : "Parameter 'cause' of method 'addError' must not be null";
        Message message = new Message(Level.ERROR, cause, cause.getPresentationName() + ".");
        this.messages.add(message);
    }

    public final void addError(ICause cause, String detail, Object ... args) {
        assert (cause != null) : "Parameter 'cause' of method 'addError' must not be null";
        assert (detail != null && detail.length() > 0) : "Parameter 'detail' of method 'addError' must not be empty";
        Message message = new Message(Level.ERROR, cause, cause.getPresentationName() + ". " + String.format(detail, args));
        this.messages.add(message);
    }

    public final void addError(ICause cause, Throwable throwable) {
        assert (cause != null) : "Parameter 'cause' of method 'addError' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'addError' must not be null";
        Message message = new Message(Level.ERROR, cause, cause.getPresentationName() + "." + Utility.LINE_SEPARATOR + Utility.collectAll(throwable));
        this.messages.add(message);
    }

    public final void addError(ICause cause, Throwable throwable, String detail, Object ... args) {
        assert (cause != null) : "Parameter 'cause' of method 'addError' must not be null";
        assert (throwable != null) : "Parameter 'throwable' of method 'addError' must not be null";
        assert (detail != null && detail.length() > 0) : "Parameter 'detail' of method 'addError' must not be empty";
        Message message = new Message(Level.ERROR, cause, cause.getPresentationName() + ". " + String.format(detail, args) + Utility.LINE_SEPARATOR + Utility.collectAll(throwable));
        this.messages.add(message);
    }

    public final void addMessagesFrom(Result result) {
        assert (result != null) : "Parameter 'result' of method 'addOperationResult' must not be null";
        assert (result != this) : "result must not be this";
        this.messages.addAll(result.getMessages());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.isFailure() ? "Failure: " : "Success: ");
        builder.append(this.description);
        for (Message next : this.messages) {
            builder.append(Utility.LINE_SEPARATOR);
            builder.append(next.toString());
        }
        return builder.toString();
    }

    public static final class Message
    implements Serializable {
        private static final long serialVersionUID = -7783022002494186583L;
        private final Level level;
        private final ICause cause;
        private final String message;

        public Message(Level level, ICause cause, String message) {
            assert (level != null) : "Parameter 'level' of method 'Message' must not be null";
            assert (cause != null) : "Parameter 'cause' of method 'Message' must not be null";
            assert (message != null && message.length() > 0) : "Parameter 'message' of method 'Message' must not be empty";
            this.level = level;
            this.cause = cause;
            this.message = message;
        }

        public Level getLevel() {
            return this.level;
        }

        public ICause getCause() {
            return this.cause;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.level.getPresentationName());
            builder.append(" - ");
            builder.append(this.message);
            return builder.toString();
        }
    }

    public static interface ICause
    extends IEnumeration {
    }

    public static enum Level implements IEnumeration
    {
        INFO,
        WARNING,
        ERROR;


        @Override
        public String getStandardName() {
            return Utility.convertConstantNameToStandardName(this.name());
        }

        @Override
        public String getPresentationName() {
            return Utility.convertConstantNameToPresentationName(this.name());
        }

        public String toString() {
            return this.getPresentationName();
        }
    }
}

