/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.foundation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AggregatingClassLoader
extends ClassLoader {
    private final List<ClassLoader> m_classLoaders = new ArrayList<ClassLoader>();

    public AggregatingClassLoader(ClassLoader classLoader) {
        assert (classLoader != null) : "Parameter 'classLoader' of method 'AggregatingClassLoader' must not be null";
        this.m_classLoaders.add(classLoader);
    }

    public AggregatingClassLoader(List<ClassLoader> classLoaders) {
        assert (classLoaders != null) : "Parameter 'classLoaders' of method 'AggregatingClassLoader' must not be null";
        this.addClassLoaders(classLoaders);
    }

    public AggregatingClassLoader(AggregatingClassLoader aggregatingClassLoader) {
        assert (aggregatingClassLoader != null) : "Parameter 'aggregatingClassLoader' of method 'AggregatingClassLoader' must not be null";
        this.addClassLoaders(aggregatingClassLoader.m_classLoaders);
    }

    private void addClassLoaders(List<ClassLoader> classLoaders) {
        for (ClassLoader cl : classLoaders) {
            if (!this.m_classLoaders.isEmpty() && this.m_classLoaders.contains(cl)) continue;
            this.m_classLoaders.add(cl);
        }
    }

    public List<ClassLoader> getClassLoaders() {
        return Collections.unmodifiableList(this.m_classLoaders);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if ("META-INF/services/javax.xml.bind.JAXBContext".equals(name)) {
            return new ByteArrayInputStream("com.sun.xml.bind.v2.ContextFactory".getBytes());
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader loader : this.m_classLoaders) {
            URL resource = loader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.m_classLoaders.isEmpty()) {
            throw new ClassNotFoundException("Unable to locate class '" + name + "' - no class loaders available");
        }
        for (ClassLoader loader : this.m_classLoaders) {
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException("Unable to locate class '" + name + "' - not found by class loaders " + String.valueOf(this.m_classLoaders));
    }
}

