/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.controller;

import com.hello2morrow.sonargraph.integration.access.controller.IModuleInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.controller.ModuleInfoProcessorImpl;
import com.hello2morrow.sonargraph.integration.access.model.IAnalyzer;
import com.hello2morrow.sonargraph.integration.access.model.IAnalyzerConfiguration;
import com.hello2morrow.sonargraph.integration.access.model.ICycleGroupIssue;
import com.hello2morrow.sonargraph.integration.access.model.IFeature;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.IIssueCategory;
import com.hello2morrow.sonargraph.integration.access.model.IIssueProvider;
import com.hello2morrow.sonargraph.integration.access.model.IIssueType;
import com.hello2morrow.sonargraph.integration.access.model.IMetricCategory;
import com.hello2morrow.sonargraph.integration.access.model.IMetricId;
import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IMetricProvider;
import com.hello2morrow.sonargraph.integration.access.model.IMetricThreshold;
import com.hello2morrow.sonargraph.integration.access.model.IMetricValue;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.IPlugin;
import com.hello2morrow.sonargraph.integration.access.model.IPluginConfiguration;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ISystemFile;
import com.hello2morrow.sonargraph.integration.access.model.ISystemFileElement;
import com.hello2morrow.sonargraph.integration.access.model.IThresholdViolationIssue;
import com.hello2morrow.sonargraph.integration.access.model.internal.ModuleImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.SoftwareSystemImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class SystemInfoProcessorImpl
implements ISystemInfoProcessor {
    private final SoftwareSystemImpl softwareSystem;

    public SystemInfoProcessorImpl(SoftwareSystemImpl system) {
        assert (system != null) : "Parameter 'system' of method 'SystemInfoProcessorImpl' must not be null";
        this.softwareSystem = system;
    }

    @Override
    public ISoftwareSystem getSoftwareSystem() {
        return this.softwareSystem;
    }

    @Override
    public String getBaseDirectory() {
        return this.softwareSystem.getBaseDir();
    }

    @Override
    public List<IIssue> getIssues(Predicate<IIssue> filter) {
        if (filter == null) {
            List<IIssue> issueList = Collections.unmodifiableList(this.softwareSystem.getIssues().values().stream().flatMap(list -> list.stream()).collect(Collectors.toList()));
            return issueList;
        }
        return Collections.unmodifiableList(this.softwareSystem.getIssues().values().stream().flatMap(list -> list.stream()).filter(filter).collect(Collectors.toList()));
    }

    @Override
    public List<IIssue> getIssues(Set<IIssue> issuesToSelectFrom, Predicate<IIssue> filter) {
        if (filter == null) {
            Collections.unmodifiableList(new ArrayList<IIssue>(issuesToSelectFrom));
        }
        return Collections.unmodifiableList(issuesToSelectFrom.stream().filter(filter).collect(Collectors.toList()));
    }

    @Override
    public boolean hasIssue(Predicate<IIssue> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Missing mandatory argument 'filter'");
        }
        return this.softwareSystem.getIssues().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).anyMatch(filter);
    }

    @Override
    public List<IThresholdViolationIssue> getThresholdViolationIssues(Predicate<IThresholdViolationIssue> filter) {
        if (filter == null) {
            return this.softwareSystem.getIssues().entrySet().stream().filter(entry -> ((IIssueType)entry.getKey()).getCategory().getName().equals("ThresholdViolation")).flatMap(entry -> ((List)entry.getValue()).stream()).map(issue -> (IThresholdViolationIssue)issue).collect(Collectors.toList());
        }
        return this.softwareSystem.getIssues().entrySet().stream().filter(entry -> ((IIssueType)entry.getKey()).getCategory().getName().equals("ThresholdViolation")).flatMap(entry -> ((List)entry.getValue()).stream()).map(issue -> (IThresholdViolationIssue)issue).filter(filter).collect(Collectors.toList());
    }

    @Override
    public List<IResolution> getResolutions(Predicate<IResolution> filter) {
        if (filter == null) {
            return Collections.unmodifiableList(this.softwareSystem.getResolutions().values().stream().flatMap(resolutions -> resolutions.stream()).collect(Collectors.toList()));
        }
        return Collections.unmodifiableList(this.softwareSystem.getResolutions().values().stream().flatMap(resolutions -> resolutions.stream()).filter(filter).collect(Collectors.toList()));
    }

    @Override
    public <T extends IResolution> List<T> getResolutions(Predicate<T> filter, Class<T> resolutionClass) {
        if (filter == null) {
            return Collections.unmodifiableList(this.softwareSystem.getResolutions().values().stream().flatMap(resolutions -> resolutions.stream()).filter(r -> resolutionClass.isAssignableFrom(r.getClass())).map(r -> r).collect(Collectors.toList()));
        }
        return Collections.unmodifiableList(this.softwareSystem.getResolutions().values().stream().flatMap(resolutions -> resolutions.stream()).filter(r -> resolutionClass.isAssignableFrom(r.getClass())).map(r -> r).filter(filter).collect(Collectors.toList()));
    }

    @Override
    public Optional<IMetricId> getMetricId(IMetricLevel level, String metricId) {
        return this.softwareSystem.getMetricIdsForLevel(level).stream().filter(id -> id.getName().equals(metricId)).findAny();
    }

    @Override
    public Optional<IMetricValue> getMetricValueForElement(IMetricId metricId, IMetricLevel level, String fqName) {
        return this.softwareSystem.getMetricValueForElement(metricId, level, fqName);
    }

    @Override
    public List<IMetricId> getMetricIdsForLevel(IMetricLevel level) {
        assert (level != null) : "Parameter 'level' of method 'getMetricIdsForLevel' must not be null";
        return this.softwareSystem.getMetricIdsForLevel(level);
    }

    @Override
    public List<IIssueProvider> getIssueProviders() {
        return Collections.unmodifiableList(new ArrayList<IIssueProvider>(this.softwareSystem.getIssueProviders().values()));
    }

    @Override
    public List<IIssueType> getIssueTypes() {
        return Collections.unmodifiableList(new ArrayList<IIssueType>(this.softwareSystem.getIssueTypes().values()));
    }

    @Override
    public List<IIssueCategory> getIssueCategories() {
        return Collections.unmodifiableList(new ArrayList<IIssueCategory>(this.softwareSystem.getIssueCategories().values()));
    }

    @Override
    public List<ICycleGroupIssue> getCycleGroups(Predicate<ICycleGroupIssue> filter) {
        Predicate<ICycleGroupIssue> filter2 = filter != null ? filter : group -> true;
        return this.getIssues(issue -> issue instanceof ICycleGroupIssue).stream().map(issue -> (ICycleGroupIssue)issue).filter(filter2).collect(Collectors.toList());
    }

    @Override
    public List<IAnalyzer> getAnalyzers() {
        return Collections.unmodifiableList(new ArrayList<IAnalyzer>(this.softwareSystem.getAnalyzers().values()));
    }

    @Override
    public List<IPlugin> getPlugins() {
        return Collections.unmodifiableList(new ArrayList<IPlugin>(this.softwareSystem.getPlugins().values()));
    }

    @Override
    public List<IFeature> getFeatures() {
        return Collections.unmodifiableList(new ArrayList<IFeature>(this.softwareSystem.getFeatures().values()));
    }

    @Override
    public List<String> getDuplicateCodeConfigurationEntries() {
        return this.softwareSystem.getDuplicateCodeConfigurationEntries();
    }

    @Override
    public List<String> getScriptRunnerConfigurationEntries() {
        return this.softwareSystem.getScriptRunnerConfigurationEntries();
    }

    @Override
    public List<String> getArchitectureCheckConfigurationEntries() {
        return this.softwareSystem.getArchitectureCheckConfigurationEntries();
    }

    @Override
    public List<IMetricCategory> getMetricCategories() {
        return Collections.unmodifiableList(new ArrayList<IMetricCategory>(this.softwareSystem.getMetricCategories().values()));
    }

    @Override
    public List<IMetricProvider> getMetricProviders() {
        return Collections.unmodifiableList(new ArrayList<IMetricProvider>(this.softwareSystem.getMetricProviders().values()));
    }

    @Override
    public Optional<IMetricId> getMetricId(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getMetricId' must not be empty";
        return Optional.ofNullable(this.softwareSystem.getMetricIds().get(name));
    }

    @Override
    public List<IMetricId> getMetricIds() {
        return Collections.unmodifiableList(new ArrayList<IMetricId>(this.softwareSystem.getMetricIds().values()));
    }

    @Override
    public Optional<IMetricValue> getMetricValue(String metricId) {
        Optional<IMetricId> id = this.getMetricId(metricId);
        if (!id.isPresent()) {
            return Optional.empty();
        }
        return this.softwareSystem.getSystemMetricValue(id.get());
    }

    @Override
    public Map<INamedElement, IMetricValue> getMetricValues(String levelName, String metricIdName) {
        assert (levelName != null && levelName.length() > 0) : "Parameter 'levelName' of method 'getMetricValues' must not be empty";
        assert (metricIdName != null && metricIdName.length() > 0) : "Parameter 'metricIdName' of method 'getMetricValues' must not be empty";
        return this.softwareSystem.getMetricValues(levelName, metricIdName);
    }

    @Override
    public List<IMetricLevel> getMetricLevels() {
        return Collections.unmodifiableList(new ArrayList<IMetricLevel>(this.softwareSystem.getAllMetricLevels().values()));
    }

    @Override
    public Optional<IMetricLevel> getMetricLevel(String systemLevel) {
        return Optional.ofNullable(this.softwareSystem.getMetricLevels().get(systemLevel));
    }

    @Override
    public Map<String, IModule> getModules() {
        return this.softwareSystem.getModules();
    }

    @Override
    public List<IMetricThreshold> getMetricThresholds() {
        return this.softwareSystem.getMetricThresholds();
    }

    @Override
    public List<String> getElementKinds() {
        HashSet<String> elementKinds = new HashSet<String>(this.softwareSystem.getElementKinds());
        for (IModule next : this.softwareSystem.getModules().values()) {
            elementKinds.addAll(next.getElementKinds());
        }
        return new ArrayList<String>(elementKinds);
    }

    @Override
    public IResolution getResolution(IIssue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'getResolution' must not be null";
        return this.softwareSystem.getResolution(issue);
    }

    @Override
    public IModuleInfoProcessor createModuleInfoProcessor(IModule module) {
        assert (module != null) : "Parameter 'module' of method 'createModuleInfoProcessor' must not be null";
        assert (module instanceof ModuleImpl) : "Unexpected class in method 'createModuleInfoProcessor': " + String.valueOf(module.getClass());
        return new ModuleInfoProcessorImpl(this, (ModuleImpl)module);
    }

    @Override
    public Map<String, IAnalyzerConfiguration> getAnalyzerConfigurations() {
        return this.softwareSystem.getAnalyzerConfigurations();
    }

    @Override
    public Map<String, IPluginConfiguration> getPluginConfigurations() {
        return this.softwareSystem.getPluginConfigurations();
    }

    @Override
    public List<ISystemFile> getSystemFiles() {
        return this.softwareSystem.getSystemFiles();
    }

    @Override
    public List<ISystemFileElement> getSystemFileElements() {
        return this.softwareSystem.getSystemFileElements();
    }
}

