/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.sonar.api.internal.apachecommons.io.IOUtils;
import org.sonar.api.server.rule.Context;
import org.sonar.api.server.rule.ContextAwareRuleDescriptionSection;
import org.sonar.api.server.rule.DefaultRuleDescriptionSection;
import org.sonar.api.server.rule.RuleDescriptionSection;
import org.sonar.api.server.rule.StringPatternValidator;

public final class RuleDescriptionSectionBuilder {
    private static final StringPatternValidator SECTION_KEY_VALIDATOR = StringPatternValidator.validatorWithCommonPatternForKeys("section keys");
    private String sectionKey;
    private String htmlContent;
    private Context context;

    public RuleDescriptionSectionBuilder sectionKey(String sectionKey) {
        SECTION_KEY_VALIDATOR.validate(sectionKey);
        this.sectionKey = sectionKey;
        return this;
    }

    public RuleDescriptionSectionBuilder htmlContent(String htmlContent) {
        this.htmlContent = htmlContent;
        return this;
    }

    public RuleDescriptionSectionBuilder htmlClasspathResourceUrl(URL htmlClasspathResourceUrl) {
        try {
            this.htmlContent(IOUtils.toString(htmlClasspathResourceUrl, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to read: " + htmlClasspathResourceUrl, e);
        }
        return this;
    }

    public RuleDescriptionSectionBuilder context(@Nullable Context context) {
        this.context = context;
        return this;
    }

    public RuleDescriptionSection build() {
        if (this.context == null) {
            return new DefaultRuleDescriptionSection(this.sectionKey, this.htmlContent);
        }
        return new ContextAwareRuleDescriptionSection(this.sectionKey, this.context, this.htmlContent);
    }
}

