/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.server.rule.StringPatternValidator;

public class Context {
    private static final StringPatternValidator CONTEXT_KEY_VALIDATOR = StringPatternValidator.validatorWithCommonPatternForKeys("context keys");
    private final String key;
    private final String displayName;

    public Context(String key, String displayName) {
        Context.failIfEmpty(key, "key must be provided and can't be empty");
        Context.failIfEmpty(displayName, "displayName must be provided and can't be empty");
        CONTEXT_KEY_VALIDATOR.validate(key);
        this.key = key;
        this.displayName = displayName;
    }

    public String getKey() {
        return this.key;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private static void failIfEmpty(String str, String msg) {
        if (StringUtils.isEmpty(str)) {
            throw new IllegalArgumentException(msg);
        }
    }
}

