/*
 * Decompiled with CFR 0.152.
 */
package org.quality.gates.jenkins.plugin;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import javax.inject.Inject;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.quality.gates.jenkins.plugin.JobConfigData;
import org.quality.gates.jenkins.plugin.JobConfigurationService;
import org.quality.gates.jenkins.plugin.JobExecutionService;
import org.quality.gates.jenkins.plugin.QGException;
import org.quality.gates.jenkins.plugin.QGPublisher;
import org.quality.gates.jenkins.plugin.SonarInstance;
import org.quality.gates.jenkins.plugin.enumeration.BuildStatusEnum;

@Extension
public final class QGPublisherDescriptor
extends BuildStepDescriptor<Publisher> {
    @Inject
    private JobConfigurationService jobConfigurationService;
    @Inject
    private JobExecutionService jobExecutionService;

    public QGPublisherDescriptor() {
        super(QGPublisher.class);
        this.load();
    }

    public QGPublisherDescriptor(JobExecutionService jobExecutionService, JobConfigurationService jobConfigurationService) {
        super(QGPublisher.class);
        this.jobExecutionService = jobExecutionService;
        this.jobConfigurationService = jobConfigurationService;
    }

    public JobExecutionService getJobExecutionService() {
        return this.jobExecutionService;
    }

    public ListBoxModel doFillSonarInstancesItems() {
        return this.jobConfigurationService.getListOfSonarInstanceNames(this.jobExecutionService.getGlobalConfigData());
    }

    public FormValidation doCheckProjectKey(@QueryParameter String projectKey) {
        if (projectKey.isEmpty()) {
            return FormValidation.error((String)"Please insert project key.");
        }
        return FormValidation.ok();
    }

    public ListBoxModel doFillBuildStatusItems() {
        ListBoxModel items = new ListBoxModel();
        Arrays.asList(BuildStatusEnum.values()).forEach(e -> items.add(e.toString()));
        return items;
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    @NonNull
    public String getDisplayName() {
        return "Quality Gates Sonarqube Plugin";
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        this.save();
        return true;
    }

    public QGPublisher newInstance(StaplerRequest2 req, JSONObject formData) throws QGException {
        JobConfigData firstInstanceJobConfigData = this.jobConfigurationService.createJobConfigData(formData, this.jobExecutionService.getGlobalConfigData());
        SonarInstance sonarInstance = this.jobExecutionService.getGlobalConfigData().getSonarInstanceByName(firstInstanceJobConfigData.getSonarInstanceName());
        return new QGPublisher(firstInstanceJobConfigData, sonarInstance);
    }
}

