/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.org.sonarqube.ws.thirdparty.com.google.common.cache;

import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;
import me.redaalaoui.org.sonarqube.ws.thirdparty.com.google.common.annotations.Beta;
import me.redaalaoui.org.sonarqube.ws.thirdparty.com.google.common.cache.AbstractCache;
import me.redaalaoui.org.sonarqube.ws.thirdparty.com.google.common.cache.LoadingCache;
import me.redaalaoui.org.sonarqube.ws.thirdparty.com.google.common.collect.ImmutableMap;
import me.redaalaoui.org.sonarqube.ws.thirdparty.com.google.common.collect.Maps;
import me.redaalaoui.org.sonarqube.ws.thirdparty.com.google.common.util.concurrent.UncheckedExecutionException;

@Beta
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (K key : keys) {
            if (result.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return ImmutableMap.copyOf(result);
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public void refresh(K key) {
        throw new UnsupportedOperationException();
    }
}

