/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.org.sonarqube.ws.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Optional;
import me.redaalaoui.org.sonarqube.ws.client.BaseResponse;
import me.redaalaoui.org.sonarqube.ws.thirdparty.okhttp3.Response;
import me.redaalaoui.org.sonarqube.ws.thirdparty.okhttp3.ResponseBody;

class OkHttpResponse
extends BaseResponse {
    private final Response okResponse;

    OkHttpResponse(Response okResponse) {
        this.okResponse = okResponse;
    }

    @Override
    public int code() {
        return this.okResponse.code();
    }

    @Override
    public String requestUrl() {
        return this.okResponse.request().url().toString();
    }

    @Override
    public String contentType() {
        return this.okResponse.header("Content-Type");
    }

    @Override
    public Optional<String> header(String name) {
        return Optional.ofNullable(this.okResponse.header(name));
    }

    @Override
    public InputStream contentStream() {
        return this.okResponse.body().byteStream();
    }

    @Override
    public Reader contentReader() {
        return this.okResponse.body().charStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String content() {
        try (ResponseBody body = this.okResponse.body();){
            String string = body.string();
            return string;
        }
        catch (IOException e) {
            throw this.fail(e);
        }
    }

    private RuntimeException fail(Exception e) {
        throw new IllegalStateException("Fail to read response of " + this.requestUrl(), e);
    }

    @Override
    public void close() {
        this.okResponse.close();
    }
}

