/*
 * Decompiled with CFR 0.152.
 */
package me.redaalaoui.org.sonarqube.ws.client;

import java.io.InputStream;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import me.redaalaoui.org.sonarqube.ws.client.BaseRequest;
import me.redaalaoui.org.sonarqube.ws.client.WsConnector;
import me.redaalaoui.org.sonarqube.ws.client.WsRequest;
import me.redaalaoui.org.sonarqube.ws.client.WsResponse;
import me.redaalaoui.org.sonarqube.ws.thirdparty.com.google.common.base.Preconditions;
import me.redaalaoui.org.sonarqube.ws.thirdparty.com.google.common.base.Strings;
import me.redaalaoui.org.sonarqube.ws.thirdparty.com.google.protobuf.Message;
import me.redaalaoui.org.sonarqube.ws.thirdparty.com.google.protobuf.Parser;
import me.redaalaoui.org.sonarqube.ws.thirdparty.org.apache.commons.io.IOUtils;

public abstract class BaseService {
    private final WsConnector wsConnector;
    protected final String controller;

    public BaseService(WsConnector wsConnector, String controllerPath) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(controllerPath));
        this.wsConnector = wsConnector;
        this.controller = controllerPath;
    }

    protected <T extends Message> T call(BaseRequest request, Parser<T> parser) {
        request.setMediaType("application/x-protobuf");
        WsResponse response = this.call(request);
        return BaseService.convert(response, parser);
    }

    protected WsResponse call(WsRequest request) {
        return this.wsConnector.call(request).failIfNotSuccessful();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Message> T convert(WsResponse response, Parser<T> parser) {
        try (InputStream byteStream = response.contentStream();){
            byte[] bytes = IOUtils.toByteArray(byteStream);
            Message message = (Message)parser.parseFrom(bytes);
            return (T)message;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to parse protobuf response of " + response.requestUrl(), e);
        }
    }

    protected String path(String action) {
        return String.format("%s/%s", this.controller, action);
    }

    @CheckForNull
    protected static String inlineMultipleParamValue(@Nullable Collection<String> values) {
        return values == null ? null : String.join((CharSequence)",", values);
    }
}

