/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar.pull_request_analysis;

import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import me.redaalaoui.org.sonarqube.ws.Issues;
import me.redaalaoui.org.sonarqube.ws.ProjectPullRequests;
import org.jenkinsci.plugins.sonargerrit.sonar.Components;
import org.jenkinsci.plugins.sonargerrit.sonar.Issue;
import org.jenkinsci.plugins.sonargerrit.sonar.Rule;
import org.jenkinsci.plugins.sonargerrit.sonar.Severity;
import org.jenkinsci.plugins.sonargerrit.util.UrlBuilder;

class PullRequestIssue
implements Issue {
    private final ProjectPullRequests.PullRequest pullRequest;
    private final Issues.Issue issue;
    private final String filePath;
    private final String sonarQubeUrl;

    public PullRequestIssue(ProjectPullRequests.PullRequest pullRequest, Components components, Issues.Issue issue, String sonarQubeUrl) {
        this.pullRequest = Objects.requireNonNull(pullRequest);
        this.issue = Objects.requireNonNull(issue);
        this.filePath = (String)components.buildPrefixedPathForComponentWithKey(issue.getComponent(), "").or((Object)issue.getComponent());
        this.sonarQubeUrl = Objects.requireNonNull(sonarQubeUrl);
    }

    @Override
    public String inspectorName() {
        return "Sonar";
    }

    @Override
    public String inspectionId() {
        return this.pullRequest.getKey();
    }

    @Override
    public Optional<String> detailUrl() {
        return Optional.of(new UrlBuilder().addSegment(this.sonarQubeUrl).addSegment("project").addSegment("issues").addQueryParameter("id", this.issue.getProject()).addQueryParameter("open", this.issue.getKey()).addQueryParameter("pullRequest", this.pullRequest.getKey()).build());
    }

    @Override
    public String getFilepath() {
        return this.filePath;
    }

    @Override
    public String getKey() {
        return this.issue.getKey();
    }

    @Override
    public String getComponent() {
        return this.issue.getComponent();
    }

    @Override
    public Integer getLine() {
        return this.issue.getLine();
    }

    @Override
    public String getMessage() {
        return this.issue.getMessage();
    }

    @Override
    public Severity getSeverity() {
        return Severity.valueOf(this.issue.getSeverity().name());
    }

    @Override
    public String getRule() {
        return this.issue.getRule();
    }

    @Override
    public String getRuleUrl() {
        return new Rule(this.issue.getRule()).createUrl(this.sonarQubeUrl);
    }

    @Override
    public String getStatus() {
        return this.issue.getStatus();
    }

    @Override
    public boolean isNew() {
        return true;
    }

    @Override
    public Date getCreationDate() {
        return Date.from(ZonedDateTime.parse(this.issue.getCreationDate()).toInstant());
    }
}

