/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis;

import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import org.jenkinsci.plugins.sonargerrit.sonar.Components;
import org.jenkinsci.plugins.sonargerrit.sonar.Issue;
import org.jenkinsci.plugins.sonargerrit.sonar.Rule;
import org.jenkinsci.plugins.sonargerrit.sonar.Severity;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.IssueRepresentation;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SubJobConfig;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class SimpleIssue
implements Issue {
    private final IssueRepresentation representation;
    private final Components components;
    private final SubJobConfig config;
    private final String sonarQubeUrl;
    private String filepath;

    public SimpleIssue(IssueRepresentation representation, Components components, SubJobConfig config, String sonarQubeUrl) {
        this.representation = representation;
        this.components = components;
        this.config = config;
        this.sonarQubeUrl = sonarQubeUrl;
    }

    @Override
    public String getRuleUrl() {
        return new Rule(this.getRule()).createUrl(this.sonarQubeUrl);
    }

    @Override
    public String inspectorName() {
        return "Sonar";
    }

    @Override
    public String inspectionId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public Optional<String> detailUrl() {
        return Optional.empty();
    }

    @Override
    public String getFilepath() {
        if (this.filepath == null) {
            this.filepath = this.components != null ? (String)this.components.buildPrefixedPathForComponentWithKey(this.getComponent(), this.config.getProjectPath()).or((Object)this.getComponent()) : this.getComponent();
        }
        return this.filepath;
    }

    public void setFilepath(String filepath) {
        this.filepath = filepath;
    }

    @Override
    public String getKey() {
        return this.representation.getKey();
    }

    @Override
    public String getComponent() {
        return this.representation.getComponent();
    }

    @Override
    public Integer getLine() {
        return this.representation.getLine();
    }

    @Override
    public String getMessage() {
        return this.representation.getMessage();
    }

    @Override
    public Severity getSeverity() {
        return this.representation.getSeverity();
    }

    @Override
    public String getRule() {
        return this.representation.getRule();
    }

    @Override
    public String getStatus() {
        return this.representation.getStatus();
    }

    @Override
    public boolean isNew() {
        return this.representation.isNew();
    }

    @Override
    public Date getCreationDate() {
        return this.representation.getCreationDate();
    }
}

