/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis;

import com.google.common.base.MoreObjects;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.SonarGlobalConfiguration;
import hudson.plugins.sonar.SonarInstallation;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.sonargerrit.gerrit.Revision;
import org.jenkinsci.plugins.sonargerrit.sonar.AnalysisStrategy;
import org.jenkinsci.plugins.sonargerrit.sonar.InspectionReport;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SonarConnector;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SonarQubeInstallations;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SubJobConfig;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class PreviewModeAnalysisStrategy
extends AbstractDescribableImpl<PreviewModeAnalysisStrategy>
implements AnalysisStrategy {
    private String sonarQubeInstallationName;
    private SubJobConfig baseConfig;
    @Nonnull
    private Collection<SubJobConfig> subJobConfigs = new LinkedList<SubJobConfig>();
    private String type;

    @DataBoundConstructor
    public PreviewModeAnalysisStrategy() {
        this.setBaseConfig(null);
        this.setSubJobConfigs(null);
        this.setType("base");
    }

    public String getSonarQubeInstallationName() {
        return this.sonarQubeInstallationName;
    }

    public Optional<SonarInstallation> getSonarQubeInstallation() {
        return Optional.ofNullable(this.sonarQubeInstallationName).flatMap(name -> SonarQubeInstallations.get().byName((String)name));
    }

    @DataBoundSetter
    public void setSonarQubeInstallationName(String sonarQubeInstallationName) {
        this.sonarQubeInstallationName = (String)StringUtils.defaultIfBlank((CharSequence)sonarQubeInstallationName, null);
    }

    public SubJobConfig getBaseConfig() {
        return this.baseConfig;
    }

    @DataBoundSetter
    public void setBaseConfig(SubJobConfig baseConfig) {
        this.baseConfig = (SubJobConfig)((Object)MoreObjects.firstNonNull((Object)((Object)baseConfig), (Object)((Object)new SubJobConfig())));
    }

    public Collection<SubJobConfig> getSubJobConfigs() {
        return this.subJobConfigs;
    }

    public Collection<SubJobConfig> getAllSubJobConfigs() {
        return this.isMultiConfigMode() ? this.subJobConfigs : Collections.singletonList(this.baseConfig);
    }

    public boolean isType(String type) {
        return this.type.equalsIgnoreCase(type);
    }

    @DataBoundSetter
    public void setType(String type) {
        if (DescriptorImpl.ALLOWED_TYPES.contains(type)) {
            this.type = type;
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean isMultiConfigMode() {
        return this.isType("multi");
    }

    public boolean isAutoMatch() {
        return !this.isMultiConfigMode() && this.baseConfig.isAutoMatch();
    }

    @DataBoundSetter
    public void setAutoMatch(boolean autoMatch) {
        if (!this.isMultiConfigMode()) {
            this.baseConfig.setAutoMatch(autoMatch);
        }
    }

    @DataBoundSetter
    public void setSubJobConfigs(Collection<SubJobConfig> subJobConfigs) {
        if (subJobConfigs != null && !subJobConfigs.isEmpty()) {
            this.subJobConfigs = new LinkedList<SubJobConfig>(subJobConfigs);
        } else {
            this.subJobConfigs = new LinkedList<SubJobConfig>();
            this.subJobConfigs.add(new SubJobConfig());
        }
    }

    public boolean isPathCorrectionNeeded() {
        return this.isAutoMatch();
    }

    @Override
    public InspectionReport analyse(Run<?, ?> run, TaskListener listener, Revision revision, FilePath workspace) throws IOException, InterruptedException {
        return new SonarConnector(listener, this, revision, this.getSonarQubeInstallation().orElse(null)).readSonarReports(workspace);
    }

    @Symbol(value={"previewMode"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<PreviewModeAnalysisStrategy> {
        public static final String SONAR_URL = "http://localhost:9000";
        public static final String BASE_TYPE = "base";
        public static final String MULTI_TYPE = "multi";
        public static final String DEFAULT_INSPECTION_CONFIG_TYPE = "base";
        public static final boolean AUTO_MATCH = false;
        private static final Set<String> ALLOWED_TYPES = new HashSet<String>(Arrays.asList("base", "multi"));

        public FormValidation doCheckSonarQubeInstallationName(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public ListBoxModel doFillSonarQubeInstallationNameItems() {
            return Stream.of(SonarGlobalConfiguration.get().getInstallations()).map(SonarInstallation::getName).map(ListBoxModel.Option::new).collect(Collectors.collectingAndThen(Collectors.toList(), ListBoxModel::new));
        }

        public String getDisplayName() {
            return "Preview mode analysis (until SonarQube 7.6)";
        }
    }
}

