/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class DateTypeConverter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    private static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final String PATTERN_ISO8601 = "yyyy-MM-dd'T'hh:mm:ssz";
    private static final Logger LOGGER = Logger.getLogger(DateTypeConverter.class.getName());

    DateTypeConverter() {
    }

    public JsonElement serialize(Date src, Type srcType, JsonSerializationContext context) {
        SimpleDateFormat formatter = new SimpleDateFormat(PATTERN_RFC1123);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return new JsonPrimitive(formatter.format(src));
    }

    public Date deserialize(JsonElement json, Type type, JsonDeserializationContext context) {
        String str = json.getAsString();
        if (str.length() > 1 && str.startsWith("'") && str.endsWith("'")) {
            str = str.substring(1, str.length() - 1);
        }
        SimpleDateFormat dateParser = null;
        ArrayList<ParseException> exceptions = new ArrayList<ParseException>();
        for (String format : Arrays.asList(PATTERN_ASCTIME, PATTERN_RFC1036, PATTERN_RFC1123, PATTERN_ISO8601)) {
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(format);
                dateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
                Calendar calendar = Calendar.getInstance();
                calendar.set(2000, 0, 1, 0, 0);
                dateParser.set2DigitYearStart(calendar.getTime());
            } else {
                dateParser.applyPattern(format);
            }
            try {
                return dateParser.parse(str);
            }
            catch (ParseException e) {
                exceptions.add(e);
            }
        }
        JsonParseException e = new JsonParseException("Unable to parse the date " + str);
        for (ParseException exception : exceptions) {
            e.addSuppressed((Throwable)exception);
        }
        LOGGER.log(Level.WARNING, "An exception occurred on DateTypeConverter", (Throwable)e);
        throw e;
    }
}

