/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar;

import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.SonarInstallation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.sonargerrit.gerrit.Revision;
import org.jenkinsci.plugins.sonargerrit.sonar.AnalysisStrategy;
import org.jenkinsci.plugins.sonargerrit.sonar.InspectionReport;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.PreviewModeAnalysisStrategy;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SonarQubeInstallations;
import org.jenkinsci.plugins.sonargerrit.sonar.preview_mode_analysis.SubJobConfig;
import org.jenkinsci.plugins.sonargerrit.sonar.pull_request_analysis.PullRequestAnalysisStrategy;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class Inspection
extends AbstractDescribableImpl<Inspection> {
    private transient String serverURL;
    private transient String sonarQubeInstallationName;
    private transient SubJobConfig baseConfig;
    private transient Collection<SubJobConfig> subJobConfigs;
    private transient String type;
    private AnalysisStrategy analysisStrategy = new PreviewModeAnalysisStrategy();

    protected Object readResolve() {
        if (this.baseConfig == null && this.subJobConfigs == null && this.type == null && this.serverURL == null && this.sonarQubeInstallationName == null) {
            return this;
        }
        PreviewModeAnalysisStrategy previewModeAnalysisStrategy = new PreviewModeAnalysisStrategy();
        this.analysisStrategy = previewModeAnalysisStrategy;
        Optional.ofNullable(this.baseConfig).ifPresent(previewModeAnalysisStrategy::setBaseConfig);
        Optional.ofNullable(this.subJobConfigs).ifPresent(previewModeAnalysisStrategy::setSubJobConfigs);
        Optional.ofNullable(this.type).ifPresent(previewModeAnalysisStrategy::setType);
        Optional.ofNullable(this.serverURL).map(url -> SonarQubeInstallations.get().findOrCreate(this.serverURL).getName()).ifPresent(previewModeAnalysisStrategy::setSonarQubeInstallationName);
        Optional.ofNullable(this.sonarQubeInstallationName).ifPresent(previewModeAnalysisStrategy::setSonarQubeInstallationName);
        this.baseConfig = null;
        this.subJobConfigs = null;
        this.type = null;
        this.serverURL = null;
        this.sonarQubeInstallationName = null;
        return this;
    }

    @DataBoundConstructor
    public Inspection() {
    }

    public InspectionReport analyse(Run<?, ?> run, TaskListener listener, Revision revision, FilePath workspace) throws IOException, InterruptedException {
        return this.analysisStrategy.analyse(run, listener, revision, workspace);
    }

    public AnalysisStrategy getAnalysisStrategy() {
        return this.analysisStrategy;
    }

    @DataBoundSetter
    public void setAnalysisStrategy(AnalysisStrategy analysisStrategy) {
        this.analysisStrategy = analysisStrategy;
    }

    @Deprecated
    @Nullable
    public String getSonarQubeInstallationName() {
        return this.getOrSpawnPreviewModeAnalysisStrategy().getSonarQubeInstallationName();
    }

    @Deprecated
    @DataBoundSetter
    public void setSonarQubeInstallationName(String name) {
        this.getOrSetPreviewModeAnalysisStrategy().setSonarQubeInstallationName(name);
    }

    @Deprecated
    @Nonnull
    public String getServerURL() {
        return this.getOrSpawnPreviewModeAnalysisStrategy().getSonarQubeInstallation().map(SonarInstallation::getServerUrl).orElse("http://localhost:9000");
    }

    @Deprecated
    @DataBoundSetter
    public void setServerURL(String serverURL) {
        String installationName = Optional.ofNullable(serverURL).filter(StringUtils::isNotBlank).map(name -> SonarQubeInstallations.get().findOrCreate((String)name)).map(SonarInstallation::getName).orElse(null);
        this.getOrSetPreviewModeAnalysisStrategy().setSonarQubeInstallationName(installationName);
    }

    @Deprecated
    public SubJobConfig getBaseConfig() {
        return this.getOrSpawnPreviewModeAnalysisStrategy().getBaseConfig();
    }

    @Deprecated
    @DataBoundSetter
    public void setBaseConfig(SubJobConfig baseConfig) {
        this.getOrSetPreviewModeAnalysisStrategy().setBaseConfig(baseConfig);
    }

    @Deprecated
    public Collection<SubJobConfig> getSubJobConfigs() {
        return this.getOrSpawnPreviewModeAnalysisStrategy().getSubJobConfigs();
    }

    @Deprecated
    @DataBoundSetter
    public void setSubJobConfigs(Collection<SubJobConfig> subJobConfigs) {
        this.getOrSetPreviewModeAnalysisStrategy().setSubJobConfigs(subJobConfigs);
    }

    @Deprecated
    @DataBoundSetter
    public void setType(String type) {
        this.getOrSetPreviewModeAnalysisStrategy().setType(type);
    }

    @Deprecated
    public String getType() {
        return this.getOrSpawnPreviewModeAnalysisStrategy().getType();
    }

    @Deprecated
    public boolean isAutoMatch() {
        return this.getOrSpawnPreviewModeAnalysisStrategy().isAutoMatch();
    }

    @Deprecated
    @DataBoundSetter
    public void setAutoMatch(boolean autoMatch) {
        this.getOrSetPreviewModeAnalysisStrategy().setAutoMatch(autoMatch);
    }

    private PreviewModeAnalysisStrategy getOrSpawnPreviewModeAnalysisStrategy() {
        if (this.analysisStrategy instanceof PreviewModeAnalysisStrategy) {
            return (PreviewModeAnalysisStrategy)this.analysisStrategy;
        }
        return new PreviewModeAnalysisStrategy();
    }

    private PreviewModeAnalysisStrategy getOrSetPreviewModeAnalysisStrategy() {
        if (this.analysisStrategy instanceof PreviewModeAnalysisStrategy) {
            return (PreviewModeAnalysisStrategy)this.analysisStrategy;
        }
        PreviewModeAnalysisStrategy previewModeAnalysisStrategy = new PreviewModeAnalysisStrategy();
        this.analysisStrategy = new PreviewModeAnalysisStrategy();
        return previewModeAnalysisStrategy;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Inspection> {
        public List<Descriptor<?>> getAnalysisStrategyDescriptors() {
            Jenkins jenkins = Jenkins.get();
            return ImmutableList.of((Object)jenkins.getDescriptorOrDie(PullRequestAnalysisStrategy.class), (Object)jenkins.getDescriptorOrDie(PreviewModeAnalysisStrategy.class));
        }

        public String getDisplayName() {
            return "Inspection";
        }
    }
}

