/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.sonar;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jenkinsci.plugins.sonargerrit.sonar.Issue;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ByChangedLinesPredicate
implements Predicate<Issue> {
    private final Map<String, Set<Integer>> allowedFilesAndLines;

    private ByChangedLinesPredicate(Map<String, Set<Integer>> allowedFilesAndLines) {
        if (allowedFilesAndLines != null) {
            this.allowedFilesAndLines = new HashMap<String, Set<Integer>>();
            this.allowedFilesAndLines.putAll(allowedFilesAndLines);
        } else {
            this.allowedFilesAndLines = null;
        }
    }

    public boolean apply(Issue issue) {
        String filepath = issue.getFilepath();
        return this.allowedFilesAndLines == null || this.allowedFilesAndLines.containsKey(filepath) && this.isLineChanged(issue.getLine(), this.allowedFilesAndLines.get(filepath));
    }

    private boolean isLineChanged(Integer line, Set<Integer> changedLines) {
        return changedLines.contains(line);
    }

    public static ByChangedLinesPredicate apply(Map<String, Set<Integer>> allowedComponents) {
        return new ByChangedLinesPredicate(allowedComponents);
    }
}

