/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sonargerrit.gerrit;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.NotifyHandling;
import me.redaalaoui.gerrit_rest_java_client.thirdparty.com.google.gerrit.extensions.api.changes.ReviewInput;
import org.jenkinsci.plugins.sonargerrit.gerrit.CustomIssueFormatter;
import org.jenkinsci.plugins.sonargerrit.gerrit.CustomReportFormatter;
import org.jenkinsci.plugins.sonargerrit.gerrit.NotificationConfig;
import org.jenkinsci.plugins.sonargerrit.gerrit.ReviewConfig;
import org.jenkinsci.plugins.sonargerrit.gerrit.ScoreConfig;
import org.jenkinsci.plugins.sonargerrit.sonar.Issue;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class GerritReviewBuilder {
    private final Multimap<String, Issue> finalIssuesToComment;
    private final Multimap<String, Issue> finalIssuesToScore;
    private final ReviewConfig reviewConfig;
    private final ScoreConfig scoreConfig;
    private final NotificationConfig notificationConfig;

    public GerritReviewBuilder(Multimap<String, Issue> finalIssuesToComment, Multimap<String, Issue> finalIssuesToScore, ReviewConfig reviewConfig, ScoreConfig scoreConfig, NotificationConfig notificationConfig) {
        this.finalIssuesToComment = finalIssuesToComment;
        this.finalIssuesToScore = finalIssuesToScore;
        this.reviewConfig = reviewConfig;
        this.scoreConfig = scoreConfig;
        this.notificationConfig = notificationConfig;
    }

    public ReviewInput buildReview() {
        String reviewMessage = this.getReviewMessage(this.finalIssuesToComment);
        ReviewInput reviewInput = new ReviewInput().message(reviewMessage);
        reviewInput.tag = "autogenerated:sonar";
        reviewInput.omitDuplicateComments = this.reviewConfig.isOmitDuplicateComments();
        switch (this.reviewConfig.getCommentType()) {
            case STANDARD: {
                reviewInput.comments = this.generateComments().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList((Collection)entry.getValue())));
                break;
            }
            case ROBOT: {
                reviewInput.robotComments = this.generateComments();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected comment type " + String.valueOf((Object)this.reviewConfig.getCommentType()));
            }
        }
        int score = 0;
        if (this.postScore()) {
            score = this.getReviewMark(this.finalIssuesToScore.size());
            String category = this.scoreConfig.getCategory();
            reviewInput.label(category, score);
        }
        reviewInput.notify = this.getNotificationSettings(this.finalIssuesToComment.size(), score);
        return reviewInput;
    }

    private boolean postScore() {
        return this.scoreConfig != null;
    }

    private String getReviewMessage(Multimap<String, Issue> finalIssues) {
        return new CustomReportFormatter(finalIssues.values(), this.reviewConfig.getSomeIssuesTitleTemplate(), this.reviewConfig.getNoIssuesTitleTemplate()).getMessage();
    }

    private int getReviewMark(int finalIssuesCount) {
        return finalIssuesCount > 0 ? this.scoreConfig.getIssuesScore() : this.scoreConfig.getNoIssuesScore();
    }

    private NotifyHandling getNotificationSettings(int commentsCount, int score) {
        if (score < 0) {
            return NotifyHandling.valueOf((String)this.notificationConfig.getNegativeScoreNotificationRecipient());
        }
        if (commentsCount > 0) {
            return NotifyHandling.valueOf((String)this.notificationConfig.getCommentedIssuesNotificationRecipient());
        }
        return NotifyHandling.valueOf((String)this.notificationConfig.getNoIssuesNotificationRecipient());
    }

    private Map<String, List<ReviewInput.RobotCommentInput>> generateComments() {
        HashMap<String, List<ReviewInput.RobotCommentInput>> file2comments = new HashMap<String, List<ReviewInput.RobotCommentInput>>();
        for (String file : this.finalIssuesToComment.keySet()) {
            Collection issues = this.finalIssuesToComment.get((Object)file);
            Collection comments = Collections2.transform((Collection)issues, this::createComment);
            ArrayList commentList = Lists.newArrayList((Iterable)comments);
            file2comments.put(file, commentList);
        }
        return file2comments;
    }

    private ReviewInput.RobotCommentInput createComment(@Nullable Issue input) {
        if (input == null) {
            return null;
        }
        String commentTemplate = this.reviewConfig.getIssueCommentTemplate();
        String message = new CustomIssueFormatter(input, commentTemplate).getMessage();
        ReviewInput.RobotCommentInput commentInput = new ReviewInput.RobotCommentInput();
        commentInput.id = input.getKey();
        commentInput.line = input.getLine();
        commentInput.message = message;
        commentInput.unresolved = true;
        commentInput.robotId = input.inspectorName();
        commentInput.robotRunId = input.inspectionId();
        input.detailUrl().ifPresent(detailUrl -> {
            commentInput.url = detailUrl;
        });
        return commentInput;
    }
}

